<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>芯片变更管理管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogchipchangemanage/dogChipChange/">芯片变更管理列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogChipChange" action="${ctx}/dogchipchangemanage/dogChipChange/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>旧芯片号：</label>
				<form:input path="chipCodeOld" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>新芯片号：</label>
				<form:input path="chipCodeNew" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>缴费会员号：</label>
				<form:input path="paymentMemberCode" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>流水号：</label>
				<form:input path="runningNumber" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>流程状态：</label>
				<form:select path="processState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('proccess_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>旧芯片号</th>
				<th>新芯片号</th>
				<th>缴费会员号</th>
				<th>流水号</th>
				<th>付款的状态</th>
				<th>流程状态</th>
				<shiro:hasPermission name="dogchipchangemanage:dogChipChange:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogChipChange">
			<tr>
				<td>
					${dogChipChange.chipCodeOld}
				</td>
				<td>
					${dogChipChange.chipCodeNew}
				</td>
				<td>
					${dogChipChange.paymentMemberCode}
				</td>
				<td>
					${dogChipChange.runningNumber}
				</td>
				<td>
					<c:if test="${dogChipChange.paymentState==1}"><font color="red">${fns:getDictLabel(dogChipChange.paymentState, 'user_payment_state', '')}</font></c:if>
					<c:if test="${dogChipChange.paymentState==2}"><font color="green">${fns:getDictLabel(dogChipChange.paymentState, 'user_payment_state', '')}</font></c:if>
				</td>
				<td>
				<c:if test="${dogChipChange.processState==0}"><a onclick="changeProcessState('${dogChipChange.id}')">
					${fns:getDictLabel(dogChipChange.processState, 'proccess_state', '')}</a></c:if>
					<c:if test="${dogChipChange.processState==1}">${fns:getDictLabel(dogChipChange.processState, 'proccess_state', '')}</c:if>
				</td>
				<shiro:hasPermission name="dogchipchangemanage:dogChipChange:edit"><td>
    				<a href="${ctx}/dogchipchangemanage/dogChipChange/form?id=${dogChipChange.id}">修改</a>
					<a href="${ctx}/dogchipchangemanage/dogChipChange/delete?id=${dogChipChange.id}" onclick="return confirmx('确认要删除该芯片变更管理吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>