<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>繁育证书订单录入</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					$.post('${ctx}/dogbreed/dogBreedCertified/add',
                            $('#inputForm').serialize(),
                    function(data) {
                        if(data.rc==0){
                            alert("订单录入成功！");
                            parent.isYes = true;
                            parent.layer.closeAll();
                        }else{
                            alert("提交失败,错误信息："+data.msg);
                        } 
                    });
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function closeLayer(){
			parent.layer.closeAll();
		}
		function getDogByPedigreeCertified(){
			var pedigreeCertified = $("#pedigreeCertified").val();
			if(pedigreeCertified==''){
				alert("请填写血统证书号！");
		    	$('#dogId').val('');
				return;
			}
		    $.post('${ctx}/dogexport/dogPedigreeCertifiedExport/getDogByPedigreeCertified', {
		    	pedigreeCertified: pedigreeCertified
		    }, function(data) {
		    	console.log(data);
		    	if(data.dogOwnerMemberCode==undefined){
		    		alert("证书号无效！");
		    		$('#dogId').val("");
                    $("#nameEn").val();
                    $("#birthdate").val("");
                    $("#gender").val("");
                    $("#colorFlag").val("");
                    $("#identificationFlag").val("");
                    $("#DNA").val("");
		    	}
		    	else if(data.dogBreed == '西藏獒犬'){
		    		if(data.MonthAge=="false"){
		    			alert("犬只不满足月龄不足15个月！");
			    		$('#dogId').val("");
	                    $("#nameEn").val();
	                    $("#birthdate").val("");
	                    $("#gender").val("");
	                    $("#colorFlag").val("");
	                    $("#identificationFlag").val("");
	                    $("#DNA").val("");	
		    		}else{
		    			$('#dogId').val(data.dogId);
				    	$("#nameEn").val(data.nameEn);
				    	$("#birthdate").val(data.birthdate);
				    	$("#gender").val(data.gender);
				    	$("#colorFlag").val(data.colorFlag);
				    	$("#identificationFlag").val(data.identificationFlag);
				    	$("#DNA").val(data.DNA);
		    		}
		    	}
		    	else if(data.dogGeneration=="false"||data.MonthAge=="false"){
		    		alert("犬只不满足3代血统或月龄不足15个月！");
		    		$('#dogId').val("");
                    $("#nameEn").val();
                    $("#birthdate").val("");
                    $("#gender").val("");
                    $("#colorFlag").val("");
                    $("#identificationFlag").val("");
                    $("#DNA").val("");
		    	} else if(data.dogOwnerMemberCode!=$("#memberCode").val()){
		    		alert("犬主与付款会员不一致！");
                    $('#dogId').val("");
                    $("#nameEn").val();
                    $("#birthdate").val("");
                    $("#gender").val("");
                    $("#colorFlag").val("");
                    $("#identificationFlag").val("");
                    $("#DNA").val("");
		    	} else {
			    	$('#dogId').val(data.dogId);
			    	$("#nameEn").val(data.nameEn);
			    	$("#birthdate").val(data.birthdate);
			    	$("#gender").val(data.gender);
			    	$("#colorFlag").val(data.colorFlag);
			    	$("#identificationFlag").val(data.identificationFlag);
			    	$("#DNA").val(data.DNA);
		    	}
		    });
		}
	</script>
	<style>
		form{
			padding-top: 20px;
		}
		.control-group{
			border-bottom: 0px;
		}
	</style>
</head>
<body>


<form:form id="inputForm" modelAttribute="dogBreedCertified" class="form-horizontal">
	<form:hidden path="id"/>
        <form:hidden path="runningNumber"/>
        <input type="hidden" id="memberCode" name="memberCode" value="${memberCode}"/>
        <div class="control-group">
            <label class="control-label">犬只id：</label>
            <div class="controls">
                <form:input path="dogId" htmlEscape="false" maxlength="64" class="input-xlarge required" readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">血统证书号：</label>
            <div class="controls">
                <form:input id="pedigreeCertified" path="dog.pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge "/>
                <input id="btnCancel" class="btn btn-primary" type="button" value="查询" onclick="getDogByPedigreeCertified()"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">犬名：</label>
            <div class="controls">
                <input id="nameEn"  type="text" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">出生日期：</label>
            <div class="controls">
                <input id="birthdate" name="birthdate" type="text" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">性别：</label>
            <div class="controls">
                <input id="gender" name="gender"  type="text" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">毛色：</label>
            <div class="controls">
                <input id="colorFlag" name="colorFlag"  type="text" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">身份识别标志：</label>
            <div class="controls">
                <input id="identificationFlag" name="identificationFlag" type="text" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">DNA：</label>
            <div class="controls">
                <input id="DNA" name="DNA" type="text" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">繁育期限：</label>
            <div class="controls">
                <input id="breedDeadline" name="breedDeadline" value="终身" type="text" htmlEscape="false" maxlength="20" class="input-xlarge ">
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">繁育鉴定日期：</label>
            <div class="controls">
                <input name="breedIdentifyTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                    value="<fmt:formatDate value="${dogBreedCertified.breedIdentifyTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                    onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">繁育鉴定地点：</label>
            <div class="controls">
                <form:input path="breedIdentifyLocation" htmlEscape="false" maxlength="100" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">繁育鉴定裁判：</label>
            <div class="controls">
                <form:input path="breedIdentifyReferee" htmlEscape="false" maxlength="100" class="input-xlarge "/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">种犬繁育的意见：</label>
            <div class="controls">
                <form:textarea path="suggestionsOnBreeding" htmlEscape="false" rows="3" class="input-xxlarge " style="width:270px;"/>
            </div>
        </div>
        <div class="form-actions">
            <shiro:hasPermission name="dogbreed:dogBreedCertified:add"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存""/>&nbsp;</shiro:hasPermission>
            <input id="btnCancel" class="btn" type="button" value="关闭" onclick="closeLayer()"/>
        </div>
</form:form>
</body>
</html>