<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>鼻纹识别管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dog/dogNoseResult/">鼻纹识别列表</a></li>
		<shiro:hasPermission name="dog:dogNoseResult:edit"><li><a href="${ctx}/dog/dogNoseResult/form">鼻纹识别添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogNoseResult" action="${ctx}/dog/dogNoseResult/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
		
			<li><label style="width: 140px">芯片号/鼻纹编号:</label>
                <form:input path="dogChip" htmlEscape="false" maxlength="64" class="input-medium"/>
            </li>
            
            <li><label>识别类型：</label>
				<form:select path="noseType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="1" label="1:1"/>
					<form:option value="2" label="1:N"/>
				</form:select>
			</li>
			
			<li><label>识别设备：</label>
				<form:select path="deviceType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="IOS" label="IOS"/>
					<form:option value="Android" label="Android"/>
				</form:select>
			</li>
			
			<li><label>识别结果：</label>
				<form:select path="noseResult" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="0" label="匹配成功"/>
					<form:option value="1" label="匹配失败"/>
				</form:select>
			</li>
			
			<li><label>1:N次序：</label>
				<form:select path="successSort" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="TOP1" label="TOP1"/>
					<form:option value="TOP2" label="TOP2"/>
					<form:option value="TOP3" label="TOP3"/>
				</form:select>
			</li>
			
			
			<li><label>采集日期:</label>
				<input name="beginCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogNoseResult.beginCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endCreateDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					   value="<fmt:formatDate value="${dogNoseResult.endCreateDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>鼻纹编号</th>
				<th>芯片编号</th>
				<th>识别类型</th>
				<th>识别时间</th>
				<th>识别设备</th>
				<th>设备信息</th>
				<th>用户账号</th>
				<th>识别结果</th>
				<th>1:N成功次序</th>
				<th>1:N信息</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogNoseResult">
			<tr>
				<td>
					${fns:escapeHtml(dogNoseResult.dogNose)}
				</td>
				<td>
					${fns:escapeHtml(dogNoseResult.dogChip)}
				</td>
				<td>
					<c:if test="${dogNoseResult.noseType=='1'}">1:1</c:if>
					<c:if test="${dogNoseResult.noseType=='2'}">1:N</c:if>
				</td>
				<td>
					<fmt:formatDate value="${dogNoseResult.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogNoseResult.deviceType)}
				</td>
				<td>
					${fns:escapeHtml(dogNoseResult.deviceModel)}
				</td>
				<td>
					${fns:escapeHtml(dogNoseResult.clubCode)}
				</td>
				<td>
					<c:if test="${dogNoseResult.noseResult=='0'}">匹配成功</c:if>
					<c:if test="${dogNoseResult.noseResult=='1'}">匹配失败</c:if>
				</td>
				<td>
					<c:if test="${dogNoseResult.noseType=='2' && dogNoseResult.noseResult=='0'}">
						${fns:escapeHtml(dogNoseResult.successSort)}
					</c:if>
				</td>
				<td>
					<c:if test="${dogNoseResult.noseType=='2'}">
						${fns:escapeHtml(dogNoseResult.noseResultInfo)}
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>