<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>白名单表管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {

        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctx}/whitelist/whitelist/">白名单表列表</a></li>
    <shiro:hasPermission name="whitelist:whitelist:edit">
        <li><a href="${ctx}/whitelist/whitelist/form">白名单表添加</a></li>
    </shiro:hasPermission>
</ul>
<form:form id="searchForm" modelAttribute="whitelist" action="${ctx}/whitelist/whitelist/" method="post"
           class="breadcrumb form-search">
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>会员号：</label>
            <form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
        </li>
        <li><label>模块：</label>
            <form:input path="module" htmlEscape="false" maxlength="50" class="input-medium"/>
        </li>
        <li><label>白名单开始时间：</label>
            <input name="startTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${whitelist.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
        </li>
        <li><label>白名单结束时间：</label>
            <input name="endTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${whitelist.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>用户id</th>
        <th>会员号</th>
        <th>模块</th>
        <th>白名单开始时间</th>
        <th>白名单结束时间</th>
        <th>修改时间</th>
        <th>备注信息</th>
        <shiro:hasPermission name="whitelist:whitelist:edit">
            <th>操作</th>
        </shiro:hasPermission>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="whitelist">
        <tr>
            <td><a href="${ctx}/whitelist/whitelist/form?id=${whitelist.id}">
                    ${whitelist.user.name}
            </a></td>
            <td>
                    ${whitelist.memberCode}
            </td>
            <td>
                    ${whitelist.module}
            </td>
            <td>
                <fmt:formatDate value="${whitelist.startTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${whitelist.endTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                <fmt:formatDate value="${whitelist.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
            </td>
            <td>
                    ${whitelist.remarks}
            </td>
            <shiro:hasPermission name="whitelist:whitelist:edit">
                <td>
                    <a href="${ctx}/whitelist/whitelist/form?id=${whitelist.id}">修改</a>
                    <a href="${ctx}/whitelist/whitelist/delete?id=${whitelist.id}"
                       onclick="return confirmx('确认要删除该白名单表吗？', this.href)">删除</a>
                </td>
            </shiro:hasPermission>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>