<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>课程管理</title>
	<meta name="decorator" content="default"/>
	<script src="${ctxStatic}/jquery-validation/1.11.0/lib/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});

			$("#btnSubmit").click(function () {
				if (!$("#courseCode").val().match(/^[0-9A-Za-z]{8}$/)) {
					alert("编号只能为8位数字或字母");
					return;
				}
				//提交
				$("#inputForm").ajaxSubmit({
					dataType: 'json',
					beforeSubmit: function () {
						if (!$("#inputForm").valid()) {
							return false;
						}
					},
					success: function (data) {
						if (data.rc == 0) {
							layer.msg("保存成功！");
							window.location = "${ctx}/appreciation/appreciationCourses/"
						} else {
							layer.msg(data.msg);
						}
					},
					error: function (err) {
						layer.msg("操作失败!");
					}
				});
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/appreciation/appreciationCourses/">课程管理列表</a></li>
		<li class="active">
			<a href="${ctx}/appreciation/appreciationCourses/editForm?id=${appreciationCourses.id}">课程<shiro:hasPermission name="appreciation:appreciationCourses:edit">${not empty appreciationCourses.id?'修改':'添加'}</shiro:hasPermission>
			</a>
		</li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="appreciationCourses" action="${ctx}/appreciation/appreciationCourses/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">课程编号：</label>
			<div class="controls">
				<form:input path="courseCode" htmlEscape="false" onkeyup="value=value.replace(/[^\w\.\/]/ig,'')" maxlength="8" class="input-xlarge required" placeholder="8位数字或字母组合"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程名称：</label>
			<div class="controls">
				<form:input path="courseName" htmlEscape="false" maxlength="50" class="input-xlarge required" placeholder="20个以内汉字或50以内英文及数字"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程时间：</label>
			<div class="controls">
				<input name="startDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${appreciationCourses.startDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
				至
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					   value="<fmt:formatDate value="${appreciationCourses.endDate}" pattern="yyyy-MM-dd"/>"
					   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">讲师：</label>
			<div class="controls">
				<form:input path="teacher" htmlEscape="false" maxlength="50" class="input-xlarge required" placeholder="请输入,多位老师使用逗号分隔"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">报名上限：</label>
			<div class="controls">
				<form:input path="maxNum" htmlEscape="false" min="1" max="9999" class="input-xlarge  digits required" placeholder="1-9999"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">课程地点：</label>
			<div class="controls">
				<form:input path="courseLocation" htmlEscape="false" maxlength="100" class="input-xlarge required" placeholder="请输入"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">合作方：</label>
			<div class="controls">
				<form:input path="coursePartner" htmlEscape="false" maxlength="100" class="input-xlarge required" placeholder="请输入"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="appreciation:appreciationCourses:edit">
				<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;
			</shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>