package com.ufida.api.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * 分录条目
 * @author Sunny
 *
 */
public class EntryVo implements Serializable {

	private static final long serialVersionUID = -4097040405357305617L;

	//摘要
	@JSONField(name = "abstract")
	private String abstracts;
	
	//科目
	@JSONField(name = "account_code")
	private String accountCode;
	
	//借方金额
	@JSONField(name = "natural_debit_currency")
	private BigDecimal naturalDebitCurrency;
	
	//贷方金额
	@JSONField(name = "natural_credit_currency")
	private BigDecimal naturalCreditCurrency;
	
	//辅助信息项：部门，客户，项目
	@JSONField(name = "auxiliary")
	private AuxiliaryVo auxiliary;
	
	@JSONField(name = "cash_flow")
	private List<CashFlowVo> cashFlow;

	public String getAbstracts() {
		return abstracts;
	}

	public void setAbstracts(String abstracts) {
		this.abstracts = abstracts;
	}

	public String getAccountCode() {
		return accountCode;
	}

	public void setAccountCode(String accountCode) {
		this.accountCode = accountCode;
	}

	public BigDecimal getNaturalDebitCurrency() {
		return naturalDebitCurrency;
	}

	public void setNaturalDebitCurrency(BigDecimal naturalDebitCurrency) {
		this.naturalDebitCurrency = naturalDebitCurrency;
	}

	public BigDecimal getNaturalCreditCurrency() {
		return naturalCreditCurrency;
	}

	public void setNaturalCreditCurrency(BigDecimal naturalCreditCurrency) {
		this.naturalCreditCurrency = naturalCreditCurrency;
	}

	public AuxiliaryVo getAuxiliary() {
		return auxiliary;
	}

	public void setAuxiliary(AuxiliaryVo auxiliary) {
		this.auxiliary = auxiliary;
	}

	public List<CashFlowVo> getCashFlow() {
		return cashFlow;
	}

	public void setCashFlow(List<CashFlowVo> cashFlow) {
		this.cashFlow = cashFlow;
	}
	
}
