package com.cku.restful.v1.sys.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel
public class RestCoupon implements Serializable {

	private static final long serialVersionUID = -1366211756007278533L;
	
	@ApiModelProperty(value = "ID")
	private String id;
	
	@ApiModelProperty(value = "会员号")
	private String memberCode;
	
	@ApiModelProperty(value = "优惠劵名称")
	private String couponName;
	
	@ApiModelProperty(value = "优惠劵类型 1代金券 2抵扣券 3参赛券 4满减券")
	private String couponType;
	
	@ApiModelProperty(value = "面值")
	private String facePrice;
	
	@ApiModelProperty(value = "生效日期")
	private String effectiveDate;
	
	@ApiModelProperty(value = "有效期")
	private String validDate;
	
	@ApiModelProperty(value = "说明")
	private String explains;
	
	@ApiModelProperty(value = " 面向折扣对象")
	private String target;
	
	@ApiModelProperty(value = "面向折扣对象ID")
	private String targetId;
	
	@ApiModelProperty(value = "状态 0：未使用，1：已使用，2：已过期")
	private String state;
	
	@ApiModelProperty(value = "状态说明 0：未使用，1：已使用，2：已过期")
	private String useState;
	
	@ApiModelProperty(value = "券类型描述")
	private String couponTypeDesc;

	@ApiModelProperty(value = "业务类型")
	private String business;

	@ApiModelProperty(value = "优惠券数量")
	private int couponNum;
	
	@ApiModelProperty(value = "过期/使用/即将过期数量")
	private int expireNum;
	
	private String couponCode;
}