/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.show.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.show.service.ChampionLoginService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.show.model.RestChampionLogin;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 冠军登录Service
 *
 * @author zhuoHeng
 * @version 2016-07-14
 */
@Service
@Transactional(readOnly = true)
public class RestChampionLoginService {

	public static final String PAYMENTCHARGINGITEM_SHORTNAME_COM = "show_champion_login@com";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_TONG = "show_champion_login@tong";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_YIN = "show_champion_login@yin";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_JIN = "show_champion_login@jin";
	public static final String PAYMENTCHARGINGITEM_SHORTNAME_CHAOJI = "show_champion_login@chaoji2020";
	public static final String PAYMENTCHARGINGITEM_SHORTNAME_SHIJIE = "show_champion_login@shijie";
	public static final String PAYMENTCHARGINGITEM_SHORTNAME_QINGNIAN = "show_champion_login@qingnian2020";

	@Autowired
	private ChampionLoginDao championLoginDao;
	@Autowired
	private ChampionLoginService championLoginService;
	@Autowired
	private DogService dogService;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogDnaService dogDnaService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids) {
		Member member = UserUtils.getLoginMember();
		ChampionLogin example = new ChampionLogin();
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setId(ids);

		List<ChampionLogin> championLoginList = championLoginService.findList(example);
		List<RestChampionLogin> list = new ArrayList<RestChampionLogin>();
		for (ChampionLogin championLogin : championLoginList) {
			RestChampionLogin vo = new RestChampionLogin();
			BeanUtil.copyProperties(vo, championLogin, "yyyy-MM-dd");
			vo.setLoginType(DictUtils.getDictLabel(vo.getLoginType(), "champion_login", ""));
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "champion_login_review", ""));
			list.add(vo);
		}

		return new RESTResponse("data", list);
	}

	public RESTResponse getList(HttpServletRequest request) {

		Member member = UserUtils.getLoginMember();

		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		ChampionLogin example = new ChampionLogin();
		// 设置分页参数
		Page<ChampionLogin> page = new Page<ChampionLogin>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setPaymentMembershipCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);

		// 查询并组装返回对象
		Page<ChampionLogin> result = championLoginService.findPage(page, example);
		List<ChampionLogin> championLoginList = result.getList();
		List<RestChampionLogin> list = new ArrayList<RestChampionLogin>();
		for (ChampionLogin championLogin : championLoginList) {
			RestChampionLogin vo = new RestChampionLogin();
			BeanUtil.copyProperties(vo, championLogin, "yyyy-MM-dd");
			vo.setLoginType(DictUtils.getDictLabel(vo.getLoginType(), "champion_login", ""));
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "champion_login_review", ""));
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestChampionLogin>(list, count));
	}

	/**
	 * 冠军登录 提交
	 * 
	 * @param json
	 *            loginType 6 世界冠军登录 7 青年冠军登录 1 普通冠军登录 5 超级冠军登录
	 * @return
	 */
	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		ChampionLogin vo = BeanUtil.toBean(json, ChampionLogin.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		ChampionLogin po = buildPo(vo);
		// 业务校验
		Dog dog = championLoginService.validateBusiness(po);
		JSONObject json1 = new JSONObject();
		// DNA存档判断
		if (!"7".equals(po.getLoginType()) && !dogDnaService.isHaveDogDna(dog.getId())) {
			json1.put("isSubmitDna", true); // 是否需要提交DNA点位分析
			json1.put("isSubmitBlood", false);// 是否需要提交血样留存
			json1.put("cartIds", "");
			return new RESTResponse("data", json1);
		}
		if ("7".equals(po.getLoginType())
				&& !dogBloodSaveService.check(po.getPedigreeCertified(), false).isDogDloodDna()) {
			json1.put("isSubmitDna", true);
			json1.put("isSubmitBlood", true);
			json1.put("cartIds", "");
			return new RESTResponse("data", json1);
		}
		//超级冠军登录0元无购物车
		if("5".equals(po.getLoginType())){
			po.setPaymentState("2");
			// 写入业务表
			championLoginDao.insert(po);
			json1.put("isSubmitDna", false);
			json1.put("isSubmitBlood", false);
			json1.put("cartIds", null);
		}else{
			// 写入业务表
			championLoginDao.insert(po);
			// 写入购物车
			String businessOrderCode = IdGen.uuid();
			PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
			paymentCartService.addToCart(paymentCart, "1025");
			json1.put("isSubmitDna", false);
			json1.put("isSubmitBlood", false);
			json1.put("cartIds", paymentCart.getId());
		}
		// 短信通知
		championLoginService.sendMsg(po);
		
		return new RESTResponse("data", json1);
	}

	/**
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月8日 下午5:35:32
	 */
	private void validateParameter(ChampionLogin vo) {
		if (StringUtils.isBlank(vo.getPedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号必填");
		}
		if (StringUtils.isBlank(vo.getLoginType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录类型必填");
		}
		//yuanshuai-2023年4月19日11:11:25
		//ID1005259取消邮寄校验
//		if (StringUtils.isBlank(vo.getPostType())||"-1".equals(vo.getPostType())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮寄证书/通知类方式必填");
//		}
//		if ("".equals(DictUtils.getDictLabel(vo.getPostType(), "mailing_way", ""))) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮寄类型值不对");
//		}
		if (StringUtils.isBlank(vo.getPostAddress())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮寄地址必填");
		}
		if ("".equals(DictUtils.getDictLabel(vo.getLoginType(), "champion_login", ""))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "登录类型值不对");
		}
		// 2019年3月1日起取消金银铜登录 2019年2月28日14:22:03
		if ("2".equals(vo.getLoginType()) || "3".equals(vo.getLoginType()) || "4".equals(vo.getLoginType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "自2019年3月1日起取消金银铜冠军登陆");
		}
	}

	/**
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private ChampionLogin buildPo(ChampionLogin vo) {
		Dog dog = dogService.getByPedigreeCertifiedCode(vo.getPedigreeCertified());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号有误");
		}
		ChampionLogin po = new ChampionLogin();
		po.preInsert();
		po.setPedigreeCertified(dog.getPedigreeCertifiedCode());
		po.setLoginType(vo.getLoginType());
		DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		po.setDogBreed(dogType.getDogBreedCode() + "-" + dogType.getBreedCnName() + "-" + dogType.getBreedEnName());
		// po.setMembershipCode(dog.getMemberCode());
		po.setCkuState("0");
		String shortName = "";
		if ("1".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_COM;
		} else if ("2".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_TONG;
		} else if ("3".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_YIN;
		} else if ("4".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_JIN;
		} else if ("5".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_CHAOJI;
		} else if ("6".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_SHIJIE;
		} else if ("7".equals(vo.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_QINGNIAN;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
		po.setPrice(paymentChargingItem.getPrice());
		po.setPaymentMembershipCode(UserUtils.getLoginMember().getMemberCode());
		po.setPostType(vo.getPostType());
		po.setPostAddress(vo.getPostAddress());
		po.setPrintState("0");
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProccessState("0");
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(vo.getStickerFlag())) {
//			po.setStickerFlag("1");
//		}
		po.setStickerFlag("0");
		return po;
	}

	private PaymentCart buildPaymentCart(ChampionLogin po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		String shortName = "";
		if ("1".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_COM;
		} else if ("2".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_TONG;
		} else if ("3".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_YIN;
		} else if ("4".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_JIN;
		} else if ("5".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_CHAOJI;
		} else if ("6".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_SHIJIE;
		} else if ("7".equals(po.getLoginType())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_QINGNIAN;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("show_champion_login");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1025");
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String loginType = request.getParameter("loginType");
		// 参数校验
		if (StringUtils.isBlank(loginType)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "冠军登录类型为空");
		}
		String shortName = "";
		if ("1".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_COM;
		} else if ("2".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_TONG;
		} else if ("3".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_YIN;
		} else if ("4".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_JIN;
		} else if ("5".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_CHAOJI;
		} else if ("6".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_SHIJIE;
		} else if ("7".equals(loginType)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_QINGNIAN;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.getByShortName(shortName);
		JSONObject jo = new JSONObject();
		jo.put("price", paymentChargingItem.getPrice());
		jo.put("name", paymentChargingItem.getName());
		return new RESTResponse("data", jo);
	}

	/**
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月9日 上午11:17:25
	 */
	public RESTResponse orderDetail(String id) {
		ChampionLogin championLogin = championLoginService.get(id);
		Dog dog = dogService.getByPedigreeCertifiedCode(championLogin.getPedigreeCertified());
		DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Map<String, String> map = new HashMap<>();
		map.put("key1", "犬主人：" + dog.getDogOwner());
		map.put("key2", "血统证书号：" + dog.getPedigreeCertifiedCode());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(dog.getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		map.put("key3", "犬种：" + breedCnName);
		map.put("key4", "性别：" + DictUtils.getDictLabel(dog.getGender(), "dog_gender", ""));
		if (dog.getBirthdate() != null && !"".equals(dog.getBirthdate())) {
			map.put("key5", "出生日期：" + sdf.format(dog.getBirthdate()));
		} else {
			map.put("key5", "出生日期：");
		}
		map.put("key6", "英文名：" + dog.getNameEn());
		map.put("key7", "芯片号：" + dog.getIdentificationFlag());
		map.put("key8", "毛色：" + dog.getColorFlag());
		return new RESTResponse("data", map);
	}

}