/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.open;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.service.RestOrgService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.modules.sys.service.AreaService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 培训机构管理Controller
 *
 * @author yuanshuai
 * @version 2018-10-15
 */
@Api(tags = "合作机构接口--wj")
@Controller
@RequestMapping(value = "/api/v1/open/org")
public class OpenOrgController extends BaseRestController {

    @Autowired
    private RestOrgService restOrgService;
    @Autowired
    private AreaService areaService;

    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ResponseBody
    public void getList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restOrgService.getList(request);
        ServletUtils.writeResponse(response, result);
    }

    @ApiOperation(value = "APP合作机构列表")
    @ApiImplicitParams({ @ApiImplicitParam(name = "pageNo",paramType = "query", value = "页码"),
            @ApiImplicitParam(name = "pageSize",paramType = "query", value = "条数"),
            @ApiImplicitParam(name = "orgType", paramType = "query", value = "类型：chongjihemendian鉴定门店、hospital 合作医院、club 地方俱乐部、catRenZheng 国际纯种犬猫认证服务中心、singleTypeClub 单犬种俱乐部"),
            @ApiImplicitParam(name = "province", paramType = "query", value = "省"),
            @ApiImplicitParam(name = "orgSite", paramType = "query", value = "所属协会：1CKU、2CKUMC"),
            @ApiImplicitParam(name = "name", paramType = "query", value = "名称")})
    @ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
            "  \"rc\": 0,\n" +
            "  \"msg\": \"OK\",\n" +
            "  \"data\": [\n" +
            "    {\n" +
            "      \"orgType\": \"单犬种俱乐部\",\n" +
            "      \"orgSite\": \"CKU\",\n" +
            "      \"address\": \"山东省济南市章丘区聂家工业园\",\n" +
            "      \"province\": \"山东省济南市\",\n" +
            "      \"name\": \"CKU济南市拉布拉多寻回猎犬俱乐部\",\n" +
            "      \"tel\": \"18660786606\"\n" +
            "    },\n" +
            "    {\n" +
            "      \"orgType\": \"合作医院\",\n" +
            "      \"address\": \"山东省济南市市中区卧龙路泉景天浣秀园3-1-104（王官庄小区东区6路车终点站东10米路南）\",\n" +
            "      \"province\": \"山东省济南市\",\n" +
            "      \"name\": \"济南和协宠物医院\",\n" +
            "      \"tel\": \"0531-69984919\"\n" +
            "    }\n" +
            "  ]\n" +
            "}")})
    @RequestMapping(value = "/orgList", method = RequestMethod.GET)
    @ResponseBody
    public void orgList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restOrgService.orgList(request,response);
        ServletUtils.writeResponse(response, result);
    }
    @ApiOperation(value = "APP省列表")
    @ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
            "  \"rc\": 0,\n" +
            "  \"msg\": \"OK\",\n" +
            "  \"data\": [\n" +
            "    {\n" +
            "      \"name\": \"北京市\",\n" +
            "      \"value\": \"北京市\"\n" +
            "    },\n" +
            "    {\n" +
            "      \"name\": \"黑龙江省\",\n" +
            "      \"value\": \"黑龙江省\"\n" +
            "    },\n" +
            "    {\n" +
            "      \"name\": \"江苏省\",\n" +
            "      \"value\": \"江苏省\"\n" +
            "    },\n" +
            "    {\n" +
            "      \"name\": \"浙江省\",\n" +
            "      \"value\": \"浙江省\"\n" +
            "    }" +
            "}")})
    @RequestMapping(value = "/getProvinceList", method = RequestMethod.GET)
    @ResponseBody
    public void getProvinceList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = areaService.getProvinceList(request);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/office/list", method = RequestMethod.GET)
    @ResponseBody
    public void getOfficeList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restOrgService.getOfficeList(request);
        ServletUtils.writeResponse(response, result);
    }
}