/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.web;

import java.io.IOException;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.constant.Constants;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.handler.service.RestHandlerQualificationCertificateService;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.handler.service.RestHandlerRegisterService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 报名Controller
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Controller
@RequestMapping(value = "/api/v1/handler")
public class RestHandlerRegisterController extends BaseRestController {

	@Autowired
	private RestHandlerRegisterService restHandlerRegisterService;

	@Autowired
	private RestHandlerQualificationCertificateService restHandlerQualificationCertificateService;

	@RequestMapping(value = "/handlerRegister", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.post(json);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 牵犬师大赛报名
	 * @Author chaixueteng
	 * @2017年8月31日上午10:27:45
	 */
	@RequestMapping(value = "/handlerRegisterMatch", method = RequestMethod.POST)
	@ResponseBody
	public void handlerRegisterMatch(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.handlerRegisterMatch(json);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 资格证书申领列表
	 * @Author chaixueteng
	 * @2016年9月22日下午2:45:13
	 */
	@RequestMapping(value = "/certificateList", method = RequestMethod.GET)
	@ResponseBody
	public void certificateList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.certificateList(request, Constants.STRING_ZERO);
		ServletUtils.writeResponse(response, result);
	}


	/**
	 * 活动报名(校验)
	 * @Author chaixueteng
	 * @2016年9月22日下午2:45:13
	 */
	@RequestMapping(value = "/apply", method = RequestMethod.GET)
	@ResponseBody
	public void apply(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.apply(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 牵犬师大赛活动报名(校验)
	 * @Author chaixueteng
	 * @2016年9月22日下午2:45:13
	 */
	@RequestMapping(value = "/applyMatch", method = RequestMethod.GET)
	@ResponseBody
	public void applyMatch(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.applyMatch(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 资格证书在线申领
	 * @Author chaixueteng
	 * @2016年9月22日下午2:45:13
	 */
	@RequestMapping(value = "/receiveCertificate/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void receiveCertificate(@PathVariable("id") String id,HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.receiveCertificate(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：资格证书在线申领（宠爱王国使用）
	 * @author: zhuoHeng
	 * @version: 2016年12月2日 下午4:41:58
	 */
	@RequestMapping(value = "/receiveCertificate/applyToGet", method = RequestMethod.GET)
	@ResponseBody
	public void applyToGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restHandlerRegisterService.receiveCertificate(id);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：获取培训报名历史数据（宠爱王国使用）
	 * @author: zhuoHeng
	 * @version: 2016年12月14日 上午9:19:39
	 */
	@RequestMapping(value = "/getHandlerRegister", method = RequestMethod.GET)
	@ResponseBody
	public void getHandlerRegister(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.getHandlerRegister(request);
		ServletUtils.writeResponse(response, result);
	}

	
	/**
	 *
	 * @Description：修改用户证件照并重置审核状态
	 * @author: zhuoHeng
	 * @version: 2016年12月15日 上午9:53:53
	 */
	@RequestMapping(value = "/resetReviewState", method = RequestMethod.PUT)
	@ResponseBody
	public void resetReviewState(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.resetReviewState(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月10日 下午4:25:17
	 */
	@RequestMapping(value = "/orderDetail", method = RequestMethod.GET)
	@ResponseBody
	public void orderDetail(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String id = request.getParameter("id");
		RESTResponse result = restHandlerRegisterService.orderDetail(id);
		ServletUtils.writeResponse(response, result);
	}
	
	/**
	 * 审查员报名
	 */
	@RequestMapping(value = "/examinerRegister", method = RequestMethod.POST)
	@ResponseBody
	public void examinerRegisterPost(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.examinerRegisterPost(json);
		ServletUtils.writeResponse(response, result);
	}
	
	
	@RequestMapping(value = "/getExaminerHandlerRegister", method = RequestMethod.GET)
	@ResponseBody
	public void getExaminerHandlerRegister(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.getExaminerHandlerRegister(request);
		ServletUtils.writeResponse(response, result);
	}

	
	@RequestMapping(value = "/resetExaminerReviewState", method = RequestMethod.PUT)
	@ResponseBody
	public void resetExaminerReviewState(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.resetExaminerReviewState(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 *
	 * @Description：获取培训报名历史数据（宠爱王国使用）(训练师)
	 * @author: hjx
	 */
	@RequestMapping(value = "/getHandlerTrainerRegister", method = RequestMethod.GET)
	@ResponseBody
	@ApiOperation(value = "培训训练师报名-列表", notes = "")
	public void getHandlerTrainerRegister(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restHandlerRegisterService.getHandlerTrainerRegister(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 训练师资格证书申领列表
	 * @Author hjx
	 * @Date 20250725
	 */
	@RequestMapping(value = "/trainer/certificateList", method = RequestMethod.GET)
	@ResponseBody
	@ApiOperation(value = "训练师资格证书申领-列表", notes = "")
	public void trainerCertificateList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		Member member = UserUtils.getLoginMember();
		if (Objects.isNull(member)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无登录信息或登陆者无会员身份！");
		}
		HandlerQualificationCertificate handlerQualificationCertificate = new HandlerQualificationCertificate();
		handlerQualificationCertificate.setMemberCode(member.getMemberCode());
		RESTResponse result = restHandlerQualificationCertificateService.selectTrainerCertificateListByApp(request);
		ServletUtils.writeResponse(response, result);
	}
}