package com.cku.restful.v1.groomer.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.groomer.service.RestGroomerPackageService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * 美容套餐活动
 * 
 * @author xx
 *
 */
@Api(value = "美容套餐-xuxue", tags = { "美容套餐-xuxue" })
@Controller
@RequestMapping(value = "/api/v1/groomerPackage")
public class RestGroomerPackageController extends BaseRestController {
	@Autowired
	private RestGroomerPackageService restGroomerPackageService;

	/**
	 * 提交套餐报名
	 * 
	 * @param json
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "美容套餐-提交", notes = "入参： \n" + "{\n" + "	\"name\": \"刘在春\",  -- 真实姓名\n"
			+ "	\"mobile\": \"18510488680\", -- 电话\n" + "	\"cardNo\": \"130681198704283819\", -- 身份证\n"
			+ "	\"province\": \"北京市\", -- 省\n" + "	\"city\": \"北京市\",  -- 市\n" + "	\"area\": \"朝阳区\", -- 区\n"
			+ "	\"street\": \"红领巾桥\",  -- 街道\n" + "	\"address\": \"111111\", -- 详细地址\n"
			+ "	\"avatar\": \"111111\", -- 二寸照片\n" + "	\"dogBreed\": \"金毛\", -- 犬种\n"
			+ "	\"schoolNameCn\": \"宠爱王国\"  -- 培训机构\n" + "}\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"data\": \"91c4d6f63aa1415892a84fbe2208f36e\" -- 提交订单时carts要传这个\n" + "}\n" + ""))
	@RequestMapping(value = "/add", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restGroomerPackageService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "APP-人才板块-美容组合包报名表单生成", tags = { "APP-人才板块-美容组合包报名表单生成-xuxue" }, notes = "")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo ", value = "pageNo ", paramType = "query"),
			@ApiImplicitParam(name = "pageSize ", value = "pageSize ", paramType = "query"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({ @ApiResponse(code = 200, message = "{\n" + "   \"rc\": 0,\n" + "   \"msg\": \"OK\",\n"
			+ "   \"data\": [\n" + "       {\n" + "         \"applyCode\": \"OL-00012”, — 报名序号  \n"
			+ "         \"paymentTime\": \"2020-07-07 22:28:12”,  — 报名时间\n" + "           \"area\": \"东城区\",\n"
			+ "           \"memberCode\": \"6431\",\n" + "           \"address\": \"柴\",\n"
			+ "           \"gender\": \"\",\n" + "           \"city\": \"北京市\",\n"
			+ "           \"runningNumber\": \"2007072228119787@103\",\n" + "           \"mobile\": \"15910536774\",\n"
			+ "           \"avatar\": \"http://upyun.chongaibao.com/cab_test/image/avatar/1280508872381280257.png\",\n"
			+ "           \"cardNo\": \"11010119200702925X\",\n" + "           \"schoolNameCn\": \"苏州东方贵迷宠物美容学校\",\n"
			+ "           \"province\": \"北京市\",\n" + "           \"paymentChargingItemId\": \"\",\n"
			+ "           \"street\": \"\",\n" + "           \"name\": \"技术部测试\",\n"
			+ "           \"orderPrice\": \"998.00\",\n" + "           \"dogBreed\": \"雪纳瑞\",\n"
			+ "           \"paymentState\": \"2\",\n" + "           \"showLevel\": \"CKU ONLINE C级\"\n" + "       }\n"
			+ "   ],\n" + "   \"total\": 1\n" + "}\n" + "") })
	@RequestMapping(value = "/myList", method = RequestMethod.GET)
	@ResponseBody
	public void myList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restGroomerPackageService.myList(request, response);
		ServletUtils.writeResponse(response, result);
	}
}
