package com.cku.restful.v1.finance.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import com.cku.oa.appreciation.service.AppreciationApplyService;
import com.cku.oa.buying.dao.AdvertisementDao;
import com.cku.oa.buying.dao.BuyingOrderDao;
import com.cku.oa.buying.entity.BuyingOrder;
import com.cku.oa.clubdog.service.ClubDogService;
import com.cku.oa.common.PaymentItemIdConstants;
import com.cku.oa.constant.Constants;
import com.cku.oa.dog.dao.DogChipDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogSecondBreederService;
import com.cku.oa.dog.service.DogStickerApplyService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentChargingItemGroupDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentChargingItemGroup;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.service.PaymentRecordService;
import com.cku.oa.finance.vo.PaymentCartVO;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerWrittenExamInfo;
import com.cku.oa.groomer.service.FciGroomerQualificationCertificateService;
import com.cku.oa.groomer.service.GroomerCourseApplicationService;
import com.cku.oa.groomer.service.GroomerRegisterService;
import com.cku.oa.groomer.service.GroomerWrittenExamInfoService;
import com.cku.oa.kennel.service.KennelOwnerChangeService;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.show.dao.MainShowsDao;
import com.cku.oa.show.dao.ShowApplyDao;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowApply;
import com.cku.oa.show.service.ShowApplyService;
import com.cku.oa.statistics.dao.MemberInfoDao;
import com.cku.oa.statistics.service.SplitOrderService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberActivity20201212Discount;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.partner.club.service.CompanionDogAppraisalService;
import com.cku.partner.open.club.service.AppHospitalService;
import com.cku.restful.v1.buying.service.RestAdvertisementService;
import com.cku.restful.v1.finance.entity.RestPaymentOrder;
import com.cku.restful.v1.finance.entity.RestPaymentOrderDetail;
import com.cku.restful.v1.finance.vo.PriceVO;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.schools.mrschool.service.SchoolsMemberService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.common.utils.SpringContextHolder;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Service
@Transactional(readOnly = true)
public class RestOrderService {

	private Logger logger = LoggerFactory.getLogger(RestOrderService.class);

	@Autowired
	PaymentOrderService paymentOrderService;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentRecordDao paymentRecordDao;
	@Autowired
	private PaymentRecordService paymentRecordService;
	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	private PaymentChargingItemGroupDao paymentChargingItemGroupDao;
	@Autowired
	private MemberDao memberDao;
	@Autowired
	private BuyingOrderDao buyingOrderDao;
	@Autowired
	private MemberService memberService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private ShowApplyDao showApplyDao;
	@Autowired
	private DogChipService dogChipService;
	@Autowired
	private DogChipDao dogChipDao;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private SchoolsMemberService schoolsMemberService;
	@Autowired
	private RestAdvertisementService restAdvertisementService;
	@Autowired
	private AdvertisementDao advertisementDao;
	@Autowired
	private MainShowsDao mainShowsDao;
	@Autowired
	private DogActivationService dogActivationService;
	@Autowired
	private MemberInfoDao memberInfoDao;
	@Autowired
	private DogStickerApplyService dogStickerApplyService;
	@Autowired
	private ShowApplyService showApplyService;
	@Autowired
	private UserDao userDao;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private SplitOrderService splitOrderService;
	@Autowired
	private AppHospitalService appHospitalService;
	@Autowired
	private DogAppraisalService dogAppraisalService;
	@Autowired
	private DogSecondBreederService dogSecondBreederService;
	@Autowired
	private GroomerCourseApplicationService groomerCourseApplicationService;
	@Autowired
	private AppreciationApplyService appreciationApplyService;

	@Autowired
	private MemberActivity20201212Discount memberActivity20201212Discount;

	@Autowired
	public ExpressQueueService expressQueueService;

	@Autowired
	private GroomerWrittenExamInfoService groomerWrittenExamInfoService;

	@Autowired
	private GroomerRegisterService groomerRegisterService;

	@Autowired
	private FciGroomerQualificationCertificateService fciGroomerQualificationCertificateService;

	@Autowired
	private GroomerQualificationCertificateDao groomerQualificationCertificateDao;

	public static final String GROOMER_QUALIFICATION_CERTIFICATE = "groomer_qualification_certificate";

	public static final String FCI_GROOMER_QUALIFICATION_CERTIFICATE = "fci_groomer_qualification_certificate";

	/**
	 * CKU美容资格证书A级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_A = "groomer_qualification_certificate@A";
	/**
	 * CKU美容资格证书B级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_B = "groomer_qualification_certificate@B";

	/**
	 * CKU美容资格证书C级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_C = "groomer_qualification_certificate@C";

	/**
	 * CKU美容资格证书教师级
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_MASTER = "groomer_qualification_certificate@M";
	/**
	 * PDG美容资格证书
	 */
	private static final String PDG_GROOMER_QUALIFICATION_CERTIFICATE = "groomer_qualification_certificate@pdg";

	/**
	 * 宠物造型师资格证书
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_PET = "groomer_qualification_certificate@PET";

	/**
	 * 宠物造型师资格证书(金牌)
	 */
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_PET_DOLD = "groomer_qualification_certificate@PET_GOLD";

	/**
	 * 分页查询订单
	 *
	 * @param request
	 * @return
	 */
	public RESTResponse findByPage(HttpServletRequest request) {
		// 封装分页
		Member member = UserUtils.getLoginMember();

		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String paymentState = request.getParameter("paymentState");
		String orderCode = request.getParameter("orderCode");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		Page<PaymentOrder> page = new Page<PaymentOrder>();
		page.setPageSize(pageSizeInt);
		page.setPageNo(pageNoInt);

		// 封装订单
		PaymentOrder order = new PaymentOrder();
		order.setClientFlag("true");
		order.setMemberCode(member.getMemberCode());
		if (paymentState != null) {
			order.setPaymentState(paymentState);
		}
		if (StringUtils.isNotBlank(orderCode)) {
			order.setOrderCode(orderCode);
		}
		order.setDelFlag("0");
		Page<PaymentOrder> orders = paymentOrderService.findPage(page, order);
		List<PaymentOrder> paymentOrderList = orders.getList();
		List<RestPaymentOrder> list = new ArrayList<RestPaymentOrder>();
		for (PaymentOrder paymentOrder : paymentOrderList) {
			RestPaymentOrder vo = new RestPaymentOrder();
			BeanUtil.copyProperties(vo, paymentOrder, "yyyy-MM-dd HH:mm:ss");
			getOrderDetail(vo, member);
			vo.setPaymentWay(DictUtils.getDictLabel(vo.getPaymentWay(), "payment_way", ""));
			vo.setPaymentStateName(DictUtils.getDictLabel(vo.getPaymentState(), "user_payment_state", ""));
			list.add(vo);
		}

		long count = orders.getCount();
		return new RESTResponse("list", new PageBeanResult<RestPaymentOrder>(list, count));
	}

	/**
	 * 获取订单详情
	 *
	 * @param restPaymentOrder
	 * @param member
	 */
	private void getOrderDetail(RestPaymentOrder restPaymentOrder, Member member) {
		PaymentOrder order = new PaymentOrder();
		order.setMemberCode(member.getMemberCode());
		order.setOrderCode(restPaymentOrder.getOrderCode());
		List<RestPaymentOrderDetail> rDetails = new ArrayList<RestPaymentOrderDetail>();
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findList(new PaymentOrderDetail(order));
		Map<String, List<PaymentOrderDetail>> collect = orderDetailList.stream().filter(
				i -> StringUtils.isNotEmpty(i.getBusinessId()) && StringUtils.isNotEmpty(i.getBusinessOrderCode()))
				.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessId));
		System.out.println("==================" + collect.entrySet().size());
		if (collect != null && collect.size() > 0) {// TODO: 2019/8/24 新功能上线前需要先清空购物车
			collect.entrySet().forEach(i -> {
				RestPaymentOrderDetail r = new RestPaymentOrderDetail();
				r.setNum(String.valueOf(i.getValue().get(0).getNum()));
				i.getValue().forEach(j -> {
					r.setChargingItemId(j.getBusinessId());
					r.setChargingItemName(j.getBusinessName());
					r.setBusinessRefund(j.getBusinessRefund());
					r.setBusinessRefundState(j.getBusinessRefundState());
					r.setBusinessIds(j.getBusinessIds());
					r.setBusinessTable(j.getBusinessTable());
					r.setOrderCode(j.getOrderCode());
					r.setMemberCode(j.getMemberCode());
					r.setMemberName(j.getMemberName());
				});
				Double d = 0.0;
				for (PaymentOrderDetail p : i.getValue())
					d = d + Double.parseDouble(p.getTotalPrice());
				r.setPrice(d.toString());
				r.setTotalPrice(d.toString());
				// //app不允许视频鉴定退款
				// if("dog_appraisal".equals(r.getBusinessTable())){
				// r.setBusinessRefund("0");
				// }else{
				// r.setBusinessRefund(r.getBusinessRefund());
				// }
				rDetails.add(r);
			});
		}

		/**
		 * 判断是否为券，为券的话不在二级收费项显示，故过滤掉
		 */
		List<PaymentChargingItem> coupons = paymentChargingItemDao.getByShortNamePrefix("sys_coupon");
		List<String> couponIds = new ArrayList<>();
		if (!CollectionUtils.isEmpty(coupons)) {
			couponIds.addAll(coupons.stream().map(PaymentChargingItem::getId).collect(Collectors.toList()));
			couponIds.remove("");
		}
		/**
		 * 判断是否为券，为券的话不在二级收费项显示，故过滤掉
		 */
		for (PaymentOrderDetail detail : orderDetailList) {
			if (StringUtils.isNotEmpty(detail.getBusinessId())
					&& StringUtils.isNotEmpty(detail.getBusinessOrderCode())) {
				continue;
			}
			if (couponIds.contains(detail.getChargingItemId())) {
				continue;
			}
			RestPaymentOrderDetail d = new RestPaymentOrderDetail();
			BeanUtil.copyProperties(d, detail, "yyyy-MM-dd");
			// 赛事报名订单详情需要显示报名场次、证书号、年龄组别
			if ("show_apply".equals(detail.getBusinessTable())) {
				String id = detail.getBusinessIds().split("#")[0];
				ShowApply showApply = showApplyDao.get(id);
				d.setIsShowApply("1");
				d.setPedigreeCertified(showApply.getPedigreeCertified());
				d.setShowCode(showApply.getShowCode());
				d.setAgeGroup(DictUtils.getDictLabel(showApply.getAgeGroup(), "show_age_group", ""));
			}
			// 抢购订单详情需显示抢购的产品名
			if ("buying_order".equals(detail.getBusinessTable())) {
				BuyingOrder buyingOrder = buyingOrderDao.get(detail.getBusinessIds());
				if (buyingOrder != null) {
					if (StringUtils.isNotBlank(buyingOrder.getDogType())) {
						d.setChargingItemName(buyingOrder.getCommodityName() + "(" + buyingOrder.getDogType() + ")");
					} else {
						d.setChargingItemName(buyingOrder.getCommodityName());
					}
				}
			}
			rDetails.add(d);
		}
		restPaymentOrder.setItems(rDetails);
	}

	// 校验是否都有必须同时提交的购物车
	private void validate(List<PaymentCart> myCarts, Object[] ids) {

		List<String> idsList = new ArrayList<String>();
		for (Object id : ids) {
			for (PaymentCart cart : myCarts) {
				if (cart.getId().equals(id)) {
					String businessIds = cart.getBusinessIds();
					// 解决会员购物车里有1基础会员年度登记费和2升级专业会员登记费、专业会员年度登记费时，必须得同时提交这三项的bug
					if (StringUtils.isNotBlank(cart.getBusinessOrderCode())) {
						businessIds += cart.getBusinessOrderCode();
					}
					idsList.add(businessIds);
				}
			}

		}

		HashMap<String, Integer> map = new HashMap<String, Integer>();
		// 分组
		for (PaymentCart cart : myCarts) {
			String businessIds = cart.getBusinessIds();
			// 解决会员购物车里有1基础会员年度登记费和2升级专业会员登记费、专业会员年度登记费时，必须得同时提交这三项的bug
			if (StringUtils.isNotBlank(cart.getBusinessOrderCode())) {
				businessIds += cart.getBusinessOrderCode();
			}
			if (map.get(businessIds) == null) {
				map.put(businessIds, 1);
			} else {
				map.put(businessIds, map.get(businessIds) + 1);
			}
		}
		// 删除只出现一次的记录
		for (Map.Entry<String, Integer> entry : map.entrySet()) {
			String key = entry.getKey();
			Integer value = entry.getValue();
			if (value != 1) {
				if (idsList.contains(key)) {
					int count = 0;
					for (String id : idsList) {
						if (key.equals(id)) {
							count++;
						}
					}
					if (value != count) {
						StringBuilder name = new StringBuilder("订单");
						for (PaymentCart cart : myCarts) {
							String businessIds = cart.getBusinessIds();
							// 解决会员购物车里有1基础会员年度登记费和2升级专业会员登记费、专业会员年度登记费时，必须得同时提交这三项的bug
							if (StringUtils.isNotBlank(cart.getBusinessOrderCode())) {
								businessIds += cart.getBusinessOrderCode();
							}
							if (businessIds.equals(key)) {
								name.append(cart.getChargingItemName() + ",");
							}
						}
						name.deleteCharAt(name.length() - 1);
						name.append("为关联订单，不能单独提交");
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, name.toString());
					}
				}
			}
		}
	}

	/**
	 * @description: 校验新生犬登记业务是否同时提交
	 * @author: laiguanglong
	 * @date: 2016/11/29 10:08
	 */
	private void validateDogChip(List<PaymentCart> myCarts, Object[] ids) {
		// 获取提交的购物车列表
		List<PaymentCart> submitList = new ArrayList<PaymentCart>();
		for (Object id : ids) {
			for (PaymentCart cart : myCarts) {
				if (cart.getId().equals(id)) {
					submitList.add(cart);
				}
			}
		}
		// 获取提交的购物车中同一业务号购物车的数量
		HashMap<String, Integer> map = new HashMap<String, Integer>();
		for (PaymentCart submit : submitList) {
			String businessOrderCode = submit.getBusinessOrderCode();
			if (StringUtils.isNotBlank(businessOrderCode)) {
				if (map.get(businessOrderCode) == null) {
					map.put(businessOrderCode, 1);
				} else {
					map.put(businessOrderCode, map.get(businessOrderCode) + 1);
				}
			}
		}
		// 对比购物车同一业务号的数量和提交购物车同一业务号的数量
		for (Map.Entry<String, Integer> entry : map.entrySet()) {
			int count = 0;
			StringBuilder name = new StringBuilder("订单");
			for (PaymentCart cart : myCarts) {
				if (StringUtils.isNotBlank(cart.getBusinessOrderCode())) {
					if (entry.getKey().equals(cart.getBusinessOrderCode())) {
						count++;
						name.append(cart.getChargingItemName() + ",");
					}
				}
			}
			if (count != entry.getValue()) {
				name.deleteCharAt(name.length() - 1);
				name.append("为关联的新生犬登记订单，不能单独提交");
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, name.toString());
			}
		}
	}

	/**
	 * 将购物车中的商品转存入订单
	 *
	 * @param ids
	 * @param paymentOrder
	 */
	@Transactional(readOnly = false)
	public String cartToOrderClub(Object[] ids, PaymentOrder paymentOrder, String couponId) {
		if (StringUtils.isNotEmpty(couponId)) {
			// 如果使用优惠券，减去相应的金额
			List<String> idList = new ArrayList<>();
			for (Object id : ids) {
				idList.add(id.toString());
			}
			PriceVO priceVO = paymentCartService.totalPricseClub(idList, couponId);
			if (priceVO.getCouponPrice() > 0) {
				SysCoupon sysCoupon = sysCouponService.get(couponId);
				// 在购物车里面增加一条优惠券减免收费项，并把ID加到订单ID参数里面
				PaymentChargingItem couponXN = paymentChargingItemService
						.getByShortName("sys_coupon@xn_" + sysCoupon.getTarget() + "_" + sysCoupon.getFacePrice());
				if (couponXN == null) {
					throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "此券还没有收费项，暂不可用！");
				}
				List<PaymentCartVO> cartsT = paymentCartService.findListByIds(idList,
						UserUtils.getLoginPartner().getMemberCode());
				if (cartsT != null && cartsT.size() > 0 && cartsT.get(0) != null) {
					// 需要新建收费项
					PaymentCart paymentCart = new PaymentCart();
					paymentCart.setChargingItemId(couponXN.getId());
					paymentCart.setChargingItemName(couponXN.getName());
					paymentCart.setPrice(String.valueOf(0 - priceVO.getCouponPrice()));
					paymentCart.setTotalPrice(paymentCart.getPrice());
					paymentCart.setNum("1");
					paymentCart.setBusinessTable("sys_coupon");
					paymentCart.setBusinessIds(couponId);// 这个部分与其他不一样，这里记了券表的ID
					paymentCart.setBusinessOrderCode(cartsT.get(0).getBusinessOrderCode());
					paymentCart.setCouponNum("1");
					String cid = paymentCartService.addToClubCartFCoupon(paymentCart);
					idList.add(cid);
					ids = idList.toArray();
					// 把券置为已用
					sysCoupon.setUseState("1");
					sysCoupon.setTargetId(couponId);
					sysCoupon.preUpdate();
					sysCouponService.save(sysCoupon);
				}
			}
		}
		Double orderTotal = Double.valueOf("0");
		int couponNum = Integer.valueOf("0");
		List<PaymentCart> carts = new ArrayList<PaymentCart>();
		Date addTime = new Date();
		// 获取到需要提交到订单的商品
		List<PaymentCart> myCarts = paymentCartService.getCooperatorCart(false);
		// 校验是否都有必须同时提交的购物车
		validate(myCarts, ids);
		// 校验新生犬登记是否同时提交了购物车
		validateDogChip(myCarts, ids);
		// 校验购物车数据是否已经提交订单
		List<String> tempList = new ArrayList(Arrays.asList(ids));
		List validCartList = myCarts.stream().filter(cart -> tempList.contains(cart.getId()))
				.collect(Collectors.toList());
		if (validCartList == null || validCartList.isEmpty()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请勿重复生成订单！");
		}

		// 校验订单总额标记位
		boolean checkOrderTotal = false;
		// 赛事优惠卷标记位
		boolean sysCoupon = false;
		for (Object id : ids) {
			for (PaymentCart cart : myCarts) {
				if (cart.getId().equals(id)) {
					carts.add(cart);
					orderTotal += Double.valueOf(cart.getTotalPrice());
					couponNum += Integer.parseInt(cart.getCouponNum());
				}
				if (!checkOrderTotal && !"277".equals(cart.getChargingItemId())) {
					checkOrderTotal = true;
				}
				if (cart.getChargingItemName().trim().indexOf("CAC赛事免费参赛券") != -1
						||cart.getChargingItemName().trim().indexOf("CAC犬展免费参展券") != -1) {
					sysCoupon = true;
				}
			}
		}

		// 添加订单优惠劵数量
		paymentOrder.setCouponNum(couponNum + "");

		// if (checkOrderTotal && orderTotal == 0.0 && !sysCoupon) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单价格校验失败");
		// }
		Member member = memberDao.getByMemberCode(paymentOrder.getMemberCode());
		// 校验是否会员已冻结
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已被冻结,无法生成订单");
		}
		// 生成订单商品
		saveOrderClub(paymentOrder, orderTotal, addTime);
		// 生成订单详情
		for (int i = 0; i < carts.size(); i++) {
			PaymentCart cart = carts.get(i);
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setOrderCode(paymentOrder.getOrderCode());
			detail.setAddTime(addTime);
			detail.setProccessState("0");
			detail.setTotalPrice(cart.getTotalPrice());
			detail.setNum(cart.getNum());
			detail.setPrice(cart.getPrice());
			detail.setBusinessIds(cart.getBusinessIds());
			detail.setBusinessId(cart.getBusinessId());
			detail.setBusinessName(cart.getBusinessName());
			detail.setBusinessRefund(cart.getBusinessRefund());
			// 添加赛事模式字段
			if ("show_apply".equals(cart.getBusinessTable())) {
				String id = detail.getBusinessIds().split("#")[0];// 赛事报名表id
				ShowApply showApply = showApplyDao.get(id);
				String mainShowId = showApply.getMainShowId();
				MainShows mainShows = mainShowsDao.get(mainShowId);
				if ("1".equals(mainShows.getBusinessModelFlag())) {
					detail.setShowBusinessModelFlag("1");
				}
			}
			String businessCode = "";
			if (StringUtils.isNotBlank(cart.getBusinessOrderCode()) && cart.getBusinessOrderCode().contains("-")) {
				String[] businessCodes = cart.getBusinessOrderCode().split("-");
				if (businessCodes.length > 1) {
					businessCode = businessCodes[0];
				}
			} else {
				businessCode = cart.getBusinessOrderCode();
			}
			// detail.setBusinessCode(cart.getBusinessOrderCode());
			detail.setBusinessCode(businessCode);
			detail.setBusinessTable(cart.getBusinessTable());
			// detail.preInsert();
			detail.setId(IdGen.uuid());
			detail.setCreateBy(appHospitalService.loginUser());
			detail.setCreateDate(new Date());
			detail.setUpdateBy(appHospitalService.loginUser());
			detail.setUpdateDate(new Date());
			detail.setChargingItemId(cart.getChargingItemId());
			detail.setMemberCode(paymentOrder.getMemberCode());
			detail.setMemberName(paymentOrder.getMemberName());
			detail.setChargingItemName(cart.getChargingItemName());
			detail.setBusinessOrderCode(cart.getBusinessOrderCode());
			paymentOrderDetailDao.insert(detail);

			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(cart.getBusinessTable()) && !"sys_member".equals(cart.getBusinessTable())
					&& !"kennel".equals(cart.getBusinessTable())) {
				String businessIds = cart.getBusinessIds();
				if ("dog_birth_certificate".equals(cart.getBusinessTable())) {
					// 出生纸特殊处理
					paymentOrderDao.updateDogBirthCertificateRunningNo(paymentOrder.getOrderCode(), businessIds);
				} else if ("show_apply".equals(cart.getBusinessTable())) {
					// 只有赛事报名才会回写赛事报名表中的流水
					if (cart.getChargingItemName().indexOf("CAC赛事免费参赛券") == -1
							||cart.getChargingItemName().trim().indexOf("CAC犬展免费参展券")  == -1) {
						String business = businessIds.split("#")[0];
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), cart.getBusinessTable(),
								business);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), cart.getBusinessTable(),
							businessIds);
				}
			}

		}

		// 清空购物车中已经购买的商品
		for (Object id : ids) {
			for (PaymentCart cart : myCarts) {
				if (cart.getId().equals(id)) {
					paymentCartService.removeCart(cart.getId(), false);
				}
			}
		}
		return paymentOrder.getId();
	}

	/**
	 * 将购物车中的商品转存入订单
	 *
	 * @param ids
	 * @param paymentOrder
	 */
	@Transactional(readOnly = false)
	public String cartToOrder(Object[] ids, PaymentOrder paymentOrder, String couponId) {
		if (StringUtils.isNotEmpty(couponId)) {
			// 如果使用优惠券，减去相应的金额
			List<String> idList = new ArrayList<>();
			for (Object id : ids) {
				idList.add(id.toString());
			}
			PriceVO priceVO = paymentCartService.totalPrice(idList, couponId);
			if (priceVO.getCouponPrice() > 0) {
				SysCoupon sysCoupon = sysCouponService.get(couponId);
				// 在购物车里面增加一条优惠券减免收费项，并把ID加到订单ID参数里面
				PaymentChargingItem couponXN = paymentChargingItemService
						.getByShortName("sys_coupon@xn_" + sysCoupon.getTarget() + "_" + sysCoupon.getFacePrice());
				if (couponXN == null) {
					throw new ZAException(ZAErrorCode.ZA_ERC_MEMBER_INVALID, "此券还没有收费项，暂不可用！");
				}
				List<PaymentCartVO> cartsT = paymentCartService.findListByIds(idList,
						UserUtils.getLoginMember().getMemberCode());
				if (cartsT != null && cartsT.size() > 0 && cartsT.get(0) != null) {
					// 需要新建收费项
					PaymentCart paymentCart = new PaymentCart();
					paymentCart.setChargingItemId(couponXN.getId());
					paymentCart.setChargingItemName(couponXN.getName());
					paymentCart.setPrice(String.valueOf(0 - priceVO.getCouponPrice()));
					paymentCart.setTotalPrice(paymentCart.getPrice());
					paymentCart.setNum("1");
					paymentCart.setBusinessTable("sys_coupon");
					paymentCart.setBusinessIds(couponId);// 这个部分与其他不一样，这里记了券表的ID
					paymentCart.setBusinessOrderCode(cartsT.get(0).getBusinessOrderCode());
					paymentCart.setCouponNum("1");
					String cid = paymentCartService.addToCartFCoupon(paymentCart);
					idList.add(cid);
					ids = idList.toArray();
					// 把券置为已用
					sysCoupon.setUseState("1");
					sysCoupon.setTargetId(couponId);
					sysCoupon.preUpdate();
					sysCouponService.save(sysCoupon);
				}
			}
		}
		Double orderTotal = Double.valueOf("0");
		int couponNum = Integer.valueOf("0");
		List<PaymentCart> carts = new ArrayList<PaymentCart>();
		Date addTime = new Date();
		// 获取到需要提交到订单的商品
		List<PaymentCart> myCarts = paymentCartService.getMyCart(false);
		// 校验是否都有必须同时提交的购物车
		validate(myCarts, ids);
		// 校验新生犬登记是否同时提交了购物车
		validateDogChip(myCarts, ids);
		// 校验购物车数据是否已经提交订单
		List<String> tempList = new ArrayList(Arrays.asList(ids));
		List validCartList = myCarts.stream().filter(cart -> tempList.contains(cart.getId()))
				.collect(Collectors.toList());
		if (validCartList == null || validCartList.isEmpty()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请勿重复生成订单！");
		}

		// 校验订单总额标记位
		boolean checkOrderTotal = false;
		// 赛事优惠卷标记位
		boolean sysCoupon = false;
		for (Object id : ids) {
			for (PaymentCart cart : myCarts) {
				if (cart.getId().equals(id)) {
					carts.add(cart);
					orderTotal += Double.valueOf(cart.getTotalPrice());
					couponNum += Integer.parseInt(cart.getCouponNum());
				}
				if (!checkOrderTotal && !"277".equals(cart.getChargingItemId())) {
					checkOrderTotal = true;
				}
				if (cart.getChargingItemName().trim().indexOf("CAC赛事免费参赛券") != -1
						||cart.getChargingItemName().trim().indexOf("CAC犬展免费参展券") != -1) {
					sysCoupon = true;
				}
			}
		}

		// 添加订单优惠劵数量
		paymentOrder.setCouponNum(couponNum + "");

		// if (checkOrderTotal && orderTotal == 0.0 && !sysCoupon) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单价格校验失败");
		// }
		Member member = memberDao.getByMemberCode(paymentOrder.getMemberCode());
		// 校验是否会员已冻结
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已被冻结,无法生成订单");
		}
		// 生成订单商品
		saveOrder(paymentOrder, orderTotal, addTime);
		// 生成订单详情
		for (int i = 0; i < carts.size(); i++) {
			PaymentCart cart = carts.get(i);
			PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setOrderCode(paymentOrder.getOrderCode());
			detail.setAddTime(addTime);
			detail.setProccessState("0");
			detail.setTotalPrice(cart.getTotalPrice());
			detail.setNum(cart.getNum());
			detail.setPrice(cart.getPrice());
			detail.setBusinessIds(cart.getBusinessIds());
			detail.setBusinessId(cart.getBusinessId());
			detail.setBusinessName(cart.getBusinessName());
			detail.setBusinessRefund(cart.getBusinessRefund());
			// 添加赛事模式字段
			if ("show_apply".equals(cart.getBusinessTable())) {
				String id = detail.getBusinessIds().split("#")[0];// 赛事报名表id
				ShowApply showApply = showApplyDao.get(id);
				String mainShowId = showApply.getMainShowId();
				MainShows mainShows = mainShowsDao.get(mainShowId);
				if ("1".equals(mainShows.getBusinessModelFlag())) {
					detail.setShowBusinessModelFlag("1");
				}
			}
			String businessCode = "";
			if (StringUtils.isNotBlank(cart.getBusinessOrderCode()) && cart.getBusinessOrderCode().contains("-")) {
				String[] businessCodes = cart.getBusinessOrderCode().split("-");
				if (businessCodes.length > 1) {
					businessCode = businessCodes[0];
				}
			} else {
				businessCode = cart.getBusinessOrderCode();
			}
			// detail.setBusinessCode(cart.getBusinessOrderCode());
			detail.setBusinessCode(businessCode);
			detail.setBusinessTable(cart.getBusinessTable());
			detail.preInsert();
			detail.setChargingItemId(cart.getChargingItemId());
			detail.setMemberCode(cart.getMemberCode());
			detail.setMemberName(cart.getMemberName());
			detail.setChargingItemName(cart.getChargingItemName());
			detail.setBusinessOrderCode(cart.getBusinessOrderCode());
			paymentOrderDetailDao.insert(detail);

			// 更新业务表不为空且不为会员表的收费项
			if (StringUtils.isNotBlank(cart.getBusinessTable()) && !"sys_member".equals(cart.getBusinessTable())
					&& !"kennel".equals(cart.getBusinessTable())) {
				String businessIds = cart.getBusinessIds();
				if ("dog_birth_certificate".equals(cart.getBusinessTable())) {
					// 出生纸特殊处理
					paymentOrderDao.updateDogBirthCertificateRunningNo(paymentOrder.getOrderCode(), businessIds);
				} else if ("show_apply".equals(cart.getBusinessTable())) {
					// 只有赛事报名才会回写赛事报名表中的流水
					if (cart.getChargingItemName().indexOf("CAC赛事免费参赛券") == -1
							||cart.getChargingItemName().trim().indexOf("CAC犬展免费参展券")  == -1) {
						String business = businessIds.split("#")[0];
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), cart.getBusinessTable(),
								business);
					}
				} else {
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), cart.getBusinessTable(),
							businessIds);
				}
			}
		}
		// 第二繁殖人处理
		PaymentCart paymentCart = carts.get(0);
		if (StringUtils.isNotBlank(paymentCart.getBusinessTable())
				&& ("dog_birth_certificate".equals(paymentCart.getBusinessTable())
						|| "dog_chip".equals(paymentCart.getBusinessTable()))) {
			String businessIds = paymentCart.getBusinessIds();
			dogSecondBreederService.saveInfo(businessIds, paymentOrder.getOrderCode());
		}

		// 清空购物车中已经购买的商品
		for (Object id : ids) {
			for (PaymentCart cart : myCarts) {
				if (cart.getId().equals(id)) {
					paymentCartService.removeCart(cart.getId(), false);
				}
			}
		}
		return paymentOrder.getId();
	}

	@Transactional(readOnly = false)
	public void saveOrder(PaymentOrder paymentOrder, Double orderTotal, Date addTime) {
		// 插入订单
		String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(paymentOrder.getMemberCode());
		Member member = memberDao.getByMemberCode(paymentOrder.getMemberCode());
		// 校验是否会员已冻结
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已被冻结,无法生成订单");
		}
		// String loginType = UserUtils.getLoginUser().getLoginType();
		String loginType = "1";
		paymentOrder.setOrderCode(runningNumber);
		paymentOrder.setAddTime(addTime);
		paymentOrder.setLocked("0");
		paymentOrder.setTotalPrice(orderTotal.toString());
		paymentOrder.setPaymentState("1");
		paymentOrder.setSource(loginType);

		paymentOrder.preInsert();
		paymentOrderDao.insert(paymentOrder);
	}

	/**
	 * 保存订单
	 *
	 * @param paymentOrder
	 * @param orderTotal
	 * @param addTime
	 */
	@Transactional(readOnly = false)
	public void saveOrderClub(PaymentOrder paymentOrder, Double orderTotal, Date addTime) {
		// 插入订单
		String runningNumber = SysCodeUtil.getPayRunningNumberWithMemberCode(paymentOrder.getMemberCode());
		Member member = memberDao.getByMemberCode(paymentOrder.getMemberCode());
		// 校验是否会员已冻结
		if ("1".equals(member.getFreezeFlag()) && !member.getMemberCode().contains("HZ")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员已被冻结,无法生成订单");
		}
		// String loginType = UserUtils.getLoginUser().getLoginType();
		String loginType = "1";
		paymentOrder.setOrderCode(runningNumber);
		paymentOrder.setAddTime(addTime);
		paymentOrder.setLocked("0");
		paymentOrder.setTotalPrice(orderTotal.toString());
		paymentOrder.setPaymentState("1");
		paymentOrder.setSource(loginType);

		paymentOrder.setCreateBy(appHospitalService.loginUser());
		paymentOrder.setCreateDate(new Date());
		paymentOrder.setUpdateBy(appHospitalService.loginUser());
		paymentOrder.setUpdateDate(new Date());
		paymentOrder.setId(IdGen.uuid());
		// paymentOrder.preInsert();
		paymentOrderDao.insert(paymentOrder);
	}

	@Transactional(readOnly = false)
	public void updateBusinessByPartner(PaymentOrder paymentOrder) {
		// 因为原来查询出来的订单详情都是未删除的，所以再次查询订单详情，已删除的也查
		if (paymentOrder != null && paymentOrder.getOrderCode() != null && !paymentOrder.getOrderCode().equals("")) {
			List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao
					.getOrderByRunningNum(paymentOrder.getOrderCode(), paymentOrder.getMemberCode());
			if (orderDetailList != null && orderDetailList.size() > 0) {
				orderDetailList.forEach(item -> {
					String chargingItemId = item.getChargingItemId();
					item.setPaymentChargingItem(
							paymentChargingItemService.get(new PaymentChargingItem(chargingItemId)));
				});
			}
			paymentOrder.setOrderDetailList(orderDetailList);
		}
		// 根据业务订单详情里的收费项去更新相应业务表的收费状态
		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrder.getOrderDetailList();
		int i = 0;
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 一个业务收费项为多个的情况下，只把主要业务的收费项的业务表设置上，这样只更新业务表不为空的收费详情
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())) {
				Member member = memberDao.getByMemberCode(paymentOrderDetail.getMemberCode());
				Member tempMember = new Member();
				if ("sys_member".equals(paymentOrderDetail.getBusinessTable())) {
					tempMember = memberDao.get(paymentOrderDetail.getBusinessIds());
				}

				DogChip dc = dogChipService.getByFmdogBreedCertifiedCode(paymentOrderDetail.getBusinessIds());
				String isall = "";
				if (dc != null)
					isall = dc.getIsAll();
				String sql = bulidSqlByPartner(member, paymentOrderDetail, isall);
				if (sql.contains("UPDATE dog_chip SET")) {

					if (dc != null && "1".equals(isall)) {
						i = i + 1;
						if (i > 1 && "2".equals(dc.getPaymentState()))
							continue;
						else
							// 查询是否整窝办理。如果整窝办理 血统证书整窝更新
							sql = "UPDATE dog_chip SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now()  WHERE fmdog_breed_certified_code = '"
									+ paymentOrderDetail.getBusinessIds() + "'";
					}
				}
				if (StringUtils.isNotBlank(sql)) {
					if (sql.contains(";")) {
						Arrays.asList(sql.split(";")).stream().filter(item -> StringUtils.isNotBlank(item))
								.forEach(item -> {
									int j = paymentRecordDao.changePaymentState(item);
									if (j <= 0) {
										throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE,
												"修改业务状态失败！");
									}
								});
					} else {
						int j = paymentRecordDao.changePaymentState(sql);
						if (j <= 0) {
							throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改业务状态失败！");
						}
					}
					// 记录日志
					if (sql.contains("sys_member") || sql.contains("kennel")) {
						logger.info("===#===mybatis intercept sql sys_member parameter:{}",
								sql.replaceAll("[\\t\\n\\r]", ""));
					}
				}
				// 修改业务表缴费状态为已缴费后的其他操作
				afterUpdatePaymentState(paymentOrderDetail, isall, tempMember.getMemberEndDate());
			} else if ("0".equals(paymentOrderDetail.getChargingItemId())) {// 账户充值
				// 获取用户余额
				double money = memberInfoDao.getMoney(paymentOrderDetail.getMemberCode());
				String sql = "update sys_member SET account_balance = account_balance+"
						+ Double.parseDouble(paymentOrderDetail.getTotalPrice()) + " WHERE member_code = '"
						+ paymentOrderDetail.getMemberCode() + "'";
				int j = paymentRecordDao.changePaymentState(sql);
				if (j <= 0) {

					throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改业务状态失败！");
				}
				int resultChange = memberDao.insertSysAccountBalanceChange(paymentOrderDetail.getMemberCode(),
						paymentOrder.getOrderCode(), String.valueOf(money), paymentOrderDetail.getTotalPrice());
				if (resultChange <= 0) {
					throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE, "增加余额变动记录失败！");
				}
			}
		}

		Set<String> businessCodes = paymentOrderDetailList.stream()
				.filter(detail -> StringUtils.isNotBlank(detail.getBusinessCode())
						&& detail.getBusinessCode().matches("^[999]\\d[9]\\d+$"))
				.map(detail -> detail.getBusinessCode()).collect(Collectors.toSet());
		if (businessCodes != null && !businessCodes.isEmpty() && businessCodes.size() == 1) {
			String businessCode = businessCodes.iterator().next();
			PaymentChargingItemGroup paymentChargingItemGroup = paymentChargingItemGroupDao.get(businessCode);
			if (paymentChargingItemGroup != null) {
				PaymentOrderDetail anyDetail = paymentOrderDetailList.stream()
						.filter(detail -> "sys_member".equals(detail.getBusinessTable())).findFirst().get();
				long current = System.currentTimeMillis();
				logger.info("会员后置处理 Start===============" + current);
				memberService.preferentialHandlerByPartner(anyDetail.getBusinessIds(), paymentOrder.getOrderCode(),
						businessCode, paymentChargingItemGroup.getCouponDefId(), paymentOrder.getCreateBy());
				logger.info("会员后置处理 End===============" + (System.currentTimeMillis() - current));
			}
		}

	}

	/**
	 * @description: 更新业务表
	 * @author: laiguanglong
	 * @date: 2016年9月23日 上午11:05:37
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void updateBusiness(PaymentOrder paymentOrder) {
		logger.info("updateBusiness ------ param : {}", JSONObjectUtils.toJsonString(paymentOrder));
		// 原会员信息
		Member oldMember = memberService.getBeneficiary(paymentOrder.getOrderCode());
		// 因为原来查询出来的订单详情都是未删除的，所以再次查询订单详情，已删除的也查
		if (paymentOrder != null && paymentOrder.getOrderCode() != null && !paymentOrder.getOrderCode().equals("")) {
			List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao
					.getOrderByRunningNum(paymentOrder.getOrderCode(), paymentOrder.getMemberCode());
			logger.info("updateBusiness----------orderDetailList : {}", JSONObjectUtils.toJsonString(orderDetailList));
			if (orderDetailList != null && orderDetailList.size() > 0) {
				orderDetailList.forEach(item -> {
					String chargingItemId = item.getChargingItemId();
					item.setPaymentChargingItem(
							paymentChargingItemService.get(new PaymentChargingItem(chargingItemId)));
				});
			}

			paymentOrder.setOrderDetailList(orderDetailList);
		}
		// 根据业务订单详情里的收费项去更新相应业务表的收费状态
		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrder.getOrderDetailList();

		// 由于引入 优惠券包功能，只有产生优惠券后才能操作优惠券，故将优惠券表处理逻辑放在最后-start
		List<PaymentOrderDetail> couponList = paymentOrderDetailList.stream()
				.filter(d -> "sys_coupon".equals(d.getBusinessTable())).collect(Collectors.toList());
		paymentOrderDetailList.removeAll(couponList);
		paymentOrderDetailList.addAll(couponList);
		// 由于引入 优惠券包功能，只有产生优惠券后才能操作优惠券，故将优惠券表处理逻辑放在最后-end

		// 处理会员续费时，由于专业会员费 和 永久犬舍费 会造成犬舍类型不一致，故将犬舍的处理逻辑放在最后-start
		List<PaymentOrderDetail> lastList = paymentOrderDetailList.stream()
				.filter(d -> "kennel".equals(d.getBusinessTable())).collect(Collectors.toList());
		if (!CollectionUtils.isEmpty(lastList)) {
			paymentOrderDetailList.removeAll(lastList);
			paymentOrderDetailList.addAll(lastList);
		}
		logger.info("------------------paymentOrderDetailList : {}", JSONObjectUtils.toJsonString(paymentOrderDetailList));
		int i = 0;
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			// 一个业务收费项为多个的情况下，只把主要业务的收费项的业务表设置上，这样只更新业务表不为空的收费详情
			if (StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())) {
				Member member = memberDao.getByMemberCode(paymentOrderDetail.getMemberCode());
				Member tempMember = new Member();
				if ("sys_member".equals(paymentOrderDetail.getBusinessTable())) {
					tempMember = memberDao.get(paymentOrderDetail.getBusinessIds());
				}
				DogChip dc = dogChipService.getByFmdogBreedCertifiedCode(paymentOrderDetail.getBusinessIds());
				String isall = "";
				if (dc != null)
					isall = dc.getIsAll();
				String sql = bulidSql(member, paymentOrderDetail, isall);
				if (sql.contains("UPDATE dog_chip SET")) {

					if (dc != null && "1".equals(isall)) {
						i = i + 1;
						if (i > 1 && "2".equals(dc.getPaymentState()))
							continue;
						else
							// 查询是否整窝办理。如果整窝办理 血统证书整窝更新
							sql = "UPDATE dog_chip SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now()  WHERE review_state !='3' AND fmdog_breed_certified_code = '"
									+ paymentOrderDetail.getBusinessIds() + "'";
					}
				}
				if (StringUtils.isNotBlank(sql)) {
					if (sql.contains(";")) {
						Arrays.asList(sql.split(";")).stream().filter(item -> StringUtils.isNotBlank(item))
								.forEach(item -> {
									int j = paymentRecordDao.changePaymentState(item);
									if (j <= 0) {
										throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE,
												"修改业务状态失败！");
									}
								});
					} else {
						int j = paymentRecordDao.changePaymentState(sql);
						if (j <= 0) {
							throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改业务状态失败！");
						}
					}

					// 记录日志
					if (sql.contains("sys_member") || sql.contains("kennel")) {
						logger.info("===#===mybatis intercept sql sys_member parameter:{}",
								sql.replaceAll("[\\t\\n\\r]", ""));
					}
				}
				// 修改业务表缴费状态为已缴费后的其他操作
				afterUpdatePaymentState(paymentOrderDetail, isall, tempMember.getMemberEndDate());
				// 如果修改了会员犬舍表，修正会员的卡类型
				if (isMemberKennel(paymentOrderDetail)) {
					Member memberNew = memberService.getBeneficiary(paymentOrder.getOrderCode());
					memberService.updateMemberCardType(memberNew.getMemberCode(),
							memberService.getMemberCardType(memberNew, memberNew.getKennel()));
				}
			} else if ("0".equals(paymentOrderDetail.getChargingItemId())) {// 账户充值
				// 获取用户余额
				double money = memberInfoDao.getMoney(paymentOrderDetail.getMemberCode());
				String sql = "update sys_member SET account_balance = account_balance+"
						+ Double.parseDouble(paymentOrderDetail.getTotalPrice()) + " WHERE member_code = '"
						+ paymentOrderDetail.getMemberCode() + "'";
				int j = paymentRecordDao.changePaymentState(sql);
				if (j <= 0) {
					throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE, "修改业务状态失败！");
				}
				int resultChange = memberDao.insertSysAccountBalanceChange(paymentOrderDetail.getMemberCode(),
						paymentOrder.getOrderCode(), String.valueOf(money), paymentOrderDetail.getTotalPrice());
				if (resultChange <= 0) {
					throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_MEMBERUPDATEFAIL_STATE, "增加余额变动记录失败！");
				}
			}
			if (DNA_ARCHIVE_ITEM_ID.equals(paymentOrderDetail.getChargingItemId())) {
				// 自检
				pushExpress(paymentOrderDetail, oldMember);
			}
		}
		// 操作会员犬舍表需要记录日志
		Set<String> businessCodes = paymentOrderDetailList.stream().filter(detail -> isMemberKennel(detail))
				.map(detail -> detail.getBusinessCode()).collect(Collectors.toSet());
		if (businessCodes != null && !businessCodes.isEmpty() && businessCodes.size() == 1) {
			String businessCode = businessCodes.iterator().next();
			PaymentChargingItemGroup paymentChargingItemGroup = paymentChargingItemGroupDao.get(businessCode);
			long current = System.currentTimeMillis();
			logger.info("会员后置处理 Start===============" + current);
			memberService.preferentialHandler(paymentOrder.getOrderCode(), businessCode,
					paymentChargingItemGroup == null ? null : paymentChargingItemGroup.getCouponDefId(), oldMember,
					paymentOrder.getCreateBy());
			logger.info("会员后置处理 End===============" + (System.currentTimeMillis() - current));
		}
		// 增加美容师会员续费的记录
		memberActivity20201212Discount.buildGroomer20201212Discount(paymentOrder);
	}

	/**
	 * 4625f60e8ac44d37b23ce2d972d1b532 DNA样本检测服务费（口腔上皮细胞）） 用于判断是否进入插入采样包邮寄记录流程
	 */
	private static final String DNA_ARCHIVE_ITEM_ID = "4625f60e8ac44d37b23ce2d972d1b532";

	private void pushExpress(PaymentOrderDetail paymentOrderDetail, Member oldMember) {
		if(StringUtils.isBlank(paymentOrderDetail.getBusinessIds())) {
			//防止后台支付无业务信息报错
			return;
		}
		String[] idArr = paymentOrderDetail.getBusinessIds().split(",");
		Stream.of(idArr).forEach(id -> {
			DogDnaArchive dogdnaArchive = dogDnaArchiveService.get(id);
			if (Objects.isNull(dogdnaArchive)) {
				// throw new ZAException(ZAErrorCode.ZA_ERC_PAYMENTRECORD_UPDATEFAIL_STATE,
				// "订单信息错误，支付失败！");
				return;
			}
			if (0 == dogdnaArchive.getApplyChannel()) {// 办理渠道 0机构办理 1 自检
				return;
			}
			String certificateName = "采样包";
			String certificateNo = "";
			if (StringUtils.isNotBlank(dogdnaArchive.getPedigreeCertified())) {
				// certificateName = "血统证书号";
				certificateNo = dogdnaArchive.getPedigreeCertified();
			} else if (StringUtils.isNotBlank(dogdnaArchive.getBirthCode())) {
				// certificateName = "出生纸编号";
				certificateNo = dogdnaArchive.getBirthCode();
			} else if (StringUtils.isNotBlank(dogdnaArchive.getBirthCode())) {
				// certificateName = "国外证书编号";
				certificateNo = dogdnaArchive.getOverseasPedigreeCertified();
			}
			expressQueueService.push(oldMember.getMemberCode(), paymentOrderDetail.getOrderCode(), certificateName,
					certificateNo, "dog_dna_archive", dogdnaArchive.getId(), DNA_ARCHIVE_ITEM_ID);
		});
	}

	private Boolean isMemberKennel(PaymentOrderDetail detail) {
		return ("sys_member".equals(detail.getBusinessTable()) || "kennel".equals(detail.getBusinessTable()))
				&& !"0".equals(detail.getChargingItemId());

	}

	@Transactional(readOnly = false)
	public void afterPayByPartner(PaymentOrder paymentOrder) {
		if (paymentOrder != null && "1".equals(paymentOrder.getPaymentState())) {
			SysContext sysContext = new SysContext("1", "0", "0");
			sysContext.payment(sysContext,
					"会员号：" + paymentOrder.getMemberCode() + "。业务订单表id:" + paymentOrder.getId() + "。",
					paymentOrder.getMemberCode(), "payment_order", paymentOrder.getId(), paymentOrder.getOrderCode(),
					(str) -> {
						// 原会员信息
						Member oldMember = memberService.getBeneficiary(paymentOrder.getOrderCode());
						// 更新业务订单表为已支付
						updatePaymentOrder(paymentOrder);
						// 更新业务表
						updateBusinessByPartner(paymentOrder);
						// 地方俱乐部新生犬缴费自动生成犬只信息
						// if (paymentOrder.getOrderCode().length() == 23 &&
						// paymentOrder.getOrderCode().contains("HZ")) { // 地方俱乐部新生犬订单
						// createDog(paymentOrder.getOrderCode());
						// }
						// 写入流水表
						PaymentRecord paymentRecord = insertPaymentRecord(paymentOrder);
						// 订单拆分
						splitOrderService.initSplitAsync(paymentOrder.getOrderCode());
						// 更新会员表第一次缴费时间
						memberService.updateFirstPaymentTime(paymentRecord.getRunningNumber(), oldMember);
					});
		}
	}

	/**
	 * @description: 会员端支付后处理逻辑
	 * @author: laiguanglong
	 * @date: 2016年9月23日 下午4:30:01
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void afterPay(PaymentOrder paymentOrder) {
		if (paymentOrder != null && "1".equals(paymentOrder.getPaymentState())) {
			SysContext sysContext = new SysContext("1", "0", "0");
			sysContext.payment(sysContext,
					"会员号：" + paymentOrder.getMemberCode() + "。业务订单表id:" + paymentOrder.getId() + "。",
					paymentOrder.getMemberCode(), "payment_order", paymentOrder.getId(), paymentOrder.getOrderCode(),
					(str) -> {
						// 原会员信息
						Member oldMember = memberService.getBeneficiary(paymentOrder.getOrderCode());
						// 更新业务订单表为已支付
						updatePaymentOrder(paymentOrder);
						// 更新业务表
						long current = System.currentTimeMillis();
						logger.info("更新业务表 Start===============" + current);
						updateBusiness(paymentOrder);
						logger.info("更新业务表 End===============" + (System.currentTimeMillis() - current));
						// 地方俱乐部新生犬缴费自动生成犬只信息
						// if (paymentOrder.getOrderCode().length() == 23 &&
						// paymentOrder.getOrderCode().contains("HZ")) { // 地方俱乐部新生犬订单
						// createDog(paymentOrder.getOrderCode());
						// }
						// 写入流水表
						PaymentRecord paymentRecord = insertPaymentRecord(paymentOrder);

						// splitOrderService.initSplit(paymentOrder.getOrderCode());
						// 订单拆分
						splitOrderService.initSplitAsync(paymentOrder.getOrderCode());
						// 更新会员表第一次缴费时间
						memberService.updateFirstPaymentTime(paymentRecord.getRunningNumber(), oldMember);
					});
		}
	}

	@Transactional(readOnly = false)
	public void balPayClub(PaymentOrder paymentOrder) {
		// 如果是抢购的订单
		if ("1".equals(paymentOrder.getIsBuying())) {
			synchronized (this) {
				// 根据订单编号查询抢购订单表中的记录
				List<BuyingOrder> list = buyingOrderDao.findForRunningNumber(paymentOrder.getOrderCode());
				// 根据产品id和犬种获取剩余数量
				restAdvertisementService.checkAdvertisement(advertisementDao.get(list.get(0).getCommodityId()),
						list.get(0).getDogType(), StringUtils.isBlank(list.get(0).getDogType()) ? false : true, "2");
				// 充值订单不能使余额支付
				if ("1".equals(paymentOrder.getIsRecharge())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "充值订单不能使余额支付");
				}
				// 扣除用户的余额
				paymentOrder.setPaymentWay("25");// 25代表余额支付

				memberService.memberCharge(UserUtils.getLoginPartner().getMemberCode(), paymentOrder.getTotalPrice(),
						paymentOrder.getOrderCode());
				afterPay(paymentOrder);
			}
		} else {
			// 充值订单不能使余额支付
			if ("1".equals(paymentOrder.getIsRecharge())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "充值订单不能使余额支付");
			}
			/**
			 * 如果为赛事订单，判断是否以过赛事报名截至时间
			 *
			 * @Description:
			 * @author: zhangxiang
			 * @date: 2019/10/16 13:03
			 */
			checkShowApplyClosing(paymentOrder);
			// 扣除用户的余额
			paymentOrder.setPaymentWay("25");// 25代表余额支付
			memberService.memberCharge(UserUtils.getLoginPartner().getMemberCode(), paymentOrder.getTotalPrice(),
					paymentOrder.getOrderCode());
			afterPay(paymentOrder);
		}
	}

	@Transactional(readOnly = false)
	public void balPay(PaymentOrder paymentOrder,Member member) {
		// 如果是抢购的订单
		if ("1".equals(paymentOrder.getIsBuying())) {
			synchronized (this) {
				// 根据订单编号查询抢购订单表中的记录
				List<BuyingOrder> list = buyingOrderDao.findForRunningNumber(paymentOrder.getOrderCode());
				// 根据产品id和犬种获取剩余数量
				restAdvertisementService.checkAdvertisement(advertisementDao.get(list.get(0).getCommodityId()),
						list.get(0).getDogType(), StringUtils.isBlank(list.get(0).getDogType()) ? false : true, "2");
				// 充值订单不能使余额支付
				if ("1".equals(paymentOrder.getIsRecharge())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "充值订单不能使余额支付");
				}
				// 扣除用户的余额
				paymentOrder.setPaymentWay("25");// 25代表余额支付
				memberService.memberCharge(member.getMemberCode(), paymentOrder.getTotalPrice(),
						paymentOrder.getOrderCode());
				afterPay(paymentOrder);
			}
		} else {
			// 充值订单不能使余额支付
			if ("1".equals(paymentOrder.getIsRecharge())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "充值订单不能使余额支付");
			}
			/**
			 * 如果为赛事订单，判断是否以过赛事报名截至时间
			 *
			 * @Description:
			 * @author: zhangxiang
			 * @date: 2019/10/16 13:03
			 */
			checkShowApplyClosing(paymentOrder);
			// 扣除用户的余额
			paymentOrder.setPaymentWay("25");// 25代表余额支付
			memberService.memberCharge(member.getMemberCode(), paymentOrder.getTotalPrice(),
					paymentOrder.getOrderCode());
			afterPay(paymentOrder);
		}
	}

	/**
	 * @description: 更新业务订单表为已支付
	 * @author: laiguanglong
	 * @date: 2016年9月23日 下午4:44:17
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void updatePaymentOrder(PaymentOrder paymentOrder) {
		paymentOrder.setPaymentState("2");
		paymentOrder.setPaymentTime(new Date());
		// paymentOrder.setOrderCode(runningNum);
		paymentOrder.preUpdate();
		paymentOrderDao.update(paymentOrder);
	}

	/**
	 * @description: 写入流水表
	 * @author: laiguanglong
	 * @date: 2016年9月23日 下午4:51:56
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public PaymentRecord insertPaymentRecord(PaymentOrder paymentOrder) {
		return paymentRecordService.addRecordByOrder(paymentOrder);
	}

	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	public static final String MEMER_BASIC = "sys_member@B";// 基础会员费
	public static final String MEMBER_PROFESSIONAL = "sys_member@P";// 专业会员费
	public static final String MEMBER_PROFESSIONAL_FIRST = "sys_member@F";// 专业会员的新注册费
	public static final String MEMBER_BASIC_TO_PROFESSIONAL = "sys_member@BTP";// 普通会员升级为专业会员
	public static final String MEMBER_PROFESSIONAL_BREED = "sys_member@PB";// 繁育专业会员登记费
	public static final String MEMBER_EXPIRE_IDENTICAL = "sys_member@EI";// 会员及犬舍有效期同步
	public static final String MEMBER_PROFESSIONAL_BREED_FIRST = "sys_member@PBF";// 繁育专业会员初次注册费
	public static final String KENNEL_FIRST = "kennel@ZC";// 犬舍名称初次注册费
	public static final String KENNEL_YEAR = "kennel@ND";// 犬舍年度登记费
	public static final String KENNEL_PERMANENT = "kennel@YJ";// 永久犬舍名称登记费
	public static final String DOG_BIRTH_CERTIFICATE = "dog_birth_certificate";
	public static final String DOG_CHIP_CHANGE = "dog_chip_change";
	public static final String RECHARGE = "sys_member@recharge";// 会员充值
	private static final String Groomer_RESERVE = "sys_member@GR";// 预备会员
	private static final String Groomer_FORMAL = "sys_member@GF";// 正式会员
	private static final String Groomer_SCHOOL = "sys_member@GS";// 美容学校合作费用
	private static final String CLUB_DOG = "club_dog@jd";// 美容学校合作费用
	private static final String DOG_CHIP = "dog_chip";// 新生犬登记
	private static final String CHAMPION_LOGIN = "show_champion_login";// 冠军登录
	private static final String DOG_APPRAISAL = "dog_appraisal";// 会员中心犬只鉴定
	private static final String SHOW_APPLY = "show_apply";// 会员中心赛事报名
	private static final String SYS_COUPON = "sys_coupon";// 出生纸优惠劵
	private static final String DOG_ACTIVITION = "dog_activation";// 超时激活
	private static final String DOG_STICKER_APPLY = "dog_sticker_apply";// 犬只等级贴纸申请
	private static final String GROOMER_PACKAGE = "groomer_package";// 美容套餐
	private static final String GROOMER_COURSE_APPLICATION = "groomer_course_application";// 美容课程报名
	private static final String DOG_VIDEO_APPRAISAL = "dog_video_appraisal";
	private static final String DOG_BLOOD_SAVE = "dog_blood_save";
	private static final String DOG_DNA_ARCHIVE = "dog_dna_archive";
	private static final String DOG_OWNER_CHANGE = "dog_owner_change";
	private static final String USER_COUPON_COMPOSE = "user_coupon_compose";
	private static final String KENNEL_OWNER_CHANGE = "kennel_owner_change";
	private static final String APPRECIATION_APPLY = "appreciation_apply";
	private static final String DOG_DNA_ARCHIVE_REISSUE_SAMPLING = "dog_dna_archive_reissue_sampling";
	private static final String GROOMER_QUALIFICATION_CERTIFICATE_CHANGE = "groomer_qualification_certificate_change";

	/**
	 * 美容笔试信息表
	 */
	private static final String GROOMER_WRITTEN_EXAM_INFO = "groomer_written_exam_info";

	public static final List<String> BUSINESSTABLES_LIST = new ArrayList<String>() {
		{
			add("groomer_register");
			add("handler_register");
			add("groomer_qualification_certificate");
			add("handler_qualification_certificate");
			add("dog_newborn");
			add("dog_owner_change");
			add("dog_pedigree_certified_change");
			add("dog_pedigree_certified_export");
			add("dog_pedigree_certified_redo");
			add("kennel_rename");
			add("dog_blood_save");
			add("dog_dna_archive");
			add("dog_dna_parents_compare");
			add("groomer_diploma");
			add("dog_frozen_semen");
			add("dog_semen_change");
			add("new_pet_passport.companion_dog_appraisal");
			add(DOG_DNA_ARCHIVE_REISSUE_SAMPLING);
			add("fci_groomer_qualification_certificate");
			add(GROOMER_QUALIFICATION_CERTIFICATE_CHANGE);
		}
	};

	public String bulidSqlByPartner(Member member, PaymentOrderDetail paymentOrderDetail, String isall) {
		StringBuffer buffer = new StringBuffer(128);
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(paymentOrderDetail.getChargingItemId());
		String shortName = paymentChargingItem.getShortName();
		String tableName;
		if (StringUtils.isBlank(shortName))
			tableName = paymentOrderDetail.getBusinessTable();
		else
			tableName = shortName.split("@")[0];

		String businessIds = paymentOrderDetail.getBusinessIds();
		if (DOG_BIRTH_CERTIFICATE.equals(tableName)) {// 出生证明业务记录表根据父母配种证明号进行批量更新
			buffer.append(
					"UPDATE dog_birth_certificate SET payment_state = 2,payment_time = now() WHERE fmdog_breed_certified_code = '")
					.append(businessIds).append("' AND del_flag='0'");
		} else if (SYS_COUPON.equals(tableName)) {// 优惠劵记录表根据出生纸的父母配种证明号进行批量更新
			if (businessIds.indexOf("#") != -1) {// 实收金额=优惠卷的价格+订单的价格
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),payment_amount = payment_amount+'")
						.append(paymentOrderDetail.getTotalPrice()).append("' WHERE id = '")
						.append(businessIds.split("#")[0]).append("'");
			} else if (shortName.equals("sys_coupon@DK")) {
				String[] split = businessIds.split("&");
				String s = split[0];
				buffer.append("UPDATE sys_coupon SET update_date = now(), target_id = '").append(s)
						.append("'WHERE target_id = '").append(businessIds).append("' AND del_flag='0'");
			} else if (shortName.startsWith("sys_coupon@xn_")) {
				buffer.append("UPDATE sys_coupon SET update_date = now(),target_id='")
						.append(paymentOrderDetail.getOrderCode()).append("',usestate='1' WHERE id = '")
						.append(businessIds).append("' AND del_flag='0'");
			} else {
				buffer.append("UPDATE sys_coupon SET update_date = now() WHERE target_id = '").append(businessIds)
						.append("' AND del_flag='0'");
			}
		} else if (DOG_CHIP_CHANGE.equals(tableName)) {
			// 该收费项会被出生纸申请业务，证书换发，犬只鉴定业务使用。
			// 由于出生纸业务会出现一条订单详情，数量大于1，缴费后会更新多条记录，所以不用id，用配种证明号进行一条sql更新的情况。故这里要分开判断
			// 出生纸业务使用该收费项时，通过配种证明号再次更新
			if ("1".equals(isall))
				buffer.append("UPDATE dog_chip SET");
			if (businessIds.length() != 32 && (StringUtils.isNumeric(businessIds) || businessIds.contains("DC"))) {
				buffer.append(
						"UPDATE dog_birth_certificate SET payment_state = 2,payment_time = now() WHERE fmdog_breed_certified_code = '")
						.append(businessIds).append("' AND del_flag='0'");
			} else {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
			}
		} else if (DOG_CHIP.equals(tableName)) {
			if (StringUtils.isNotBlank(paymentOrderDetail.getRemarks())
					&& paymentOrderDetail.getRemarks().contains("登记卡编号")) {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET chip_inject_flag = 1,remarks = '代打芯片订单号：" + paymentOrderDetail.getOrderCode()
						+ "'  WHERE id = '").append(businessIds).append("'");
			} else {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now()  WHERE id = '")
						.append(businessIds).append("'");
				// 血统证书号生成规则调整
				// 存在鼻纹信息自动生成犬只信息和血统证书处理状态为已处理
				// dogChipService.createBirthCode(businessIds);
			}
		} else if (BUSINESSTABLES_LIST.contains(tableName)) {
			if (DOG_BLOOD_SAVE.equals(tableName) || DOG_DNA_ARCHIVE.equals(tableName)) {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),finish_time = now() WHERE id = '")
						.append(businessIds).append("'");
			} else {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
			}

		} else if (SHOW_APPLY.contains(tableName)) {
			if (businessIds.indexOf("#") != -1) {// 实收金额=优惠卷的价格+订单的价格
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),payment_amount = payment_amount+'")
						.append(paymentOrderDetail.getTotalPrice()).append("' WHERE id = '")
						.append(businessIds.split("#")[0]).append("'");
			} else {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),payment_amount = '")
						.append(paymentOrderDetail.getTotalPrice()).append("' WHERE id = '").append(businessIds)
						.append("'");
			}
		} else if (DOG_APPRAISAL.contains(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now(),review_state = IF(review_state=0,'0','1'),review_time = now() WHERE id = '")
					.append(businessIds).append("'");
		} else if (shortName.equals(KENNEL_FIRST)) { // 犬舍注册注册费
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelFirstSql(buffer, businessIds);
		} else if (shortName.equals(KENNEL_PERMANENT)) {// 永久犬舍费
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelPermanentSql(buffer, businessIds);
		} else if (shortName.equals(MEMER_BASIC)) {// 基础会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memerBasicSql(buffer, businessIds, member);
		} else if (shortName.equals(MEMBER_PROFESSIONAL_FIRST)) {// 专业会员初次注册费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalFirstSql(buffer, businessIds);
		} else if (shortName.equals(MEMBER_PROFESSIONAL)) {// 专业会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalSql(buffer, businessIds, member);
		} else if (shortName.equals(MEMBER_PROFESSIONAL_BREED_FIRST)) {// 繁育专业会员登记费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalBreedFirstSql(buffer, businessIds);
		} else if (shortName.equals(MEMBER_PROFESSIONAL_BREED)) {// 繁育专业会员登记费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalBreedSql(buffer, businessIds);
		} else if (shortName.equals(MEMBER_EXPIRE_IDENTICAL)) {// 会员及犬舍日期同步
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberExpireIdenticalSql(buffer, businessIds);
		} else if (shortName.equals(Groomer_RESERVE) || shortName.equals(Groomer_FORMAL)) {
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberGroomerRenewSql(buffer, businessIds, member);
		} else if (shortName.equals(Groomer_SCHOOL)) {
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberGroomerSchoolMemberRenewSql(buffer, businessIds, member);
		} else if (shortName.equals(CLUB_DOG)) {
			ClubDogService clubDogService = (ClubDogService) SpringContextHolder.getBean("clubDogService");
			clubDogService.clubDogToCreate(buffer, businessIds);
		} else if (tableName.equals(CHAMPION_LOGIN)) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ").append(2).append(" ,")
					.append("payment_membership_code = '").append(member.getMemberCode()).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(new Date())).append("'")
					.append("WHERE id='").append(businessIds).append("'");
			// cku_buying
		} else if (tableName.equals("cku_buying")) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ").append(2).append(" ,")
					.append("payment_time = '").append(DateUtils.formatDateTime(new Date())).append("'").append(" ,")
					.append("payment_way = '").append("25").append("' ").append("WHERE id='").append(businessIds)
					.append("'");
		} else if (tableName.equals("buying_order")) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ").append(2).append(" ,")
					.append("payment_time = '").append(DateUtils.formatDateTime(new Date())).append("'").append(" ")
					.append("WHERE id='").append(businessIds).append("'");
		} else if (DOG_ACTIVITION.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now(),review_state = '1',"
					+ "front_pic_review_state ='1',side_pic_review_state ='1',back_pic_review_state ='1',review_time = now() WHERE id = '")
					.append(businessIds).append("'");
		} else if (DOG_STICKER_APPLY.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (DOG_BIRTH_CERTIFICATE.equals(tableName) || DOG_CHIP.equals(tableName)) {
			buffer.append(
					"UPDATE  dog_second_breeder SET payment_state = 2,payment_time = now() WHERE breed_certified_code = '")
					.append(businessIds).append("'");

		}

		return buffer.toString();
	}

	public String bulidSql(Member member, PaymentOrderDetail paymentOrderDetail, String isall) {
		logger.info("bulidSql ------ param : {}", JSONObjectUtils.toJsonString(paymentOrderDetail));
		StringBuffer buffer = new StringBuffer(128);
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(paymentOrderDetail.getChargingItemId());
		logger.info("bulidSql ------ paymentChargingItem : {}", JSONObjectUtils.toJsonString(paymentChargingItem));
		String shortName = paymentChargingItem.getShortName();
		String tableName;

		if (StringUtils.isBlank(shortName)) {
			tableName = paymentOrderDetail.getBusinessTable();
		} else {
			tableName = shortName.split("@")[0];
		}
		logger.info("tableName : {}",tableName);
		logger.info("shortName : {}",shortName);
		String businessIds = paymentOrderDetail.getBusinessIds();
		String[] businessIdArr = businessIds.split(",");
		if (DOG_BIRTH_CERTIFICATE.equals(tableName)) {// 出生证明业务记录表根据父母配种证明号进行批量更新
			buffer.append(
					"UPDATE dog_birth_certificate SET payment_state = 2,payment_time = now() WHERE  review_state !='3' AND fmdog_breed_certified_code = '")
					.append(businessIds).append("' AND del_flag='0'");
		} else if (SYS_COUPON.equals(tableName)) {// 优惠劵记录表根据出生纸的父母配种证明号进行批量更新
			if (businessIds.indexOf("#") != -1) {// 实收金额=优惠卷的价格+订单的价格
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),payment_amount = payment_amount+'")
						.append(paymentOrderDetail.getTotalPrice()).append("' WHERE id = '")
						.append(businessIds.split("#")[0]).append("'");
			} else if (shortName.equals("sys_coupon@DK")) {
				String[] split = businessIds.split("&");
				String s = split[0];
				buffer.append("UPDATE sys_coupon SET update_date = now(), target_id = '").append(s)
						.append("'WHERE target_id = '").append(businessIds).append("' AND del_flag='0'");
			} else if (shortName.startsWith("sys_coupon@xn_")) {
				buffer.append("UPDATE sys_coupon SET update_date = now(),target_id='")
						.append(paymentOrderDetail.getOrderCode()).append("',usestate='1' WHERE id = '")
						.append(businessIds).append("' AND del_flag='0'");
			} else {
				buffer.append("UPDATE sys_coupon SET running_number ='").append(paymentOrderDetail.getOrderCode())
						.append("', update_date = now() WHERE target_id = '").append(businessIds)
						.append("' AND del_flag='0'");
			}
		} else if (DOG_CHIP_CHANGE.equals(tableName)) {
			// 该收费项会被出生纸申请业务，证书换发，犬只鉴定业务使用。
			// 由于出生纸业务会出现一条订单详情，数量大于1，缴费后会更新多条记录，所以不用id，用配种证明号进行一条sql更新的情况。故这里要分开判断
			// 出生纸业务使用该收费项时，通过配种证明号再次更新
			if ("1".equals(isall))
				buffer.append("UPDATE dog_chip SET");
			if (businessIds.length() != 32 && (StringUtils.isNumeric(businessIds) || businessIds.contains("DC"))) {
				buffer.append(
						"UPDATE dog_birth_certificate SET payment_state = 2,payment_time = now() WHERE fmdog_breed_certified_code = '")
						.append(businessIds).append("' AND del_flag='0' AND   review_state !='3'");
			} else {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
			}
		} else if (DOG_CHIP.equals(tableName)) {

			if (!paymentOrderDetail.getBusinessTable().equals(USER_COUPON_COMPOSE)) {
				if (StringUtils.isNotBlank(paymentOrderDetail.getRemarks())
						&& paymentOrderDetail.getRemarks().contains("登记卡编号")) {
					buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
							+ " SET chip_inject_flag = 1,remarks = '代打芯片订单号：" + paymentOrderDetail.getOrderCode()
							+ "'  WHERE id = '").append(businessIds).append("'");
				} else {
					buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
							+ " SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now()  WHERE id = '")
							.append(businessIds).append("'");
					if (!PaymentItemIdConstants.GOLD_CERTIFIED_LT1.equals(paymentOrderDetail.getChargingItemId())
							&& !PaymentItemIdConstants.GOLD_CERTIFIED_GT1
									.equals(paymentOrderDetail.getChargingItemId())) {
						// 血统证书号生成规则调整
						// 通过血统证书申请而非金质证书
						// 存在鼻纹信息自动生成犬只信息和血统证书处理状态为已处理
						dogChipService.createBirthCode(businessIds);
					}
					String cacheValue = (String) CacheUtils.get("dog_chip_sms_breeder:" + businessIds);
					if (StringUtils.isEmpty(cacheValue)) {
						// 变更犬主给繁殖人发送短信
						dogChipService.sendSmsForBreeder(businessIds);
						CacheUtils.put("dog_chip_sms_breeder:" + businessIds, businessIds);
					}
				}
			}
		} else if (BUSINESSTABLES_LIST.contains(tableName)) {
			buffer.append("UPDATE ").append(paymentOrderDetail.getBusinessTable())
					.append(" SET payment_state = 2,payment_time = now()");
			if (DOG_BLOOD_SAVE.equals(tableName) || DOG_DNA_ARCHIVE.equals(tableName)) {
				if (DOG_BLOOD_SAVE.equals(tableName)) {
					DogBloodSave dogBloodSave = dogBloodSaveService.get(paymentOrderDetail.getBusinessIds());
					if (dogBloodSave != null && "2".equals(dogBloodSave.getTypeYes())) {
						buffer.append(",finish_time = now()");
					}
				} else if (DOG_DNA_ARCHIVE.equals(tableName)) {
					DogDnaArchive dogDnaArchive = dogDnaArchiveService.get(paymentOrderDetail.getBusinessIds());
					if (dogDnaArchive != null && "2".equals(dogDnaArchive.getTypeYes())) {
						buffer.append(",finish_time = now()");
					}
				}
			} else if (DOG_OWNER_CHANGE.equals(tableName)
					|| GROOMER_QUALIFICATION_CERTIFICATE_CHANGE.equals(tableName)) {
				buffer.append(",running_number= '").append(paymentOrderDetail.getOrderCode()).append("'");
			} else if (GROOMER_QUALIFICATION_CERTIFICATE.equals(tableName)) {
				switch (shortName) {
					case GROOMER_QUALIFICATION_CERTIFICATE_A:
					case GROOMER_QUALIFICATION_CERTIFICATE_B:
					case GROOMER_QUALIFICATION_CERTIFICATE_C:
					case GROOMER_QUALIFICATION_CERTIFICATE_MASTER:
						GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateDao
								.get(paymentOrderDetail.getBusinessIds());
						logger.info("美容资格证书支付回调接口，查询资格证书信息 : {}", JSONObjectUtils.toJsonString(groomerQualificationCertificate));
						FciGroomerQualificationCertificate fciGroomerQualificationCertificate = this.generateFciCertificate(groomerQualificationCertificate);
						fciGroomerQualificationCertificateService.save(fciGroomerQualificationCertificate);
						break;
					case PDG_GROOMER_QUALIFICATION_CERTIFICATE:
						logger.info("------------------------------------ 派多格");
						buffer.append(",take_certificate_date = now(), issue_date = now(), certificate_state = '1', update_date = now()");
						break;
					case GROOMER_QUALIFICATION_CERTIFICATE_PET:
					case GROOMER_QUALIFICATION_CERTIFICATE_PET_DOLD:
						buffer.append(",running_number = '").append(paymentOrderDetail.getOrderCode()).append("',")
								.append("certificate_state = '1' ");
						break;
				}
				buffer.append(",running_number= '").append(paymentOrderDetail.getOrderCode()).append("'");
			} else if (FCI_GROOMER_QUALIFICATION_CERTIFICATE.equals(tableName)) {
				buffer.append(",running_number= '").append(paymentOrderDetail.getOrderCode()).append("'")
						.append(",take_certificate_date = now(), issue_date = now(), certificate_state = '1', update_date = now()");
			}
			if (businessIdArr.length > 1) {
				buffer.append(" WHERE id IN (");
				for (int i = 0; i < businessIdArr.length; i++) {
					buffer.append("'").append(businessIdArr[i]).append("'");
					if (i < businessIdArr.length - 1) {
						buffer.append(",");
					}
				}
				buffer.append(")");
			} else {
				buffer.append(" WHERE id = '").append(businessIds).append("'");
			}
		} else if (SHOW_APPLY.contains(tableName)) {
			if (businessIds.indexOf("#") != -1) {// 实收金额=优惠卷的价格+订单的价格
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),payment_amount = payment_amount+'")
						.append(paymentOrderDetail.getTotalPrice()).append("' WHERE id = '")
						.append(businessIds.split("#")[0]).append("'");
			} else {
				//兼容后台生成订单 服务费+订单总额
				ShowApply showApply = showApplyDao.get(businessIds);
				String paymentAmountOld = showApply.getPaymentAmount();
				String paymentAmount;
				PaymentOrder paymentOrder = paymentOrderDao.getByorderCode(paymentOrderDetail.getOrderCode());
				
				if(paymentAmountOld.contains("+")){
					//服务费+订单总额
					paymentAmount = paymentAmountOld.split("\\+")[0]+"+"+paymentOrder.getTotalPrice();
				}else if(showApply.getFee().contains("+")){
					//只有服务费 改为服务费+订单总额
					paymentAmount = paymentAmountOld+"+"+paymentOrder.getTotalPrice();
				}else{
					//为空直接填入订单总额
					paymentAmount=paymentOrder.getTotalPrice();
				}
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),payment_amount = '")
						.append(paymentAmount).append("' WHERE id = '").append(businessIds)
						.append("'");
			}
		} else if (DOG_APPRAISAL.contains(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (shortName.equals(KENNEL_FIRST)) { // 犬舍注册注册费
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelFirstSql(buffer, businessIds);
		} else if (shortName.equals(KENNEL_PERMANENT)) {// 永久犬舍费
			KennelService kennelService = (KennelService) SpringContextHolder.getBean("kennelService");
			kennelService.kennelPermanentSql(buffer, businessIds);
		} else if (shortName.equals(MEMER_BASIC)) {// 基础会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memerBasicSql(buffer, businessIds, member);
		} else if (shortName.equals(MEMBER_PROFESSIONAL_FIRST)) {// 专业会员初次注册费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalFirstSql(buffer, businessIds);
		} else if (shortName.equals(MEMBER_PROFESSIONAL)) {// 专业会员缴费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalSql(buffer, businessIds, member);
		} else if (shortName.equals(MEMBER_PROFESSIONAL_BREED_FIRST)) {// 繁育专业会员登记费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalBreedFirstSql(buffer, businessIds);
		} else if (shortName.equals(MEMBER_PROFESSIONAL_BREED)) {// 繁育专业会员登记费
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberProfessionalBreedSql(buffer, businessIds);
		} else if (shortName.equals(MEMBER_EXPIRE_IDENTICAL)) {// 会员及犬舍日期同步
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberExpireIdenticalSql(buffer, businessIds);
		} else if (shortName.equals(Groomer_RESERVE) || shortName.equals(Groomer_FORMAL)) {
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberGroomerRenewSql(buffer, businessIds, member);
		} else if (shortName.equals(Groomer_SCHOOL)) {
			UserService userService = (UserService) SpringContextHolder.getBean("userService");
			userService.memberGroomerSchoolMemberRenewSql(buffer, businessIds, member);
		} else if (shortName.equals(CLUB_DOG)) {
			ClubDogService clubDogService = (ClubDogService) SpringContextHolder.getBean("clubDogService");
			clubDogService.clubDogToCreate(buffer, businessIds);
		} else if (tableName.equals(CHAMPION_LOGIN)) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ").append(2).append(" ,")
					.append("payment_membership_code = '").append(member.getMemberCode()).append("',")
					.append("payment_time = '").append(DateUtils.formatDateTime(new Date())).append("'")
					.append("WHERE id='").append(businessIds).append("'");
			// cku_buying
		} else if (tableName.equals("cku_buying")) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ").append(2).append(" ,")
					.append("payment_time = '").append(DateUtils.formatDateTime(new Date())).append("'").append(" ,")
					.append("payment_way = '").append("25").append("' ").append("WHERE id='").append(businessIds)
					.append("'");
		} else if (tableName.equals("buying_order")) {
			buffer.append("UPDATE ").append(tableName).append(" SET ").append("payment_state = ").append(2).append(" ,")
					.append("payment_time = '").append(DateUtils.formatDateTime(new Date())).append("'").append(" ")
					.append("WHERE id='").append(businessIds).append("'");
		} else if (DOG_ACTIVITION.equals(tableName)) {
			DogActivation dogActivation = dogActivationService.get(businessIds);
			DogBirthCertificate birthCertificate = dogBirthCertificateService
					.getByBirthCerRegCode(dogActivation.getBirthCode());
			// 会员中心超期激活交费后状态为激活中
			if (birthCertificate != null && StringUtils.isNotBlank(birthCertificate.getActivitionState())
					&& birthCertificate.getActivitionState().equals("3")) {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),review_state = '0',"
						+ "front_pic_review_state ='0',side_pic_review_state ='0',back_pic_review_state ='0',review_time = now() WHERE id = '")
						.append(businessIds).append("'");
			} else {
				buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
						+ " SET payment_state = 2,payment_time = now(),review_state = '1',"
						+ "front_pic_review_state ='1',side_pic_review_state ='1',back_pic_review_state ='1',review_time = now() WHERE id = '")
						.append(businessIds).append("'");
			}
		} else if (DOG_STICKER_APPLY.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (GROOMER_PACKAGE.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (GROOMER_COURSE_APPLICATION.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (DOG_VIDEO_APPRAISAL.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (USER_COUPON_COMPOSE.equals(tableName)) { // 优惠包
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
			// 发放优惠券
			sysCouponService.sendCouponCompose(businessIds);
		} else if (KENNEL_OWNER_CHANGE.equals(tableName)) {
			// 将业务状态变更为 已审核 ，已处理，同时将犬舍过户，并修改原，新会员的会员类型
			buffer.append("UPDATE ").append(paymentOrderDetail.getBusinessTable()).append(
					" SET payment_state = 2,payment_time = now(),review_state = '1',review_time = now(),review_remarks='系统自动审核通过',")
					.append("process_state = '1',process_time = now(),operator='")
					.append(paymentOrderDetail.getMemberCode()).append("系统自动审核' WHERE id = '").append(businessIds)
					.append("';");
			KennelOwnerChangeService kennelOwnerChangeService = (KennelOwnerChangeService) SpringContextHolder
					.getBean("kennelOwnerChangeService");
			kennelOwnerChangeService.changeKennel(businessIds);

		} else if (APPRECIATION_APPLY.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
		} else if (GROOMER_WRITTEN_EXAM_INFO.equals(tableName)) {
			buffer.append("UPDATE " + paymentOrderDetail.getBusinessTable()
					+ " SET payment_state = 2,payment_time = now() WHERE id = '")
					.append(businessIds).append("' and del_flag = '0'");
			GroomerWrittenExamInfo groomerWrittenExamInfo = groomerWrittenExamInfoService.get(businessIds);
			GroomerRegister groomerRegister = groomerRegisterService.get(groomerWrittenExamInfo.getRegisterId());
			groomerRegister.setEligibility(Boolean.TRUE);
			groomerRegister.setUpdateDate(new Date());
			groomerRegisterService.save(groomerRegister);
		}
		return buffer.toString();
	}

	/**
	 * 地方俱乐部新生犬缴费直接生成犬只
	 *
	 * @Author chaixueteng
	 * @2017年1月16日下午2:02:51
	 */
	private void createDog(String order) {
		PaymentOrder orderByRunningNum = paymentOrderDao.getOrderByRunningNum(order);
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao
				.getOrderByRunningNum(orderByRunningNum.getOrderCode(), orderByRunningNum.getMemberCode());
		for (PaymentOrderDetail pod2 : orderDetailList) {
			String businessTable = pod2.getBusinessTable();
			String businessIds = pod2.getBusinessIds();
			if ("dog_chip".equals(businessTable)) {// 直接处理生成犬只信息 和血统证书号
				DogChip dogChip = dogChipService.get(businessIds);
				dogChip.setReviewState("1");
				dogChipDao.changeStatus(dogChip);
				dogChipService.changeProcessState(dogChip);
			}
		}
	}

	/**
	 * @description: 查询已交费及未交费订单数量
	 * @author: laiguanglong
	 * @date: 2016年9月30日 下午2:27:21
	 */
	public RESTResponse orderCount() {
		Member member = UserUtils.getLoginMember();
		JSONObject jo = new JSONObject();
		// 查询未缴费订单数量
		int unpayCount = paymentOrderDao.countByPaymentState(member.getMemberCode(), "1");
		// 查询已缴费订单数量
		int payCount = paymentOrderDao.countByPaymentState(member.getMemberCode(), "2");
		jo.put("unpayCount", unpayCount + "");
		jo.put("payCount", payCount + "");
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 修改业务表缴费状态为已缴费后的其他操作
	 * @author: laiguanglong
	 * @date: 2017/2/10 17:58
	 */
	private void afterUpdatePaymentState(PaymentOrderDetail paymentOrderDetail, String isall, Date oldMemberEndDate) {
		PaymentChargingItem paymentChargingItem = paymentChargingItemDao.get(paymentOrderDetail.getChargingItemId());
		String shortName = paymentChargingItem.getShortName();
		String tableName = null;
		if (StringUtils.isNotEmpty(shortName))
			tableName = shortName.split("@")[0];
		if (StringUtils.isBlank(tableName)) {
			tableName = paymentOrderDetail.getBusinessTable();
		}
		String businessIds = paymentOrderDetail.getBusinessIds();
		if (DOG_BIRTH_CERTIFICATE.equals(tableName)) {
			// 出生纸付款后业务
			dogBirthCertificateService.afterPay(businessIds);
		}
		// 第二繁殖人
		if (DOG_BIRTH_CERTIFICATE.equals(tableName) || DOG_CHIP.equals(tableName)) {
			dogSecondBreederService.updatePaymentStates(businessIds, paymentOrderDetail.getOrderCode());
		}
		// 配种证明付款后业务
		if ("dog_newborn".equals(tableName)) {
			dogNewbornService.afterPay(businessIds);
		}
		// 结业证书
		if ("groomer_diploma@F".equals(shortName)) {
			groomerCourseApplicationService.afterPay(businessIds);
		}
		// 激活交费后业务
		if ("dog_activation".equals(tableName)) {
			dogActivationService.afterPay(businessIds);
		}
		if ("new_pet_passport.companion_dog_appraisal".equals(tableName)) {
			CompanionDogAppraisalService companionDogAppraisalService = (CompanionDogAppraisalService) SpringContextHolder
					.getBean("companionDogAppraisalService");
			companionDogAppraisalService.afterPay(businessIds);
		}
		// //犬舍初次注册付款后业务
		// if("kennel@ZC".equals(shortName)){
		// kennelService.kennelZCAfterPay(businessIds);
		// }
		// //犬舍续费付款后业务(核算)
		// if("kennel@ND".equals(shortName)){
		// kennelService.kennelXFAfterPay(businessIds);
		// }
		// //犬舍永久付款后业务(核算)
		// if("kennel@YJ".equals(shortName)){
		// kennelService.kennelXFAfterPay(businessIds);
		// }
		// 合作机构证书换发芯片业务
		if ("dog_chip_change".equals(paymentOrderDetail.getBusinessTable())) {
			dogPedigreeCertifiedChangeService.afterPay(businessIds);
		}
		// 合作机构证书换发dna存档 生成狗信息及回写要点
		if ("dog_dna_archive".equals(tableName)) {
			dogDnaArchiveService.afterPay(businessIds);
		}
		if ("1".equals(isall) && "dog_chip".equals(paymentOrderDetail.getBusinessTable())) {// 整窝生成支付后业务处理
			paymentRecordDao.changePaymentState(
					"update dog_birth_certificate set review_state = '1',review_time = now(),running_number='"
							+ paymentOrderDetail.getOrderCode()
							+ "'WHERE running_number is null and fmdog_breed_certified_code = '"
							+ paymentOrderDetail.getBusinessIds() + "'");
			paymentRecordDao
					.changePaymentState("update dog_chip set review_state = '1',review_time = now(),running_number='"
							+ paymentOrderDetail.getOrderCode()
							+ "'WHERE running_number is null and fmdog_breed_certified_code = '"
							+ paymentOrderDetail.getBusinessIds() + "'");
			paymentRecordDao.changePaymentState(
					"update dog_blood_save set payment_state = '2',typeYes = '2',payment_time = now(),running_number='"
							+ paymentOrderDetail.getOrderCode()
							+ "'WHERE running_number is null and fmdog_breed_certified_code = '"
							+ paymentOrderDetail.getBusinessIds() + "'");
			DogBirthCertificate dbc = dogBirthCertificateService
					.getfindByFmdogBreedCertifiedCode(paymentOrderDetail.getBusinessIds());
			DogNewborn dn = dogNewbornService.getBybreedCertifiedCode(paymentOrderDetail.getBusinessIds());
			if (dbc != null && dn != null) {
				dn.setPuppyBirthNum(dbc.getSameBatchNum());
				dn.setPuppyRegisterNum(dbc.getSameBatchNum());
				dn.setBirthday(dbc.getDogBirthday());
				dn.setDogRegisterNum(
						dbc.getSameBatchNum().substring(0, 1) + "," + dbc.getSameBatchNum().substring(2, 3));
				dogNewbornService.save(dn);
			}
		}
		// if ("dog_chip".equals(paymentOrderDetail.getBusinessTable())
		// && "245".equals(paymentOrderDetail.getChargingItemId())) {
		// User user = paymentOrderDetail.getCreateBy();
		// Org org = orgDao.getOrgByUserId(user.getId());
		// // 地方俱乐部新生犬订单
		// if (org != null) {
		// dogChipService.afterPay(businessIds);
		// }
		// }
		if ("sys_member@GS".equals(shortName)) {
			User user = paymentOrderDetail.getCreateBy();
			TrainingInstitution trainingInstitution = new TrainingInstitution();
			trainingInstitution.setUser(user);
			List<TrainingInstitution> findGroomerList = trainingInstitutionDao.findGroomerList(trainingInstitution);
			if (findGroomerList.size() == 1) {
				schoolsMemberService.afterPay(businessIds);
			}
		}
		// 等级贴纸付款后业务
		if ("dog_sticker_apply".equals(tableName)) {
			dogStickerApplyService.afterPay(businessIds);
		}
		// 合作机构DNA存档
		if (StringUtils.isNotBlank(shortName) && "dog_blood_save".equals(shortName.split("@")[0])) {
			dogBloodSaveService.afterPay(businessIds);
		}
		// 赛事报名付款后业务
		// 赛事报名时拼接“#”判断是否使用优惠卷,修改bug(之前没有拼接，导致赛事表实收金额出现错误)
		if ("show_apply".equals(tableName)) {
			if (businessIds.indexOf("#") != -1) {
				showApplyService.afterPay(businessIds.split("#")[0]);
			} else {
				showApplyService.afterPay(businessIds);
			}

		}
		// 单犬种俱乐部业务
		// 会员续费后修改所属俱乐部
		if (MEMER_BASIC.equals(shortName) || MEMBER_PROFESSIONAL.equals(shortName)
				|| MEMBER_PROFESSIONAL_BREED.equals(shortName)) {
			String id = paymentOrderDetail.getCreateBy().getId();
			User user = userDao.get(id);
			Org org = orgDao.findByUserId(id);
			Member member = memberDao.get(paymentOrderDetail.getBusinessIds());
			if (org != null && StringUtils.isNotBlank(org.getOrgType()) && org.getOrgType().equals("singleTypeClub")) {
				// update by zjw 2020.05.12 新增只有过期会员续费才改变所属俱乐部
				if (member != null && !user.getName().equals(member.getRegistrant())) {
					boolean updateRegistrantFlag = Boolean.FALSE;
					// 会员无效
					if (oldMemberEndDate == null) {
						updateRegistrantFlag = Boolean.TRUE;
						// 会员已过期
					} else if (oldMemberEndDate.getTime() < DateUtils.parseDate(DateUtils.getDate()).getTime()) {
						updateRegistrantFlag = Boolean.TRUE;
						// 会员所属俱乐部为空
					} else if (StringUtils.isBlank(member.getRegistrant())) {
						updateRegistrantFlag = Boolean.TRUE;
					} else {
						List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.getOrderByRunningNum(
								paymentOrderDetail.getOrderCode(), paymentOrderDetail.getMemberCode());
						for (PaymentOrderDetail detail : orderDetailList) {
							// 会员过期一月以上、增加了初次注册费
							PaymentChargingItem item = paymentChargingItemDao.get(detail.getChargingItemId());
							if (MEMBER_PROFESSIONAL_BREED_FIRST.equals(item.getShortName())
									|| MEMBER_PROFESSIONAL_FIRST.equals(item.getShortName())) {
								updateRegistrantFlag = Boolean.TRUE;
							}
						}
					}
					if (updateRegistrantFlag) {
						memberDao.updateRegistrant(member.getMemberCode(), user.getLoginName(), user.getName());
					}
				}
			}

		}
		// 赛事鉴定缴费后修改视频鉴定
		if ("dog_appraisal".equals(tableName)) {
			dogAppraisalService.afterPay(businessIds);
		}
		// 鉴赏课发送报名成功文案
		if (APPRECIATION_APPLY.equals(tableName)) {
			appreciationApplyService.sendAppreciationApplySMS(businessIds);
		}
		// 补寄采样包 需要1、修改原采样包状态为失败，2、更新DNA存档表新采样包编号，3、生成采样包邮寄记录
		if (DOG_DNA_ARCHIVE_REISSUE_SAMPLING.equals(tableName)) {
			dogDnaArchiveService.afterPayReissueSampling(businessIds, paymentOrderDetail.getChargingItemId());
		}
	}

	public RESTResponse cartToOrder(String[] cardIds) {
		Member member = UserUtils.getLoginMember();
		PaymentOrder paymentOrder = new PaymentOrder();
		paymentOrder.setReceiveProvince(member.getProvince());
		paymentOrder.setReceiveCity(member.getCity());
		paymentOrder.setReceiveAddress(member.getStreet());
		paymentOrder.setReceivePostCode(member.getPostcode());
		paymentOrder.setReceiveDel(member.getMobile());
		paymentOrder.setReceiver(member.getName());
		paymentOrder.setMemberCode(member.getMemberCode());
		paymentOrder.setMemberName(member.getName());
		// 购物车到订单
		String id = cartToOrder(cardIds, paymentOrder, null);
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		return new RESTResponse("data", jo);
	}

	/**
	 * @Description: 验证是否已过赛事报名截止时间
	 * @author: zhangxiang
	 * @date: 2019/10/16 11:42
	 */
	public void checkShowApplyClosing(PaymentOrder order) {
		// 判断是否为赛事订单，支付前判断是否赛事过期，过期则不可支付
		List<PaymentOrderDetail> lists = paymentOrderDetailDao.getOrderByRunningNum(order.getOrderCode(),
				order.getMemberCode());
		for (PaymentOrderDetail l : lists) {
			if (StringUtils.isNotBlank(l.getBusinessTable()) && StringUtils.isNotBlank(l.getBusinessIds())
					&& l.getBusinessTable().equals("show_apply")) {
				// 赛事表可能带有证书号，进行分割
				String id = l.getBusinessIds().split("#")[0];
				ShowApply showApply = showApplyService.get(id);
				if (showApply == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单支付失败,未找到报名赛事信息");
				}
				MainShows mainShows = mainShowsDao.get(showApply.getMainShowId());
				if (mainShows == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单支付失败,未找到报名赛事信息");
				}
				if (!"0".equals(order.getSource()) && (new Date().getTime() > mainShows.getClosingTime().getTime())) {
					//后台生成的报名订单不需要校验报名结束时间
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单支付失败,已过赛事报名截止时间");
				}
			}
		}
	}

	/**
	 * 购物车id+使用优惠券的下单方式
	 * 
	 * @param cardIds
	 * @return
	 */
	public RESTResponse cartsAndcouponIdToOrder(String[] cardIds, String couponId) {
		Member member = UserUtils.getLoginMember();
		PaymentOrder paymentOrder = new PaymentOrder();
		paymentOrder.setReceiveProvince(member.getProvince());
		paymentOrder.setReceiveCity(member.getCity());
		paymentOrder.setReceiveAddress(member.getStreet());
		paymentOrder.setReceivePostCode(member.getPostcode());
		paymentOrder.setReceiveDel(member.getMobile());
		paymentOrder.setReceiver(member.getName());
		paymentOrder.setMemberCode(member.getMemberCode());
		paymentOrder.setMemberName(member.getName());
		// 购物车到订单
		String id = cartToOrder(cardIds, paymentOrder, couponId);
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		return new RESTResponse("data", jo);
	}

	/**
	 * 封装fci证书信息
	 * @param groomerQualificationCertificate
	 * @return
	 */
	private FciGroomerQualificationCertificate generateFciCertificate(GroomerQualificationCertificate groomerQualificationCertificate){
		FciGroomerQualificationCertificate fciGroomerQualificationCertificate = new FciGroomerQualificationCertificate();
		fciGroomerQualificationCertificate.setMemberCode(groomerQualificationCertificate.getMemberCode());
		fciGroomerQualificationCertificate.setRegisterId(groomerQualificationCertificate.getRegisterId());
		fciGroomerQualificationCertificate.setTakeCertificateDate(null);
		fciGroomerQualificationCertificate.setIssueDate(null);
		fciGroomerQualificationCertificate.setPrintState(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setRunningNumber(null);
		fciGroomerQualificationCertificate.setPaymentState(Constants.STRING_NUM_ONE);
		fciGroomerQualificationCertificate.setPaymentTime(null);
		fciGroomerQualificationCertificate.setIsFree(Constants.STRING_NUM_ONE);
		fciGroomerQualificationCertificate.setCertificateState(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setPaper(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setFciCertificateCode("");
		fciGroomerQualificationCertificate.setCertificateId(groomerQualificationCertificate.getId());
		fciGroomerQualificationCertificate.setRemarks("");
		fciGroomerQualificationCertificate.setDelFlag(Constants.STRING_ZERO);
		fciGroomerQualificationCertificate.setCertificateType("5");
		return fciGroomerQualificationCertificate;
	}

}
