package com.cku.restful.v1.finance.service;

import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.dao.DogSemenDao;
import com.cku.oa.dog.entity.DogNewborn;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

@Service
@Transactional(readOnly = true)
public class DogNewbornDeleteService {

    @Autowired
    private DogNewbornDao dogNewbornDao;
    @Autowired
    private DogSemenDao dogSemenDao;

    //清除精子信息中的配种证明号
    public void clearDogSemen(String id) {
        DogNewborn dogNewborn = dogNewbornDao.get(id);
        if (dogNewborn!=null&&StringUtils.isNotBlank(dogNewborn.getSemenCode())) {
            Map map = new HashMap<String, Object>();
            map.put("semenCode", dogNewborn.getSemenCode().split(","));
            map.put("breedCertifiedCode", dogNewborn.getBreedCertifiedCode());
            dogSemenDao.clearBreedCertifiedCode(map);
        }
    }
}