package com.cku.restful.v1.dogNoseprin.service;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.restful.v1.dogNoseprin.dao.DogNoseRaffleDao;
import com.cku.restful.v1.dogNoseprin.entity.DogNoseRaffle;
import com.cku.restful.v1.dogNoseprin.entity.DogNoseRaffleRecord;
import com.cku.restful.v1.dogNoseprin.entity.DogPrizePool;
import com.cku.restful.v1.dogNoseprin.vo.DogPrizePoolVO;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.dao.UserDao;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 鼻纹抽奖机会Service
 * 
 * @author xx
 * @version 2020-04-29
 */
@Service
@Transactional(readOnly = true)
public class DogNoseRaffleService extends CrudService<DogNoseRaffleDao, DogNoseRaffle> {

	@Autowired
	private DogPrizePoolService dogPrizePoolService;

	@Autowired
	private DogNoseRaffleRecordService dogNoseRaffleRecordService;

	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private UserDao userDao;

	public DogNoseRaffle get(String id) {
		return super.get(id);
	}

	public List<DogNoseRaffle> findList(DogNoseRaffle dogNoseRaffle) {
		return super.findList(dogNoseRaffle);
	}

	public Page<DogNoseRaffle> findPage(Page<DogNoseRaffle> page, DogNoseRaffle dogNoseRaffle) {
		return super.findPage(page, dogNoseRaffle);
	}

	@Transactional(readOnly = false)
	public void save(DogNoseRaffle dogNoseRaffle) {
		super.save(dogNoseRaffle);
	}

	@Transactional(readOnly = false)
	public void delete(DogNoseRaffle dogNoseRaffle) {
		super.delete(dogNoseRaffle);
	}

	@Transactional(readOnly = false)
	public RESTResponse share() {
		Member m = UserUtils.getLoginMember();
		DogNoseRaffle r = dao.getByMemberCode(m.getMemberCode());
		if (r == null) {
			DogNoseRaffle raffle = new DogNoseRaffle();
			raffle.setMemberCode(m.getMemberCode());
			raffle.setTotalNum(1);
			raffle.setUsedNum(0);
			raffle.setIsShare("1");
			raffle.preInsert();
			dao.insert(raffle);
		} else if (!"1".equals(r.getIsShare())) {
			dao.shareAddNum(m.getMemberCode());
		}
		return new RESTResponse();
	}

	/**
	 * @Description: 俱乐部需要传会员号进行验证，会员则获取当前登陆人
	 * @author: zhangxiang
	 * @date: 2020/7/23 16:02
	 */
	@Transactional(readOnly = false)
	public RESTResponse addDogNoseprin(Member member) {
		Member m = null;
		if (member != null && member.getId() != null) {
			m = member;
		} else {
			m = UserUtils.getLoginMember();
		}

		DogNoseRaffle r = dao.getByMemberCode(m.getMemberCode());
		if (r == null) {
			DogNoseRaffle raffle = new DogNoseRaffle();
			raffle.setMemberCode(m.getMemberCode());
			raffle.setTotalNum(1);
			raffle.setUsedNum(0);
			if (member != null && member.getId() != null) {
				PartnerLoginUserInfo loginPartner = UserUtils.getLoginPartner();
				User user = userDao.get(loginPartner.getUserId());
				raffle.setId(IdGen.uuid());
				raffle.setCreateBy(user);
				raffle.setUpdateBy(user);
				raffle.setCreateDate(new Date());
				raffle.setUpdateDate(new Date());
			} else {
				raffle.preInsert();
			}

			dao.insert(raffle);
		} else {
			dao.addDogNoseprinAddNum(m.getMemberCode());
		}
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public DogNoseRaffle getOneByMemberCode(String memberCode) {

		return dao.getByMemberCode(memberCode);
	}

	public static final String DOG_NOSE_RAFFLE = "dog_nose_raffle";

	private DogPrizePoolVO buildDogPrizePoolVO(DogPrizePool dogPrizePool) {
		Random rand = new Random();
		DogPrizePoolVO result = new DogPrizePoolVO();
		String[] prizeCodes = dogPrizePool.getPrizeCode().split(",");
		int randNum = rand.nextInt(prizeCodes.length);
		result.setFacePrice(dogPrizePool.getFacePrice());
		result.setPrizeCode(Integer.valueOf(prizeCodes[randNum]));
		result.setPrizeName(dogPrizePool.getPrizeName());
		return result;
	}

	@Transactional(readOnly = false)
	public RESTResponse participate(Member member) {
		DogNoseRaffle raffle = getOneByMemberCode(member.getMemberCode());
		if (raffle.getTotalNum() - raffle.getUsedNum() == 0)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "没有抽奖次数啦~~");
		// 1、查看目前的剩余奖池
		List<DogPrizePool> list = dogPrizePoolService.findListByPoolCode(DOG_NOSE_RAFFLE);
		// 2、剩余奖池为0，返回谢谢参与 剩余奖池不空，抽取随机数
		if (list.size() == 0) {
			DogPrizePool dogPrizePool = dogPrizePoolService.getByPrizeName(DOG_NOSE_RAFFLE, "谢谢参与");
			// 2.1本人抽奖机会减一
			int m = dao.deduct(member.getMemberCode());
			if (m == 0)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "抽奖机会用完啦");
			return new RESTResponse("data", buildDogPrizePoolVO(dogPrizePool));
		}
		int range = list.stream().mapToInt(a -> a.getTotalNum() - a.getNum()).sum();// 奖池剩余机会 1w以内的数字，越来越少
		Random rand = new Random();
		int randNum = rand.nextInt(range);// 抽到的数字，找到这个数字落在哪个奖品区间就可以了
		DogPrizePool prize = null;// 抽到的奖品
		int temp = 0;
		for (int i = 0; i < list.size(); i++) {
			int yx = list.get(i).getTotalNum() - list.get(i).getNum();
			if (temp <= randNum && randNum < temp + yx) {
				prize = list.get(i);
				break;
			} else {
				temp += yx;
			}
		}
		if (prize == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "系统失败！");
		// 3、发放优惠券；记录本人得到的奖品；
		if (!"谢谢参与".equals(prize.getPrizeName())) {
			Calendar now = Calendar.getInstance();
			Date effDate = now.getTime();
			now.add(Calendar.MONTH, 6);
			Date validDate = now.getTime();
			SysCoupon coupon = sysCouponService.saveCoupon(member.getMemberCode(), prize.getPrizeName(),
					prize.getFacePrice().toString(), validDate, effDate, "memberdog", "", "限办理CKU会员业务、繁殖业务使用", 1, "1",
					null);
			DogNoseRaffleRecord dogNoseRaffleRecord = new DogNoseRaffleRecord();
			dogNoseRaffleRecord.setMemberCode(member.getMemberCode());
			dogNoseRaffleRecord.setMemberName(member.getName());
			dogNoseRaffleRecord.setCouponId(coupon.getId());
			dogNoseRaffleRecord.setCouponName(prize.getPrizeName());
			dogNoseRaffleRecordService.save(dogNoseRaffleRecord);
		}
		// 4、该奖品库存减一 ；本人抽奖机会减一
		int n = dogPrizePoolService.deduct(prize.getId(), prize.getNum());
		if (n == 0)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "活动太热，请再试一次！");
		int m = dao.deduct(member.getMemberCode());
		if (m == 0)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "抽奖机会用完啦");
		// 5、给前端找出随机显示的位置
		return new RESTResponse("data", buildDogPrizePoolVO(prize));
	}

}