package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogTibetanMastiffService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 藏獒犬只鉴定Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-24
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogTibetanMastiffController extends BaseRestController {

	@Autowired
	private RestDogTibetanMastiffService restDogTibetanMastiffService;

	@RequestMapping(value = "/dogtibetanmastiff", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogTibetanMastiffService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogtibetanmastiff/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void delete(@PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		RESTResponse result = restDogTibetanMastiffService.delete(id);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dogtibetanmastiff", method = RequestMethod.POST)
	@ResponseBody
	public void post(@RequestBody String json, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogTibetanMastiffService.post(json);
		ServletUtils.writeResponse(response, result);
	}
}