/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import com.cku.core.QueryByIdRequest;
import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.dog.vo.response.DogGeneReportResponse;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.io.IOException;

/**
 * 犬只信息管理Controller
 * 
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Controller
@RequestMapping(value = "/api/v1/dog")
public class RestDogController extends BaseRestController {

	@Autowired
	private RestDogService restDogService;

	@ApiOperation(value = "出口证书-查询犬只信息", tags = { "出口证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "pedigreeCertified", value = "血统证书号") })
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" + "    \"rc\":0,\n" + "    \"msg\":\"OK\",\n"
			+ "    \"list\":[\n" + "        {\n" + "        \n" + "            \"birthdate\":\"2018-05-25\", // 出生日期\n"
			+ "            \"dogBreedName\":\"金毛寻回猎犬\", // 犬种\n"
			+ "            \"id\":\"b9ca85c141124988a888a95108406bf9\",\n" + "            \"memberCode\":\"2268\",\n"
			+ "            \"breederMemberCode\":\"2268\",\n" + "            \"nameEn\":\"hedhh Xamie\", // 犬名\n"
			+ "            \"identificationFlag\":\"100000202005253\", \n" + "            \"gender\":\"1\",\n"
			+ "            \"breeder\":\"刘载春\",\n" + "            \"dogOwner\":\"刘载春\", // 犬主\n"
			+ "            \"pedigreeCertifiedCode\":\"CKU-111463176/20\", // 血统证书号\n"
			+ "            \"createDate\":\"2020-05-25\",\n" + "            \"colorFlag\":\"BUFF-乳黄色\", // 颜色\n"
			+ "  \n" + "        }\n" + "    ],\n" + "    \"total\":1\n" + "}\n" + "") })
	@RequestMapping(value = "/dog", method = RequestMethod.GET)
	@ResponseBody
	public void getMyDog(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getMyDog(request);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/dog/getOneByPedigreeCertified", method = RequestMethod.GET)
	@ResponseBody
	public void getOneByPedigreeCertified(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getOneByPedigreeCertified(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 获取犬只信息(牵犬师大赛查询)
	 * 
	 * @Author chaixueteng
	 * @2017年8月29日下午4:37:47
	 */
	@RequestMapping(value = "/dog/getByPedigreeCertified", method = RequestMethod.GET)
	@ResponseBody
	public void getByPedigreeCertified(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getByPedigreeCertified(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 获取犬只信息(查询)
	 * 
	 * @Author zhangxiang
	 * @2019年3月29日下午4:37:47
	 */
	@RequestMapping(value = "/dogByGenderAll", method = RequestMethod.GET)
	@ResponseBody
	public void dogByGenderAll(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogService.getMyDogBYGenderAll(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "纯血全基因检测报告")
	@GetMapping(value = "/geneReport")
	@ResponseBody
	public ResultDto<DogGeneReportResponse> findGeneReportById(@Valid QueryByIdRequest request) {
		BeanValidators.validateWithException(validator, request);
		DogGeneReportResponse resp = restDogService.findGeneReportById(request.getId());
		return ResultDto.success(resp);
	}
}