
package com.cku.restful.v1.dog.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogBirthCertificateService;
import com.cku.restful.v1.dog.service.RestDogMCService;
import com.cku.restful.v1.dog.service.RestDogService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Controller
@RequestMapping(value = "/ckumc/dog")
public class CkumcDogBirthCertificateController extends BaseRestController {

	@Autowired
	private RestDogBirthCertificateService birthCertificateService;

	@Autowired
	private RestDogService restDogService;
	@Autowired
	private RestDogMCService dogMCService;

	/**
	 * 对接www.ckumc.org.cn系统的信息查询接口
	 */
	@RequestMapping(value = "/birthcertificate", method = RequestMethod.GET)
	@ResponseBody
	public void getBySnCodeOrIdentificationFlagOld(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		request.setAttribute("source", "ckumc");
		ServletUtils.writeResponse(response, birthCertificateService.getBySnCodeOrIdentificationFlagOld(request));
	}

	@RequestMapping(value = "/bloodline", method = RequestMethod.GET)
	@ResponseBody
	public void bloodline(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = restDogService.bloodline(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据芯片号或证书号，查询犬只父母的近亲繁殖信息
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getParentDogBloodlineByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getParentDogBloodlineByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = restDogService.getParentDogBloodlineByKey(request);
		ServletUtils.writeResponse(response, result);
	}
	
	@RequestMapping(value = "/getDogByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getDogByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = restDogService.getByKey(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 后代犬查询
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getChildrenByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getChildrenByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = dogMCService.getChildrenByKey(request);
		ServletUtils.writeResponse(response, result);
	}
	/**
	 * 同台犬查询
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/getSameBatchDogByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getSameBatchDogByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = dogMCService.getSameBatchDogByKey(request);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/getCoupleDogByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getCoupleDogByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = dogMCService.getCoupleDogByKey(request);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/getSameFatherDogByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getSameFatherDogByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = dogMCService.getSameFatherDogByKey(request);
		ServletUtils.writeResponse(response, result);
	}
	@RequestMapping(value = "/getSameMotherDogByKey", method = RequestMethod.GET)
	@ResponseBody
	public void getSameMotherDogByKey(HttpServletRequest request, HttpServletResponse response) throws IOException {
		request.setAttribute("source", "ckumc");
		RESTResponse result = dogMCService.getSameMotherDogByKey(request);
		ServletUtils.writeResponse(response, result);
	}

}