/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.GroomerCourseApplicationDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.cku.oa.groomer.service.CurriculumService;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.cku.oa.groomer.service.RotationChartService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.entity.TeacherLecturer;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.cku.restful.v1.dog.service.RestPersonnelService;
import com.cku.restful.v1.dog.vo.*;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.schools.mrschool.service.SchoolsTeacherService;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.swagger.annotations.*;
import net.sf.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zhuoHeng
 * @version 2016-08-03
 */
@Api(tags = "人才板块-张向")
@Controller
@RequestMapping(value = "/api/v1/person")
public class AppPersonController extends BaseRestController {

	@Autowired
	private RestPersonnelService restPersonnelService;

	@Autowired
	private RotationChartService rotationChartService;

	@Autowired
	private CurriculumService curriculumService;

	@Autowired
	private TrainingInstitutionService trainingInstitutionService;

	@Autowired
	private GroomerCourseService groomerCourseService;

	@Autowired
	private MemberService memberService;

	@Autowired
	private SchoolsTeacherService schoolsTeacherService;
	@Autowired
	private GroomerCourseApplicationDao groomerCourseApplicationDao;
	
	/**
	 * 美容师列表
	 * 牵犬师列表
	 */

	@ApiOperation(value = "美容师/牵犬师/训犬师列表")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo",paramType = "query", value = "分页"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页"),
			@ApiImplicitParam(name = "type", paramType = "query", value = "类型1牵犬师板块/2美容师板块/3训犬师"),
			@ApiImplicitParam(name = "city", paramType = "query", value = "城市"),
			@ApiImplicitParam(name = "level", paramType = "query", value = "级别")})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
			"  \"rc\": 0,\n" +
			"  \"msg\": \"OK\",\n" +
			"  \"list\": [\n" +
			"    {\n" +
			"      \"memberCode\": \"227432\",\n" +
			"      \"province\": \"河北省\",\n" +
			"      \"city\": \"廊坊市\",\n" +
			"      \"level\": [\n" +
			"        \"C\"\n" +
			"      ],\n" +
			"      \"mobile\": \"15636161161\",\n" +
			"      \"name\": \"胡毅\",\n" +
			"      \"avatar\": \"/oa-web/oaManage/sys/file/image/b82c86c186d54fe9b810861958148fc1\"\n" +
			"    }\n" +
			"  ],\n" +
			"  \"total\": 1\n" +
			"}") })
	@RequestMapping(value = "", method = RequestMethod.GET)
	@ResponseBody
	public void getByKey(HttpServletRequest request,
						 HttpServletResponse response) throws IOException {
		restPersonnelService.findByMember(request, response);
	}

	/**
	 * 轮播图
	 *
	 */
	@ApiOperation(value = "轮播图")
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
			"  \"rc\": 0,\n" +
			"  \"msg\": \"OK\",\n" +
			"  \"list\": [\n" +
			"    {\n" +
			"      \"rotationHref\": \"\",\n" +
			"      \"rotationExplain\": \"轮播图\",\n" +
			"      \"rotationPicture\": \"eadd69efe4dd468aadcdee5ac598e9cd\",\n" +
			"      \"rotationIndex\": \"12\",\n" +
			"      \"rotationName\": \"轮播图名称test\",\n" +
			"      \"rotationType\": \"1\",\n" +
			"      \"rotationCurriculum\": \"http://www.baidu.com\"\n" +
			"    }\n" +
			"  ]\n" +
			"}") })
	@RequestMapping(value = "rotationChartList", method = RequestMethod.GET)
	@ResponseBody
	public void rotationChartList( HttpServletResponse response,HttpServletRequest request) throws IOException {
		List<RotationChartVO> listByApp = rotationChartService.findListByApp(request);
		JSONObject dat = new JSONObject();
		dat.put("list",listByApp);
		ServletUtils.writeResponse(response, new RESTResponse(dat));
	}
	/**
	 * 热门推荐
	 *
	 */
	@ApiOperation(value = "热门推荐")
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
			"  \"rc\": 0,\n" +
			"  \"msg\": \"OK\",\n" +
			"  \"list\": [\n" +
			"    {\n" +
			"      \"curriculumIndex\": \"333\",\n" +
			"      \"curriculumName\": \"课程名称2\",\n" +
			"      \"curriculumHref\": \"www.baidu.com\",\n" +
			"      \"curriculumPicture\": \"0abf94688acc445089ee814d1ebbfe6f\",\n" +
			"      \"recommend\": \"\",\n" +
			"      \"curriculumJump\": \"跳转课程test32\",\n" +
			"      \"curriculumType\": \"1\"\n" +
			"    }\n" +
			"  ]\n" +
			"}") })
	@RequestMapping(value = "curriculumList", method = RequestMethod.GET)
	@ResponseBody
	public void curriculumList( HttpServletRequest request, HttpServletResponse response) throws IOException{
		List<CurriculumVO> listByApp = curriculumService.findListByApp( request, response);
		JSONObject dat = new JSONObject();
		dat.put("list",listByApp);
		ServletUtils.writeResponse(response, new RESTResponse(dat));
	}
	/**
	 * 合作学校卡片
	 *
	 */
	@ApiOperation(value = "牵犬/训犬/美容合作学校卡片")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo",paramType = "query", value = "分页"),
			@ApiImplicitParam(name = "type",paramType = "query", value = "类型1牵犬师2训犬师3美容师板块/"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
			"  \"rc\": 0,\n" +
			"  \"msg\": \"OK\",\n" +
			"  \"list\": [\n" +
			"    {\n" +
			"      \"memberCode\": \"100472\",\n" +
			"      \"address\": \"江苏省扬州市邗江区念四二村西侧118号\",\n" +
			"      \"city\": \"扬州市\",\n" +
			"      \"endDate\": \"\",\n" +
			"      \"level\": \"\",\n" +
			"      \"student\": 0,\n" +
			"      \"introduce\": \"\",\n" +
			"      \"schoolType\": \"7\",\n" +
			"      \"telephone\": \"13813184084\",\n" +
			"      \"avatar\": \"\",\n" +
			"      \"schoolNameCn\": \"扬州淘喜宝宠物美容培训学校\",\n" +
			"      \"schoolUserId\": \"8042f20d2bf14f8789655c3aa7b8e368\",\n" +
			"      \"schoolNameEn\": \"TAO XI BAO PET GROOMING SCHOOL\",\n" +
			"      \"qualifications\": \"\",\n" +
			"      \"schoolWeb\": \"\",\n" +
			"      \"province\": \"江苏省\",\n" +
			"      \"street\": \"邗江区念四二村西侧118号\",\n" +
			"      \"schoolShortName\": \"YZTXB\",\n" +
			"      \"responsibler\": \"任晨\",\n" +
			"      \"schoolMemberCode\": \"MRHZ000090\",\n" +
			"      \"startDate\": \"2020-09-16 00:00:00\"\n" +
			"    }\n" +
			"  ],\n" +
			"  \"total\": 1\n" +
			"}") })
	@RequestMapping(value = "trainingInstitutionList", method = RequestMethod.GET)
	@ResponseBody
	public void trainingInstitutionList( HttpServletRequest request, HttpServletResponse response) throws IOException{
		trainingInstitutionService.findGroomerSchoolPageAPP(new Page<TrainingInstitution>(request, response),request,response);
	}
	/**
	* 免费公开课
	*
	*/
	@ApiOperation(value = "免费公开课")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo",paramType = "query", value = "分页"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
			"  \"rc\": 0,\n" +
			"  \"msg\": \"OK\",\n" +
			"  \"list\": [\n" +
			"    {\n" +
			"      \"diplomaLevel\": \"A\",\n" +
			"      \"code\": \"0000001\",\n" +
			"      \"registrationEndTime\": \"\",\n" +
			"      \"endDate\": \"\",\n" +
			"      \"endCreateDate\": \"\",\n" +
			"      \"introduce\": \",,\",\n" +
			"      \"video\": \"1\",\n" +
			"      \"beginCreateDate\": \"\",\n" +
			"      \"type\": \"2\",\n" +
			"      \"states\": \"2\",\n" +
			"      \"cover\": \"c8fd0fe2ef3d4b22b83ab3684e9a79b5\",\n" +
			"      \"reviewRemarks\": \"\",\n" +
			"      \"courseName\": \"胜多负少\",\n" +
			"      \"pic1\": \"\",\n" +
			"      \"registrationStarteTime\": \"\",\n" +
			"      \"teacher\": \"1\",\n" +
			"      \"courseDetails\": \"<p>12<br></p>\",\n" +
			"      \"havaDiploma\": \"\",\n" +
			"      \"price\": \"0.00\",\n" +
			"      \"schoolId\": \"dadce6d96312403597fe70366909b297\",\n" +
			"      \"pic2\": \"\",\n" +
			"      \"pic3\": \"\",\n" +
			"      \"startDate\": \"\"\n" +
			"    }\n" +
			"  ],\n" +
			"  \"total\": 1\n" +
			"}") })
	@RequestMapping(value = "groomerCourseOnlineList", method = RequestMethod.GET)
	@ResponseBody
	public void groomerCourseOnlineList( HttpServletRequest request, HttpServletResponse response) throws IOException{
		GroomerCourse groomerCourse = new GroomerCourse();
		groomerCourse.setType("2");
		groomerCourse.setStates("3");
		Page<GroomerCourse> page = groomerCourseService.findPageByApp(new Page<GroomerCourse>(request, response), groomerCourse);
		List<GroomerCourseVO> lists = new ArrayList<>();
		List<GroomerCourse> list = page.getList();
		list.forEach(e->{
			GroomerCourseVO groomerCourseVO = new GroomerCourseVO();
			BeanUtils.copyProperties(e, groomerCourseVO);
			if(StringUtils.isNotBlank(groomerCourseVO.getCover())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/"+groomerCourseVO.getCover();
				groomerCourseVO.setCover(imgPath);
			}

			lists.add(groomerCourseVO);
		});
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<GroomerCourseVO>(lists, page.getCount())));

	}

	/**
	* 线下培训课
	*
	*/
	@ApiOperation(value = "精品课程：即线下培训课")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo", paramType = "query",value = "分页"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
			"  \"rc\": 0,\n" +
			"  \"msg\": \"OK\",\n" +
			"  \"list\": [\n" +
			"    {\n" +
			"      \"diplomaLevel\": \"A\",\n" +
			"      \"code\": \"0000001\",\n" +
			"      \"registrationEndTime\": \"\",\n" +
			"      \"endDate\": \"\",\n" +
			"      \"endCreateDate\": \"\",\n" +
			"      \"introduce\": \",,\",\n" +
			"      \"video\": \"1\",\n" +
			"      \"beginCreateDate\": \"\",\n" +
			"      \"type\": \"2\",\n" +
			"      \"states\": \"2\",\n" +
			"      \"cover\": \"c8fd0fe2ef3d4b22b83ab3684e9a79b5\",\n" +
			"      \"reviewRemarks\": \"\",\n" +
			"      \"courseName\": \"胜多负少\",\n" +
			"      \"pic1\": \"\",\n" +
			"      \"registrationStarteTime\": \"\",\n" +
			"      \"teacher\": \"1\",\n" +
			"      \"courseDetails\": \"<p>12<br></p>\",\n" +
			"      \"havaDiploma\": \"\",\n" +
			"      \"price\": \"0.00\",\n" +
			"      \"schoolId\": \"dadce6d96312403597fe70366909b297\",\n" +
			"      \"pic2\": \"\",\n" +
			"      \"pic3\": \"\",\n" +
			"      \"startDate\": \"\"\n" +
			"    }\n" +
			"  ],\n" +
			"  \"total\": 1\n" +
			"}") })
	@RequestMapping(value = "groomerCourseOfflineList", method = RequestMethod.GET)
	@ResponseBody
	public void groomerCourseOfflineList( HttpServletRequest request, HttpServletResponse response) throws IOException{
		GroomerCourse groomerCourse = new GroomerCourse();
		groomerCourse.setType("1");
		groomerCourse.setStates("3");
		List<GroomerCourseVO> lists = new ArrayList<>();
		Page<GroomerCourse> groomerCoursePage = restPersonnelService.groomerCourseOfflineList(groomerCourse, request, response);
		groomerCoursePage.getList().forEach(e->{
			GroomerCourseVO groomerCourseVO = new GroomerCourseVO();
			BeanUtils.copyProperties(e, groomerCourseVO);
			if(StringUtils.isNotBlank(groomerCourseVO.getCover())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/"+groomerCourseVO.getCover();
				groomerCourseVO.setCover(imgPath);
			}

			lists.add(groomerCourseVO);
		});
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<GroomerCourseVO>(lists, groomerCoursePage.getCount())));

	}
	//线下课程详情
	@ApiOperation(value = "线下课程详情")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",paramType = "query", value = "id")})
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "groomerCourseOfflineDetail", method = RequestMethod.GET)
	@ResponseBody
	public void groomerCourseOfflineDetail( HttpServletRequest request, HttpServletResponse response) throws IOException{
		String id = request.getParameter("id");
		GroomerCourse groomerCourse = groomerCourseService.get(id);
		GroomerCourseVO groomerCourseVO = new GroomerCourseVO();

		if(groomerCourse!=null){
			BeanUtils.copyProperties(groomerCourse, groomerCourseVO);
			List<String> list = new ArrayList<>();
			String path = request.getContextPath();
			String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/";

			if(StringUtils.isNotBlank(groomerCourseVO.getIntroduce())){
				String[] split = groomerCourseVO.getIntroduce().split(",");
				for(int i=0;i<split.length;i++){
					if(StringUtils.isNotBlank(split[i])){
						list.add(imgPath+split[i]);
					}
				}
			}
			if(StringUtils.isNotBlank(groomerCourseVO.getCover())){
				groomerCourseVO.setCover(imgPath+groomerCourseVO.getCover());
			}
			//截止时间
			if(groomerCourseVO.getRegistrationEndTime().getTime() >= new Date().getTime()){
				groomerCourseVO.setFlag(true);
			}else{
				groomerCourseVO.setFlag(false);
			}
			groomerCourseVO.setImgList(list);
			try {
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
				StringBuffer sb = new StringBuffer();
				if(null!=groomerCourseVO.getStartDate()){
					String time = sdf.format(groomerCourseVO.getStartDate());
					//groomerCourseVO.setRegistrationStarteTime(sdf.parse(time));
					sb.append(time);
				}
				if(null!=groomerCourseVO.getEndDate()){
					String time = sdf.format(groomerCourseVO.getEndDate());
					//groomerCourseVO.setRegistrationEndTime(sdf.parse(time));
					sb.append("-"+time);
				}
				groomerCourseVO.setTrainingTime(sb.toString());
			}catch (Exception e1){
				throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_PARAMETER,"日期格式化错误");
			}
			//查询已报名的课程
			//记录是否报名
			Member loginMember = UserUtils.getLoginMember();
			GroomerCourseApplication application = groomerCourseApplicationDao.getOneByMemberCodeACourseId(loginMember.getMemberCode(),id);
			if(application != null && "2".equals(application.getPaymentState())){
				groomerCourseVO.setApplication(true);
			}else{
				groomerCourseVO.setApplication(false);
			}
		}
		//学校信息
		TrainingInstitutionVO trainingInstitutionVO = new TrainingInstitutionVO();
		//获取合作机构
		TrainingInstitution ti = trainingInstitutionService.get(groomerCourse.getSchoolId());
		if(ti!=null){
			BeanUtils.copyProperties(ti, trainingInstitutionVO);
			//学校logo
			if(StringUtils.isNotBlank(trainingInstitutionVO.getAvatar())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image//"+trainingInstitutionVO.getAvatar();
				trainingInstitutionVO.setAvatar(imgPath);
			}
		}
		//讲师信息
		TeacherLecturerVO teacherLecturerVO = new TeacherLecturerVO();
		TeacherLecturer teacherLecturer = schoolsTeacherService.get(groomerCourse.getTeacherId());
		if(teacherLecturer!=null){
			BeanUtils.copyProperties(teacherLecturer, teacherLecturerVO);
			if(StringUtils.isNotBlank(teacherLecturerVO.getAvatar())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+teacherLecturerVO.getAvatar();
				teacherLecturerVO.setAvatar(imgPath);
			}
		}

		JSONObject dat = new JSONObject();
		dat.put("groomerCourse",groomerCourseVO);
		dat.put("trainingInstitution",trainingInstitutionVO);
		dat.put("teacherLecturer",teacherLecturerVO);
		ServletUtils.writeResponse(response, new RESTResponse("data",dat));
	}

//	@ApiOperation(value = "为你推荐")
//	@ApiResponses({ @ApiResponse(code = 0, message = "{\n" +
//			"  \"rc\": 0,\n" +
//			"  \"msg\": \"OK\",\n" +
//			"  \"list\": [\n" +
//			"    {\n" +
//			"      \"curriculumIndex\": \"333\",\n" +
//			"      \"curriculumName\": \"课程名称2\",\n" +
//			"      \"curriculumHref\": \"www.baidu.com\",\n" +
//			"      \"curriculumPicture\": \"0abf94688acc445089ee814d1ebbfe6f\",\n" +
//			"      \"recommend\": \"\",\n" +
//			"      \"curriculumJump\": \"跳转课程test32\",\n" +
//			"      \"curriculumType\": \"1\"\n" +
//			"    }\n" +
//			"  ]\n" +
//			"}") })
//	@RequestMapping(value = "recommendList", method = RequestMethod.GET)
//	@ResponseBody
//	public void recommendList( HttpServletRequest request, HttpServletResponse response) throws IOException{
//		List<CurriculumVO> listByApp = curriculumService.findListByApp( request, response);
//		JSONObject dat = new JSONObject();
//		dat.put("list",listByApp);
//		ServletUtils.writeResponse(response, new RESTResponse(dat));
//	}
	/**
	 * 合作学校小站
	 *
	 */

	@ApiOperation(value = "合作学校小站(学校信息)")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",paramType = "query", value = "学校id")})
	@RequestMapping(value = "schoolsList", method = RequestMethod.GET)
	@ResponseBody
	public void groomerCourseOfflineList1(HttpServletRequest request, HttpServletResponse response) throws IOException{
		//学校id
		String id = request.getParameter("id");
		TrainingInstitution ti = trainingInstitutionService.get(id);
		TrainingInstitutionVO trainingInstitutionVO = new TrainingInstitutionVO();
		if(ti!=null){
			BeanUtils.copyProperties(ti, trainingInstitutionVO);
			//学校logo
			if(StringUtils.isNotBlank(trainingInstitutionVO.getAvatar())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image//"+trainingInstitutionVO.getAvatar();
				trainingInstitutionVO.setAvatar(imgPath);
			}

		}
		JSONObject dat = new JSONObject();
		dat.put("trainingInstitutionVO",trainingInstitutionVO);
		ServletUtils.writeResponse(response, new RESTResponse(dat));
	}

	@ApiOperation(value = "合作学校小站(师资阵容)")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo", paramType = "query",value = "分页"),
			@ApiImplicitParam(name = "id", paramType = "query",value = "id"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "teacherList", method = RequestMethod.GET)
	@ResponseBody
	public void teacherList( HttpServletRequest request, HttpServletResponse response) throws IOException{
		//学校id
		String id = request.getParameter("id");
		JSONObject dat = new JSONObject();
		TeacherLecturer teacherLecturer = new TeacherLecturer();
		teacherLecturer.setSchoolId(id);
		Page<TeacherLecturer> page = schoolsTeacherService.findPage(new Page<TeacherLecturer>(request, response), teacherLecturer);
		List<TeacherLecturerVO> resultlist = new ArrayList<>();
		List<TeacherLecturer> list = page.getList();
		list.forEach(e->{
			TeacherLecturerVO teacherLecturerVO = new TeacherLecturerVO();
			BeanUtils.copyProperties(e, teacherLecturerVO);
			if(StringUtils.isNotBlank(teacherLecturerVO.getAvatar())){
				String path = request.getContextPath();
				String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/file/image/"+teacherLecturerVO.getAvatar();
				teacherLecturerVO.setAvatar(imgPath);
			}
			resultlist.add(teacherLecturerVO);
		});
		Long totalCount = (long) resultlist.size();
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<TeacherLecturerVO>(resultlist, page.getCount())));
	}


	@ApiOperation(value = "合作学校小站(培训课程)")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo",paramType = "query", value = "分页"),
			@ApiImplicitParam(name = "id",paramType = "query", value = "学校id"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "schoolscurriculumList", method = RequestMethod.GET)
	@ResponseBody
	public void schoolscurriculumList( HttpServletRequest request, HttpServletResponse response) throws  Exception {
		//学校id
		String id = request.getParameter("id");
		GroomerCourse groomerCourse = new GroomerCourse();
		groomerCourse.setType("1");
		groomerCourse.setStates("3");
		groomerCourse.setSchoolId(id);
		List<GroomerCourseVO> lists = new ArrayList<>();
		Page<GroomerCourse> page = groomerCourseService.findPage(new Page<GroomerCourse>(request, response), groomerCourse);
		List<GroomerCourse> groomerCourses = page.getList();
		groomerCourses.forEach(e->{
			GroomerCourseVO groomerCourseVO = new GroomerCourseVO();
			BeanUtils.copyProperties(e, groomerCourseVO);
			List<String> list = new ArrayList<>();
			String path = request.getContextPath();
			String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/";

			if(StringUtils.isNotBlank(groomerCourseVO.getIntroduce())){
				String[] split = groomerCourseVO.getIntroduce().split(",");
				for(int i=0;i<split.length;i++){
					if(StringUtils.isNotBlank(split[i])){
						list.add(imgPath+split[i]);
					}
				}
			}
			if(StringUtils.isNotBlank(groomerCourseVO.getCover())){
				groomerCourseVO.setCover(imgPath+groomerCourseVO.getCover());
			}
			//记录是否可以报名
			if(groomerCourseVO.getRegistrationEndTime().getTime() >= new Date().getTime()){
				groomerCourseVO.setFlag(true);
			}else{
				groomerCourseVO.setFlag(false);
			}
			groomerCourseVO.setImgList(list);

			try {
				SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
				StringBuffer sb = new StringBuffer();
				if(null!=groomerCourseVO.getStartDate()){
					String time = sdf.format(groomerCourseVO.getStartDate());
					//groomerCourseVO.setRegistrationStarteTime(sdf.parse(time));
					sb.append(time);
				}
				if(null!=groomerCourseVO.getEndDate()){
					String time = sdf.format(groomerCourseVO.getEndDate());
					//groomerCourseVO.setRegistrationEndTime(sdf.parse(time));
					sb.append("-"+time);
				}
				groomerCourseVO.setTrainingTime(sb.toString());
			}catch (Exception e1){
				throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_PARAMETER,"日期格式化错误");
			}

			lists.add(groomerCourseVO);
		});
		Long totalCount = (long) lists.size();
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<GroomerCourseVO>(lists, page.getCount())));
	}


	@ApiOperation(value = "精品课程详情（为你推荐）")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "pageNo",paramType = "query", value = "分页"),
			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
	@ApiResponses({ @ApiResponse(code = 0, message = "") })
	@RequestMapping(value = "recommendcurriculumList", method = RequestMethod.GET)
	@ResponseBody
	public void recommendcurriculumList( HttpServletRequest request, HttpServletResponse response) throws  Exception {
		GroomerCourse groomerCourse = new GroomerCourse();
		groomerCourse.setType("1");
//		groomerCourse.setStates("3");
		String[] array = {"3","6"};
		groomerCourse.setStatesArr(array);
		List<GroomerCourseVO> lists = new ArrayList<>();
		Page<GroomerCourse> page = groomerCourseService.findPage(new Page<GroomerCourse>(request, response), groomerCourse);
		List<GroomerCourse> groomerCourses = page.getList();
		groomerCourses.forEach(e->{
			GroomerCourseVO groomerCourseVO = new GroomerCourseVO();
			BeanUtils.copyProperties(e, groomerCourseVO);
			List<String> list = new ArrayList<>();
			String path = request.getContextPath();
			String imgPath = request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+path+"/api/v1/open/image/";

			if(StringUtils.isNotBlank(groomerCourseVO.getIntroduce())){
				String[] split = groomerCourseVO.getIntroduce().split(",");
				for(int i=0;i<split.length;i++){
					if(StringUtils.isNotBlank(split[i])){
						list.add(imgPath+split[i]);
					}
				}
			}
			if(StringUtils.isNotBlank(groomerCourseVO.getCover())){
				groomerCourseVO.setCover(imgPath+groomerCourseVO.getCover());
			}
			//记录是否可以报名
			if(groomerCourseVO.getRegistrationEndTime().getTime() >= new Date().getTime()){
				groomerCourseVO.setFlag(true);
			}else{
				groomerCourseVO.setFlag(false);
			}
			groomerCourseVO.setImgList(list);

			try {
				SimpleDateFormat sdf = new SimpleDateFormat("MM/dd");
				StringBuffer sb = new StringBuffer();
				if(null!=groomerCourseVO.getStartDate()){
					String time = sdf.format(groomerCourseVO.getStartDate());
					//groomerCourseVO.setRegistrationStarteTime(sdf.parse(time));
					sb.append(time);
				}
				if(null!=groomerCourseVO.getEndDate()){
					String time = sdf.format(groomerCourseVO.getEndDate());
					//groomerCourseVO.setRegistrationEndTime(sdf.parse(time));
					sb.append("-"+time);
				}
				groomerCourseVO.setTrainingTime(sb.toString());
			}catch (Exception e1){
				throw new ZAException(ZAErrorCode.ZA_ERC_INVALID_PARAMETER,"日期格式化错误");
			}

			lists.add(groomerCourseVO);
		});
		Long totalCount = (long) lists.size();
		ServletUtils.writeResponse(response, new RESTResponse("list",
				new PageBeanResult<GroomerCourseVO>(lists, page.getCount())));
	}
//	@ApiOperation(value = "训犬合作机构展示")
//	@ApiImplicitParams({
//			@ApiImplicitParam(name = "pageNo",paramType = "query", value = "分页"),
//			@ApiImplicitParam(name = "pageSize",paramType = "query", value = "分页")})
//	@RequestMapping(value = "/getHandlerOrgList", method = RequestMethod.GET)
//	@ResponseBody
//	public void getHandlerOrgList( HttpServletRequest request, HttpServletResponse response) throws IOException{
//		trainingInstitutionService.getHandlerOrgList(new Page<TrainingInstitution>(request, response),request,response);
//	}
}