package com.cku.restful.v1.dog.service;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.service.StudDogService;
import com.cku.oa.dog.dao.DogActivationDao;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogTypeDao;
import com.cku.oa.dog.entity.DogActivation;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogActivationService;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.entity.ChampionLogin;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.util.IPLimitUtil;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.restful.v1.breeder.model.DogActivationSearchLabelOtherEnum;
import com.cku.restful.v1.dog.model.RestDogActivation;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import okhttp3.*;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
@Transactional(readOnly = true)
public class RestDogActivationService {

    //犬只估价系统地址
    private static final String PETPRICING_URL = "http://petpricing.chongaibao.com/petpricing/api/";

    @Autowired
    private DogActivationDao dogActivationDao;
    @Autowired
    private DogBirthCertificateDao dogBirthCertificateDao;
    @Autowired
    private DogActivationService dogActivationService;
    @Autowired
    private DogTypeDao dogTypeDao;
    @Autowired
    private DogColorMarkDao dogColorMarkDao;
    @Autowired
    private MemberDao memberDao;
    @Autowired
    private ChampionLoginDao championLoginDao;
    @Autowired
    private DogTypeService dogTypeService;
    @Autowired
    private StudDogService studDogService;
    @Autowired
    private PaymentChargingItemService paymentChargingItemService;
    @Autowired
    private PaymentCartService paymentCartService;
    @Autowired
    private PaymentOrderDao paymentOrderDao;

    public RESTResponse getDogInfo(String birthCode) {
        return new RESTResponse("data", getDogInfo(birthCode, true));
    }

    public RESTResponse get(HttpServletRequest request) {
        String birthCode = request.getParameter("birthCode");
        if (StringUtils.isBlank(birthCode)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
        }
        Member member = UserUtils.getLoginMember();
        DogActivation po = dogActivationDao.getByBirthCode(birthCode);
        if (po == null || !member.getMemberCode().equals(po.getMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
        }
        RestDogActivation vo = getDogInfo(po.getBirthCode(), false);
        vo.setPrice(getString(po.getPrice()));
        vo.setCity(po.getCity());
        vo.setFrontPic(ImgUtil.getImgUrl(request, po.getFrontPic()));
        vo.setSidePic(ImgUtil.getImgUrl(request, po.getSidePic()));
        vo.setBackPic(ImgUtil.getImgUrl(request, po.getBackPic()));
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank(po.getLifePic())) {
            for (String lifePic : po.getLifePic().split(",")) {
                sb.append(ImgUtil.getImgUrl(request, lifePic)).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        vo.setLifePic(sb.toString());
        vo.setMobile(po.getMobile());
        vo.setLinkman(po.getLinkman());
        vo.setHealthInfo(po.getHealthInfo());
        vo.setState(po.getState());
        vo.setConsign(po.getConsign());
        vo.setReviewState(po.getReviewState());
        vo.setReviewRemarks(po.getReviewRemarks());
        vo.setFrontPicReviewState(po.getFrontPicReviewState());
        vo.setSidePicReviewState(po.getSidePicReviewState());
        vo.setBackPicReviewState(po.getBackPicReviewState());
        vo.setFrontPicRemark(po.getFrontPicRemark());
        vo.setSidePicRemark(po.getSidePicRemark());
        vo.setBackPicRemark(po.getBackPicRemark());
        return new RESTResponse("data", vo);
    }
    public RESTResponse isHaveOrder(String birthCode) {
        String  orderId = "";
        String  price = "0";
        if (StringUtils.isBlank(birthCode)) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
        }
        DogActivation po = dogActivationDao.getByBirthCode(birthCode);
        if(po != null && StringUtils.isNotBlank(po.getRunningNumber()) && "1".equals(po.getPaymentState())){
            PaymentOrder paymentOrder = paymentOrderDao.getByorderCode(po.getRunningNumber());
            orderId = paymentOrder.getId();
            price = paymentOrder.getTotalPrice();
        }
        JSONObject jo = new JSONObject();
        jo.put("orderId",orderId);
        jo.put("price", price);
        return new RESTResponse("data", jo);
    }

    @Transactional(readOnly = false)
    public RESTResponse post(String json) {
        // 获取参数
        RestDogActivation vo = BeanUtil.toBean(json, RestDogActivation.class);
        // 参数校验
        validateParameter(vo);
        //寄售
        getConsign(vo);
        // 构造持久对象
        DogActivation po = buildPo(vo);
        // 业务校验
        dogActivationService.validateBusiness(po, "POST");
        // 写入业务表
        dogActivationService.save(po);
        if ("1".equals(vo.getType())) {
            //更新出生纸表的激活状态
            DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(po.getBirthCode());
            dogBirthCertificate.setActivitionState(po.getReviewState());
            dogBirthCertificateDao.update(dogBirthCertificate);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dogBirthCertificate.getSendDate());
            calendar.add(Calendar.DATE, DogActivationService.EXPIRE_DAY + 1);
            if (System.currentTimeMillis() > calendar.getTimeInMillis()
                    && dogBirthCertificate.getCreateDate().getTime() >= DogBirthCertificateService.DOG_ACTIVATION_MILLIS) {
                // 写入购物车
                String businessOrderCode = IdGen.uuid();
                PaymentCart dogActivitionPaymentCart = buildDogActivitionPaymentCart(po, businessOrderCode);
                paymentCartService.addToCart(dogActivitionPaymentCart, "1003");
                dogBirthCertificate.setActivitionState("3");
                dogBirthCertificateDao.update(dogBirthCertificate);
                return new RESTResponse("data", dogActivitionPaymentCart.getId());
            }
        }
        return new RESTResponse();
    }
    private PaymentCart buildDogActivitionPaymentCart(DogActivation po, String businessOrderCode) {
        PaymentCart paymentCart = new PaymentCart();
        PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName("dog_activation@all");
        paymentCart.setChargingItemId(paymentChargingItem.getId());
        paymentCart.setChargingItemName(paymentChargingItem.getName());
        paymentCart.setNum("1");
        String price = paymentChargingItem.getPrice();
        paymentCart.setPrice(price);
        double priceDouble = Double.parseDouble(price);
        paymentCart.setTotalPrice(priceDouble+ "");
        paymentCart.setBusinessTable("dog_activation");
        paymentCart.setBusinessIds(po.getId());
        paymentCart.setBusinessOrderCode(businessOrderCode);
        paymentCart.setToken("");
        return paymentCartService.addBusinessManage(paymentCart, "1002");
    }

    public void getConsign(RestDogActivation vo) {
        //寄售校验
        String consign = vo.getConsign();
        if (StringUtils.isNotBlank(consign)) {
            if (!"0".equals(consign) && !"1".equals(consign)) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "是否寄售只能为0或1");
            }
            if ("0".equals(vo.getState()) && "1".equals(consign)) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有推荐的犬只才可寄售");
            }
        } else {
            vo.setConsign("0");
        }
    }

    @Transactional(readOnly = false)
    public RESTResponse put(String json) {
        // 获取参数
        RestDogActivation vo = BeanUtil.toBean(json, RestDogActivation.class);
        // 参数校验
        validateParameter(vo);
        //寄售
        DogActivation po = dogActivationDao.getByBirthCode(vo.getBirthCode());
        if ("2".equals(vo.getType())) {
            if (StringUtils.isNotBlank(vo.getConsign()) && "1".equals(vo.getConsign())) {
                vo.setState("1");
            }
            vo.setType(po.getType());
            setUpper(po, vo);
        } else {
            getConsign(vo);
            set(po, vo);
        }
        // 业务校验
        dogActivationService.validateBusiness(po, "PUT");
        dogActivationService.save(po);
        if ("1".equals(vo.getType())) {
            //更新出生纸表的激活状态
            DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(po.getBirthCode());
            dogBirthCertificate.setActivitionState(po.getReviewState());
            dogBirthCertificateDao.update(dogBirthCertificate);
        }
        return new RESTResponse();
    }

    private void validateParameter(RestDogActivation vo) {
        if (StringUtils.isBlank(vo.getBirthCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
        }
//        if (StringUtils.isBlank(vo.getPrice())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只报价为空");
//        }
//        if (!StringUtils.isNumeric(vo.getPrice())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只报价必须为整数");
//        }
//        if (StringUtils.isBlank(vo.getCity())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只所在地为空");
//        }
        if (StringUtils.isBlank(vo.getFrontPic())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只正面照为空");
        }
        if (StringUtils.isBlank(vo.getSidePic())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只侧面照为空");
        }
        if (StringUtils.isBlank(vo.getBackPic())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只背面照为空");
        }
//        if (StringUtils.isBlank(vo.getMobile())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "联系电话为空");
//        }
//        if (StringUtils.isBlank(vo.getLinkman())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "联系人为空");
//        }
        if (vo.getLifePic() == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少生活照参数");
        }
        if (StringUtils.isBlank(vo.getState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少上架状态参数");
        }
        if (!"0".equals(vo.getState()) && !"1".equals(vo.getState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "上架状态只能为0或1");
        }
//        if (StringUtils.isBlank(vo.getType())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少数据来源参数");
//        }
//        if (!"2".equals(vo.getType()) && !"1".equals(vo.getType())) {
//            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "数据来源只能为激活或上架");
//        }

        if (StringUtils.isBlank(vo.getHealthInfo())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少健康信息参数");
        }
        JSONObject healthInfo = JSONObject.fromObject(vo.getHealthInfo());
        if (!healthInfo.containsKey("immune")) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少免疫信息参数");
        }
        JSONArray immune = healthInfo.getJSONArray("immune");
        if (immune.size() > 7) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "最多填写7项免疫信息");
        }
        if (!healthInfo.containsKey("anthelmintic")) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少驱虫信息参数");
        }
        JSONArray anthelmintic = healthInfo.getJSONArray("anthelmintic");
        if (anthelmintic.size() > 4) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "最多填写4项驱虫信息");
        }
        if ("2".equals(vo.getType()) && StringUtils.isBlank(vo.getPrice())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "传图上架价格不能为空");
        }
    }

    private DogActivation buildPo(RestDogActivation vo) {
        String memberCode = UserUtils.getLoginMember().getMemberCode();
        DogActivation po = new DogActivation();
        DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(vo.getBirthCode());
        if (dogBirthCertificate == null || !memberCode.equals(dogBirthCertificate.getBreederMemberCode())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号有误");
        }
        po.setBirthCode(vo.getBirthCode());
        po.setMemberCode(memberCode);
        if ("2".equals(vo.getType())) {
            vo.setState("1");
            setUpper(po, vo);
        } else {
            set(po, vo);
        }
        return po;
    }

    private void set(DogActivation po, RestDogActivation vo) {
        if (!"1".equals(po.getReviewState())) {
            //不是审核通过，可以修改照片，审核状态为未审核
            po.setReviewState("0");
            if (!"1".equals(po.getFrontPicReviewState())) {
                po.setFrontPic(vo.getFrontPic());
                po.setFrontPicRemark("");
                po.setFrontPicReviewState("0");
            }
            if (!"1".equals(po.getSidePicReviewState())) {
                po.setSidePic(vo.getSidePic());
                po.setSidePicRemark("");
                po.setSidePicReviewState("0");
            }
            if (!"1".equals(po.getBackPicReviewState())) {
                po.setBackPic(vo.getBackPic());
                po.setBackPicRemark("");
                po.setBackPicReviewState("0");
            }
        }
        po.setLifePic(vo.getLifePic());
        if (StringUtils.isBlank(vo.getPrice())) {
            vo.setPrice(null);
        }
        po.setPrice(vo.getPrice());
        po.setCity(vo.getCity());
        po.setMobile(vo.getMobile());
        po.setLinkman(vo.getLinkman());
        po.setHealthInfo(vo.getHealthInfo());
        //更新上架时间
        po.setType(vo.getType() == null ? "1" : vo.getType());
        dogActivationService.setAddTime(po, vo.getState());
        po.setState(vo.getState());
        if ("1".equals(vo.getState()) && "1".equals(vo.getType())) {
            po.setUpperReview("1");
        } else {
            po.setUpperReview("0");
        }
        po.setConsign(vo.getConsign());
    }

    private void setUpper(DogActivation po, RestDogActivation vo) {
        if (!"1".equals(po.getUpperReview())) {
            //不是审核通过，可以修改照片，审核状态为未审核
            po.setUpperReview("0");
            if (!"1".equals(po.getFrontPicReviewState())) {
                po.setFrontPic(vo.getFrontPic());
                po.setFrontPicRemark("");
                po.setFrontPicReviewState("0");
            }
            if (!"1".equals(po.getSidePicReviewState())) {
                po.setSidePic(vo.getSidePic());
                po.setSidePicRemark("");
                po.setSidePicReviewState("0");
            }
            if (!"1".equals(po.getBackPicReviewState())) {
                po.setBackPic(vo.getBackPic());
                po.setBackPicRemark("");
                po.setBackPicReviewState("0");
            }
        }
        po.setLifePic(vo.getLifePic());
        if (StringUtils.isBlank(vo.getPrice())) {
            vo.setPrice(null);
        }
        po.setPrice(vo.getPrice());
        po.setCity(vo.getCity());
        po.setMobile(vo.getMobile());
        po.setLinkman(vo.getLinkman());
        po.setHealthInfo(vo.getHealthInfo());
        //更新上架时间
        po.setType(vo.getType() == null ? "2" : vo.getType());
        dogActivationService.setAddTime(po, vo.getState());
        po.setState(vo.getState());
        po.setConsign(vo.getConsign());
        po.setReviewState("1");
    }

    private RestDogActivation getDogInfo(String birthCode, boolean isNeedMemberInfo) {
        RestDogActivation vo = new RestDogActivation();
        //出生纸信息
        DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(birthCode);
        //出生纸校验
        dogActivationService.validateDogBirthCertificate(dogBirthCertificate);
        //繁殖人信息
        Member member = memberDao.getByMemberCode(dogBirthCertificate.getBreederMemberCode());
        if (isNeedMemberInfo) {
            //校验出生纸
            dogActivationService.validateDogBirthCertificate(dogBirthCertificate);
            vo.setLinkman(member.getName());
            vo.setMobile(member.getMobile());
            //获取城市
            List<String> provinceCityList = Lists.newArrayList("北京市", "上海市", "天津市", "重庆市");
            if (provinceCityList.contains(member.getProvince())) {
                vo.setCity(member.getProvince());
            } else {
                vo.setCity(member.getCity());
            }
        }
        vo.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
        vo.setIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
        DogType dogType = dogTypeDao.getByDogBreedCode(dogBirthCertificate.getDogBreed());
        if (dogType != null) {
            vo.setBreedCnName(dogType.getBreedCnName());
        }
        DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
        if (dogColorMark != null) {
            vo.setDogColorMarkCn(dogColorMark.getDogColorMarkCn());
        }
        vo.setGender(DictUtils.getDictLabel(dogBirthCertificate.getDogGender(), "dog_gender", ""));
        vo.setBirthdate(DateFormatUtils.ISO_DATE_FORMAT.format(dogBirthCertificate.getDogBirthday()));
        //获取估价
        getEstimatedPrice(member, dogBirthCertificate, vo);
        return vo;
    }

    private void getEstimatedPrice(Member member, DogBirthCertificate dogBirthCertificate, RestDogActivation vo) {
        String estimatedPrice = "";
        String lowEstimatedPrice = "";
        String highEstimatedPrice = "";
        try {
            OkHttpClient client = new OkHttpClient();
            //获取breedCode
            Request request = new Request.Builder()
                    .url(PETPRICING_URL + "codeMapping/getByExternalCode/" + dogBirthCertificate.getDogBreed())
                    .build();
            Response response = client.newCall(request).execute();
            String breedCode = response.body().string();
            if (StringUtils.isNotBlank(breedCode)) {
                //组装城市参数
                String tradingCity = member.getProvince() + ",";
                List<String> provinceCityList = Lists.newArrayList("北京市", "上海市", "天津市", "重庆市");
                if (provinceCityList.contains(member.getProvince())) {
                    tradingCity += member.getProvince();
                } else {
                    tradingCity += member.getCity();
                }
                //获取双亲登录参数
                String parentAward = "Non";
                ChampionLogin championLogin = new ChampionLogin();
                championLogin.setPedigreeCertified(dogBirthCertificate.getFdogPedigreeCertified());
                int fatherCount = championLoginDao.listCount(championLogin);
                championLogin.setPedigreeCertified(dogBirthCertificate.getMdogPedigreeCertified());
                int motherCount = championLoginDao.listCount(championLogin);
                if (fatherCount > 0 && motherCount > 0) {
                    parentAward = "D";
                } else if (fatherCount > 0 || motherCount > 0) {
                    parentAward = "S";
                }
                //组装请求
                JSONObject json = new JSONObject();
                json.put("age", getMonthAge(new Date(), dogBirthCertificate.getDogBirthday()) + "");
                json.put("breedCode", breedCode);
                json.put("tradingCity", tradingCity);
                json.put("parentAward", parentAward);
                json.put("certificateType", "无血统证书");
                json.put("ckuOrCsvKennel", "true");
                json.put("disqualification", "false");
                json.put("kennelLevel", "Non");
                json.put("pedigree", "NA");
                json.put("selfAward", "Non");
                json.put("sfSystemaHaemale", "");
                RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), json.toString());
                //查询估价
                request = new Request.Builder()
                        .url(PETPRICING_URL + "pricing/json")
                        .post(body)
                        .build();
                response = client.newCall(request).execute();
                JSONObject jo = JSONObject.fromObject(response.body().string());
                estimatedPrice = jo.getInt("estimatedPrice") + "";
                lowEstimatedPrice = jo.getInt("lowEstimatedPrice") + "";
                highEstimatedPrice = jo.getInt("highEstimatedPrice") + "";
            }
        } catch (Exception e) {

        }
        vo.setPrice(estimatedPrice);
        vo.setLowEstimatedPrice(lowEstimatedPrice);
        vo.setHighEstimatedPrice(highEstimatedPrice);
    }

    private int getMonthAge(Date date, Date birthdate) {
        Calendar dateCalendar = Calendar.getInstance();
        Calendar birthdateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        birthdateCalendar.setTime(birthdate);
        int monthAge = dateCalendar.get(Calendar.MONTH)
                - birthdateCalendar.get(Calendar.MONTH);
        if (dateCalendar.get(Calendar.YEAR) != birthdateCalendar
                .get(Calendar.YEAR)) {
            monthAge = (dateCalendar.get(Calendar.YEAR) - birthdateCalendar
                    .get(Calendar.YEAR)) * 12 + monthAge;
        }
        birthdateCalendar.add(Calendar.MONTH, monthAge);
        if (birthdateCalendar.getTime().after(dateCalendar.getTime())) {
            monthAge = monthAge - 1;
        }
        return monthAge;
    }


    public RESTResponse dogActivationSearchLabelOther() {
        List<JSONObject> list = Lists.newArrayList();
        for (DogActivationSearchLabelOtherEnum dogActivationSearchLabelOtherEnum : DogActivationSearchLabelOtherEnum.values()) {
            JSONObject jo = new JSONObject();
            jo.put("label", dogActivationSearchLabelOtherEnum.getLabel());
            jo.put("value", dogActivationSearchLabelOtherEnum.getValue());
            list.add(jo);
        }
        return new RESTResponse("list", new PageBeanResult<>(list, new Long(list.size())));
    }

    public RESTResponse dogActivationSearch(HttpServletRequest request) {
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        // 参数校验
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
        }
        Map map = Maps.newHashMap();
        map.put("pageNo", (pageNoInt - 1) * pageSizeInt);
        map.put("pageSize", pageSizeInt);
        map.put("dogBreed", request.getParameter("dogBreed"));
        map.put("city", request.getParameter("city"));
        map.put("identificationFlag", request.getParameter("identificationFlag"));
        map.put("gender", request.getParameter("gender"));
        map.put("age", request.getParameter("age"));
        map.put("order", request.getParameter("order"));
        map.put("priceMin", request.getParameter("priceMin"));
        map.put("priceMax", request.getParameter("priceMax"));
        map.put("consign", request.getParameter("consign"));
        //查询某省或某市数据
        String parentIdArray = request.getParameter("parentIdArray");
        String nameArray = request.getParameter("nameArray");
        if (StringUtils.isNotBlank(parentIdArray)) {
            map.put("parentIdArray", parentIdArray.split(","));
        }
        if (StringUtils.isNotBlank(nameArray)) {
            map.put("nameArray", nameArray.split(","));
        }
        String other = request.getParameter("other");
        if (StringUtils.isNotBlank(other)) {
            for (String value : other.split(",")) {
                DogActivationSearchLabelOtherEnum e = DogActivationSearchLabelOtherEnum.getByValue(value);
                if (e != null) {
                    map.put(e.getParameter(), "1");
                }
            }
        }
        List<DogActivation> dogActivationList = dogActivationDao.search(map);
        List<JSONObject> list = buildDogActivationList(dogActivationList, request);
        return new RESTResponse("list", new PageBeanResult<>(list, dogActivationDao.getSearchCount(map)));
    }

    public RESTResponse searchByChannel(HttpServletRequest request) {
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        // 参数校验
        int pageNoInt = 1;
        int pageSizeInt = 10;
        try {
            if (StringUtils.isNotBlank(pageNo)) {
                pageNoInt = Integer.parseInt(pageNo);
            }
            if (StringUtils.isNotBlank(pageSize)) {
                pageSizeInt = Integer.parseInt(pageSize);
            }
        } catch (Exception e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
        }
        Map map = getChannelMap(request);
        map.put("pageNo", (pageNoInt - 1) * pageSizeInt);
        map.put("pageSize", pageSizeInt);
        map.put("dogBreed", request.getParameter("dogBreed"));
        map.put("city", request.getParameter("city"));
        map.put("identificationFlag", request.getParameter("identificationFlag"));
        map.put("gender", request.getParameter("gender"));
        map.put("age", request.getParameter("age"));
        map.put("order", request.getParameter("order"));
        String other = request.getParameter("other");
        if (StringUtils.isNotBlank(other)) {
            for (String value : other.split(",")) {
                DogActivationSearchLabelOtherEnum e = DogActivationSearchLabelOtherEnum.getByValue(value);
                if (e != null) {
                    map.put(e.getParameter(), "1");
                }
            }
        }
        List<DogActivation> dogActivationList = dogActivationDao.search(map);
        List<JSONObject> list = buildDogActivationList(dogActivationList, request);
        return new RESTResponse("list", new PageBeanResult<>(list, dogActivationDao.getSearchCount(map)));
    }

    private Map getChannelMap(HttpServletRequest request) {
        String ip = IPLimitUtil.getIpAddr(request);
        List<Dict> dictList = DictUtils.getDictList("dog_activation_search_ip");
        for (Dict dict : dictList) {
            if (dict.getValue().contains(ip)) {
                JSONObject jo = JSONObject.fromObject(StringEscapeUtils.unescapeHtml4(dict.getRemarks()));
                Map map = Maps.newHashMap();
                map.put("parentIdArray", jo.getString("parentId").split(","));
                map.put("nameArray", jo.getString("name").split(","));
                return map;
            }
        }
        throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "IP" + ip + "不在允许访问列表内");
    }

    private List<JSONObject> buildDogActivationList(List<DogActivation> dogActivationList, HttpServletRequest request) {
        List<JSONObject> list = Lists.newArrayList();
        for (DogActivation dogActivation : dogActivationList) {
            JSONObject jo = new JSONObject();
            jo.put("identificationFlag", getString(dogActivation.getIdentificationFlag()));
            jo.put("coverImgId", getString(ImgUtil.getImgUrl(request, dogActivation.getFrontPic())));
            jo.put("dogBreed", getString(dogTypeService.getBreedCnName(dogActivation.getDogBreed())));
            jo.put("gender", getString(dogActivation.getDogGender()));
            jo.put("age", getString(studDogService.getAge(dogActivation.getDogBirthday())));
            jo.put("city", getString(dogActivation.getCity()));
            jo.put("consign", getString(dogActivation.getConsign()));
            jo.put("price", getString(dogActivation.getPrice()));
            list.add(jo);
        }
        return list;
    }

    private String getString(String str) {
        return str == null ? "" : str;
    }

    @Transactional(readOnly = false)
    public RESTResponse upDown(String json) throws Exception {
        JSONObject jo = JSONObject.fromObject(json);
        String state = jo.getString("state");
        String birthCerRegCode = jo.getString("birthCerRegCode");
        DogActivation dogActivation = dogActivationService.getByBirthCode(birthCerRegCode);
        if (dogActivation == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "birthCerRegCode有误");
        }
        if (StringUtils.isBlank(dogActivation.getState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "缺少上架状态参数");
        }
        if (!"0".equals(dogActivation.getState()) && !"1".equals(dogActivation.getState())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "上架状态只能为0或1");
        }
        dogActivation.setState(state);
        if (state.equals("1")) {
            DogBirthCertificate dogbirth = dogBirthCertificateDao.getByBirthCerRegCode(birthCerRegCode);
            int monthAge = getMonthAge(new Date(), dogbirth.getDogBirthday());
            if (monthAge > 24) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只犬龄大于24个月、不能上架");
            }
            if (StringUtils.isBlank(dogActivation.getPrice()) || dogActivation.getPrice().equals("0")) {
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只上架价格不能为空且不能为0");
            }
            dogActivation.setAddTime(new Date());
            dogActivation.setUpperReview("1");
        } else {
            dogActivation.setConsign("0");
        }
        dogActivationService.save(dogActivation);
        return new RESTResponse();
    }
}
