package com.cku.restful.v1.breeder.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.annotation.MultiSubmit;
import com.cku.core.PageResultDto;
import com.cku.core.ResultDto;
import com.cku.restful.v1.breeder.dto.RestDogChipApplyCouponDto;
import com.cku.restful.v1.breeder.dto.RestDogChipApplyOptimalCouponsDto;
import com.cku.restful.v1.breeder.service.BreederDogChipService;
import com.cku.restful.v1.dog.model.RestDogChipPriceDto;
import com.cku.restful.v1.dog.model.RestDogChipPriceResultDto;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.sys.model.RestCouponGroup;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * @description: 专业繁殖人血统证书相关业务
 * @author: laiguanglong
 * @date: 2017/11/30 11:03
 */
@Controller
@Api(tags = "专业繁殖人血统证书相关业务", description = "BreederDogChipController")
@RequestMapping(value = "/api/v1/breeder/dog/newdogchip")
public class BreederDogChipController extends BaseRestController {

	@Autowired
	private BreederDogChipService service;

	
	@Autowired
	private RestDogChipService restDogChipService;

	@MultiSubmit
	@RequestMapping(value = "", method = RequestMethod.POST)
	public void post(@RequestBody String json, HttpServletResponse response, HttpServletRequest request)
			throws IOException {
		ServletUtils.writeResponse(response, service.post(json, request));
	}

	// 依照犬只获取该会员办理血统证书可用的优惠劵
	// @ResponseBody
	@ApiOperation(value = "血统证书-优惠券列表")
	@GetMapping(value = "/coupons")
	public PageResultDto<RestCouponGroup> getCoupon(RestDogChipApplyCouponDto request, HttpServletResponse response,
			HttpServletRequest httpRequest) throws IOException {
		// 因框架统一处理 null 为 "" 导致 RestCouponGroupPageDto 中的空对象 也为
		// ""，前端无法解析，故此处手动转换对象为json字符，绕开框架处理
		PageResultDto<RestCouponGroup> result = service.getCoupons(request, httpRequest);
		ServletUtils.writeResponse(response,result);
		// 保留返回值，是为了swagger上可以看到结构体
		return null;
	}

	@ResponseBody
	@ApiOperation(value = "血统证书-获取最优解")
	@GetMapping(value = "/optimalCoupons")
	public ResultDto<RestCouponGroup> getOptimalCoupons(RestDogChipApplyOptimalCouponsDto request) throws Exception {
		return service.getOptimalCoupons(request);
	}

	@RequestMapping(value = "/checkMember", method = RequestMethod.GET)
	public void checkMember(HttpServletRequest request, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.checkMember(request));
	}

	@RequestMapping(value = "/order/{id}", method = RequestMethod.GET)
	public void order(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.order(id));
	}

	@RequestMapping(value = "/getCanApplyDogBirthCertificateList", method = RequestMethod.GET)
	public void getCanApplyDogBirthCertificateList(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		ServletUtils.writeResponse(response, service.getCanApplyDogBirthCertificateList(request));
	}

	@ApiOperation(value = "血统证书-核对页", tags = { "血统证书-zxy" })
	@ApiImplicitParams({ @ApiImplicitParam(name = "token", paramType = "query", value = "token") })
	@ApiResponses({
			@ApiResponse(code = 0, message = "无会员缴费:{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
					+ "    \"data\": {\n" + "        \"newMemnerFlag\": false  \n" + "    }\n" + "}\n" + ""),
			@ApiResponse(code = 0, message = "有会员缴费:{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
					+ "    \"data\": {\n" + "        \"memberName\": \"13344445454\",\n"
					+ "        \"memberCode\": \"22459\",\n" + "        \"memberMobile\": \"13344445454\",\n"
					+ "        \"memberType\": \"CKU宠爱会员金卡\",\n" + "        \"newMemnerFlag\": true\n" + "    }\n"
					+ "}\n" + "") })
	@RequestMapping(value = "/orderOther/{id}", method = RequestMethod.GET)
	public void orderOther(@ApiParam(name = "id", value = "业务id") @PathVariable("id") String id,
			HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.orderOther(id));
	}

	@ResponseBody
	@ApiOperation(value = "血统证书-获取价格")
	@PostMapping(value = "/getPrice")
	public ResultDto<RestDogChipPriceResultDto> getPrice(@RequestBody RestDogChipPriceDto request) throws IOException {
		return ResultDto.success(restDogChipService.getPriceWithCoupon(request));
	}

}