/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.breeder.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogNewbornService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.kennel.service.KennelAllianceService;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.dog.model.RestDogNewborn;
import com.cku.restful.v1.dog.service.RestDogNewbornService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.cku.restful.v1.sys.model.RestCoupon;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * 配种证明Service
 *
 * @author zhuoHeng
 * @version 2016-08-02
 */
@Service
@Transactional(readOnly = true)
public class BreederDogNewbornService {
	@Autowired
	private RestDogNewbornService restDogNewbornService;
	@Autowired
	private DogNewbornService dogNewbornService;
	@Autowired
	private RestOrderService restOrderService;
	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private DogNewbornDao dogNewbornDao;
	@Autowired
	private KennelAllianceService kennelAllianceService;
	@Autowired
	private DogDao dogDao;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Transactional(readOnly = false)
	public RESTResponse post(HttpServletRequest request, String json) {
		RESTResponse response = restDogNewbornService.post(request, json);
		String[] cardIds =response.getData().getJSONObject("data").getString("cartIds").split(",") ;
        return restOrderService.cartToOrder(cardIds);
	}

	public RESTResponse order(String id) {
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		PaymentOrder paymentOrder = paymentOrderDao.get(id);
		if (paymentOrder == null || !paymentOrder.getMemberCode().equals(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单号有误");
		}
		String productNum = "1";
		String dogNewbornId = null;
		PaymentOrderDetail detail = null;

		List<PaymentOrderDetail> paymentOrderDetailList = paymentOrderDetailDao
				.getOrderByRunningNum(paymentOrder.getOrderCode(), memberCode);
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			if ("dog_newborn".equals(paymentOrderDetail.getBusinessTable())) {
				dogNewbornId = paymentOrderDetail.getBusinessIds();
				detail = paymentOrderDetail;
				break;
			}
		}

		if (StringUtils.isBlank(dogNewbornId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单有误");
		}
		DogNewborn dogNewborn = dogNewbornDao.get(dogNewbornId);

		// 组装返回对象
		JSONObject jo = new JSONObject();
		jo.put("orderCode", paymentOrder.getOrderCode());
		JSONArray ja = new JSONArray();

		PaymentChargingItem paymentChargingItem = paymentChargingItemService.get(detail.getChargingItemId());
		String productPrice = paymentChargingItem.getPrice();

		if ("1".equals(dogNewborn.getUrgent())) {
			Double urgentFee = Double.parseDouble(productPrice) * 0.3;
			// 加急
			JSONObject urgentJo = new JSONObject();
			urgentJo.put("name", "加急办理");
			urgentJo.put("info", "1天完成审批，增加30%手续费");
			urgentJo.put("price", urgentFee.toString());
			ja.add(urgentJo);
			if (kennelAllianceService.isUrgentFree(dogNewborn.getFdogOwnerCode())) {
				// 免加急费
				JSONObject urgentFreeJo = new JSONObject();
				urgentFreeJo.put("name", "免加急费");
				urgentFreeJo.put("info", "犬舍联盟免加急费");
				urgentFreeJo.put("price", "-" + urgentFee.toString());
				ja.add(urgentFreeJo);
			}
		}

		jo.put("other", ja);
		jo.put("totalPrice", paymentOrder.getTotalPrice());
		// 判断产品类型
		jo.put("productName", "配种证明登记费");
		jo.put("productNum", productNum);
		jo.put("productPrice", productPrice);
		return new RESTResponse("data", jo);
	}

	/**
	 * @description: 获取名下可配种犬只信息
	 * @author: laiguanglong
	 * @date: 2017/9/5 13:51
	 */
	public RESTResponse getBreedableDog(HttpServletRequest request) {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String gender = request.getParameter("gender");
		String key = request.getParameter("key") == null ? null : request.getParameter("key").trim();
		
		if(StringUtils.isNotEmpty(key) && key.toUpperCase().contains("CKUHK")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写新生犬登记表进行线下提交，如有疑问请致电4006607000.");
		}
		
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		if (StringUtils.isBlank(gender)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只性别为空");
		}
		if (!"1".equals(gender) && !"2".equals(gender)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只性别只能为1或2");
		}
		String memberCode = UserUtils.getLoginMember().getMemberCode();
		String ageFlag = "1";
		if (new Date().getTime() > DogBirthCertificateService.KENNEL_UNACTIVATION_MILLIS) {
			ageFlag = "0";
		}
		List<Dog> dogList = dogDao.getBreedableDog(memberCode, gender, key, (pageNoInt - 1) * pageSizeInt, pageSizeInt,
				ageFlag);
		List<JSONObject> list = Lists.newArrayList();
		for (Dog dog : dogList) {
			list.add(buildDogJSONObject(dog));
		}
		return new RESTResponse("list",
				new PageBeanResult<>(list, dogDao.getBreedableDogCount(memberCode, gender, key, ageFlag)));
	}

	/**
	 * @description: 获取母犬信息
	 * @author: laiguanglong
	 * @date: 2017/9/5 13:51
	 */
	public RESTResponse getMotherDog(HttpServletRequest request) {
		String key = request.getParameter("key");
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号或芯片号为空");
		}
		if(StringUtils.isNotEmpty(key) && key.toUpperCase().contains("CKUHK")) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写新生犬登记表进行线下提交，如有疑问请致电4006607000.");
		}
		
		Dog dog = dogDao.getByPedigreeCertifiedCode(key);
		if (dog == null) {
			dog = dogDao.getByIdentificationFlag(key);
		}
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号或芯片号有误");
		}
		dogNewbornService.validateMotherDog(dog, null, "vip");
		return new RESTResponse("data", buildDogJSONObject(dog));
	}

	/**
	 * @description: 校验配种日期
	 * @author: laiguanglong
	 * @date: 2017/9/5 13:51
	 */
	public RESTResponse checkBreedDate(HttpServletRequest request) {
		String malePedigreeCertified = request.getParameter("malePedigreeCertified");
		String femalePedigreeCertified = request.getParameter("femalePedigreeCertified");
		String breedDate = request.getParameter("breedDate");
		String id = request.getParameter("id");
		if (StringUtils.isBlank(malePedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父血统证书号为空");
		}
		if (StringUtils.isBlank(femalePedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母血统证书号为空");
		}
		if (StringUtils.isBlank(breedDate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期为空");
		}

		Date date;
		try {
			date = new SimpleDateFormat("yyyy-MM-dd").parse(breedDate);
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期格式有误");
		}
		if (date.getTime() > System.currentTimeMillis()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期必须小于当前日期");
		}

		RestDogNewborn vo = new RestDogNewborn();
		vo.setMalePedigreeCertified(malePedigreeCertified);
		vo.setFemalePedigreeCertified(femalePedigreeCertified);
		vo.setBreedDate(breedDate);
		vo.setUrgent("0");

		DogNewborn po = restDogNewbornService.buildPo(vo);
		po.setId(id);
		dogNewbornService.validateBusiness(po);
		return new RESTResponse();
	}

	private JSONObject buildDogJSONObject(Dog dog) {
		JSONObject data = new JSONObject();
		data.put("nickname", getString(dog.getNickname()));
		data.put("nameEn", getString(dog.getNameEn()));
		data.put("dogBreed", getString(dogTypeService.getBreedCnName(dog.getDogBreed())));
		data.put("pedigreeCertifiedCode", getString(dog.getPedigreeCertifiedCode()));
		data.put("identificationFlag", getString(dog.getIdentificationFlag()));
		data.put("birthdate", getString(com.cku.util.DateUtils.dateToStr(dog.getBirthdate())));
		data.put("dogOwner", getString(dog.getDogOwner()));
		data.put("colorFlag", getString(dogColorMarkService.getDogColorMarkCn(dog.getColorFlag())));
		data.put("callName", getString(dog.getCallName()));
		return data;
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}
	
	@Transactional(readOnly = false)
	public RESTResponse getPriceInfo(HttpServletRequest request, String json) throws Exception {
		return restDogNewbornService.getPriceInfo(json);	
	}
	
	@Transactional(readOnly = false)
	public RESTResponse getCoupons(HttpServletRequest request) throws Exception {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String breedDate = request.getParameter("breedDate");
		if ( StringUtils.isBlank(breedDate)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "配种日期必填！");
		}
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(request.getParameter("pageNo"))) {
				pageNoInt = Integer.parseInt(request.getParameter("pageNo"));
			}
			if (StringUtils.isNotBlank(request.getParameter("pageSize"))) {
				pageSizeInt = Integer.parseInt(request.getParameter("pageSize"));
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		Page<SysCoupon> result = restDogNewbornService.getCoupons(member.getMemberCode(), breedDate, pageNoInt, pageSizeInt);

		// 结果处理
		List<RestCoupon> resultList = new ArrayList<RestCoupon>();
		for (SysCoupon coupon : result.getList()) {
			RestCoupon vo = new RestCoupon();
			BeanUtil.copyProperties(vo, coupon, "yyyy-MM-dd");
			if (coupon.getUseState().equals("1")) {
				vo.setState("已用");
			} else {
				if (StringUtils.isNotBlank(vo.getValidDate())
						&& com.thinkgem.jeesite.common.utils.DateUtils.isAfterMounth(new Date(), vo.getValidDate(), Boolean.FALSE)) {
					vo.setState("过期");
				} else {
					vo.setState("有效");
				}
			}
			String couponTypeDesc = "";
			if ("1".equals(coupon.getCouponType())) {
				couponTypeDesc = "代金券";
			}
			if ("2".equals(coupon.getCouponType())) {
				couponTypeDesc = "抵扣券";
			}
			if ("3".equals(coupon.getCouponType())) {
				couponTypeDesc = "参展券";
			}
			if ("4".equals(coupon.getCouponType())) {
				couponTypeDesc = "满减券";
			}
			vo.setCouponTypeDesc(couponTypeDesc);
			resultList.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestCoupon>(resultList, count));
	}
	
	@Transactional(readOnly = false)
	public RESTResponse getTotalPrice(HttpServletRequest request, String json) throws Exception {
		return restDogNewbornService.getTotalPrice(json);	
	}
	
}