package com.cku.partner.open.finace.web;

import com.cku.core.RESTResponse;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.coupon.dao.SysCouponDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.partner.open.club.service.AppHospitalService;
import com.cku.partner.open.finace.service.AppOrderService;
import com.cku.restful.v1.finance.entity.RestPaymentOrderDetail;
import com.cku.restful.v1.sys.service.RefundService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.restful.v1.sys.web.RefundController;
import com.cku.util.ServletUtils;
import com.google.common.collect.Maps;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import io.netty.util.internal.StringUtil;
import io.swagger.annotations.*;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Controller
@RequestMapping(value = "/partner/open/finance")
@Api(value = "俱乐部-业务(合作机构APP)-zhangxiang", tags = { "俱乐部-业务-费用中心(合作机构APP)-zhangxiang" })
public class AppOrderController extends BaseRestController {
	@Autowired
	AppOrderService appOrderService;
	@Autowired
	PaymentOrderService paymentOrderService;
	@Autowired
	private MemberService memberService;
    @Autowired
    private AppHospitalService appHospitalService;
	@Autowired
	private RefundController refundController;
	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	private SysCouponDao sysCouponDao;
	@Autowired
	private RefundService refundService;
	/**
	* @Description: 付款
	* @author: zhangxiang
	* @date: 2020/7/13 18:38
	*/
	@RequestMapping(value="recharge")
    @ResponseBody
	public Map<String, String>  recharge(PaymentOrder paymentOrder, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes){

        Map<String, String> map = Maps.newHashMap();
        map.put("rc", "0");

	    //充值金额
		String amount=paymentOrder.getAmount();
		//充值方式
		String paymentWay=paymentOrder.getPaymentWay();
		String id=null;
		try {
            Member member = appHospitalService.loginMember();
            String memberCode = member.getMemberCode();
            String name = member.getName();
            id = memberService.recharge(memberCode,name,amount,paymentWay);
            map.put("id",id);
		} catch (Exception e) {
            map.put("id",id);
            map.put("rc", "1");
            map.put("msg", e.getMessage());

		}
        return  map;
	}
    /**
     * @Description: 费用中心
     * @author: zhangxiang
     * @date: 2020/7/13 18:38
     */
	@ApiOperation(value = "费用中心（合作机构APP）")
	@ApiImplicitParams({ @ApiImplicitParam(name = "pageNo", value = "分页"),
			@ApiImplicitParam(name = "pageSize", value = "分页"),
			@ApiImplicitParam(name = "token", paramType = "query", value = "token"),
			@ApiImplicitParam(name = "paymentTime", value = "（近一年=1 ，近30天=2，近7天=3，今日=4）"),
			@ApiImplicitParam(name = "isRecharge", value = "订单编号")})
	@ApiResponses({ @ApiResponse(code = 0, message = "（收入=1 支出=0）") })
	@RequestMapping(value = "/cost", method = RequestMethod.GET)
	@ResponseBody
	public void getCost(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = new RESTResponse();
		try{
			result = appOrderService.findByPageCost(request);
		}catch (Exception e){
			result.setRc(1);
			result.setMsg(e.getMessage());
		}
		ServletUtils.writeResponse(response, result);
	}
	/**
	* @Description:  订单列表
	* @author: zhangxiang
	* @date: 2020/7/21 11:22
	*/
	@RequestMapping(value = "/order", method = RequestMethod.GET)
	@ResponseBody
	public void getOrder(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = appOrderService.findByPage(request);
		ServletUtils.writeResponse(response, result);
	}
	/**
	* @Description:   取消订单
	* @author: zhangxiang
	* @date: 2020/7/21 11:27
	*/
	@RequestMapping(value = "/order/cab", method = RequestMethod.DELETE)
	@ResponseBody
	public void deleteOrderById(HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 这里获取member，如果token失效，会抛出-30，用户信息验证失败的异常
		User user = appHospitalService.loginUser();
		String id = request.getParameter("id");
		PaymentOrder order = new PaymentOrder();
		order.setId(id);
		paymentOrderService.removeOrder(order);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据订单号 业务号查找申请退款 业务数据
	 *
	 * @param paymentOrderDetail
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "refundApply", method = RequestMethod.POST)
	public void refundApply(@RequestBody RestPaymentOrderDetail paymentOrderDetail, HttpServletRequest request,
							HttpServletResponse response) throws IOException {
		RESTResponse result = refundController.refundApplyParameterVerification(paymentOrderDetail, 0);
		if (result != null) {
			ServletUtils.writeResponse(response, result);
			return;
		}
		//Member member = appHospitalService.loginMember();
		//俱乐部用户
		User user = appHospitalService.loginUser();

		//俱乐部不需要查会员号,根据创建人查询
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setCreateBy(user);
		detail.setOrderCode(paymentOrderDetail.getOrderCode());
		detail.setBusinessId(paymentOrderDetail.getBusinessId());
		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findAllList(detail);
		Map<String, List<PaymentOrderDetail>> collect = orderDetailList.stream()
				.filter(i -> org.apache.commons.lang3.StringUtils.isNotEmpty(i.getBusinessId())
						&& org.apache.commons.lang3.StringUtils.isNotEmpty(i.getBusinessOrderCode()))
				.collect(Collectors.groupingByConcurrent(PaymentOrderDetail::getBusinessOrderCode));
		result = refundService.getBusinessList(detail.getBusinessId(), collect);
		// StringBuffer sb = new StringBuffer();
		// StringBuffer sbTable = new StringBuffer();
		// collect.entrySet().forEach(i -> {
		// sb.append("'" + i.getKey() + "'").append(",");
		// if (StringUtil.isNullOrEmpty(String.valueOf(sbTable)))
		// sbTable.append(i.getValue().get(0).getBusinessTable());
		// });
		// if (sb.length() > 0) sb.deleteCharAt(sb.length() - 1);
		// if (StringUtil.isNullOrEmpty(String.valueOf(sb))) {
		// ServletUtils.writeResponse(response, new RESTResponse(-1, "没有符合条件的数据"));
		// return;
		// }
		// result = refundService.getBusinessList(String.valueOf(sb),
		// String.valueOf(sbTable));
		result.getData().getJSONArray("data").stream().forEach(i -> {
			StringBuffer rs = new StringBuffer();
			StringBuffer r = new StringBuffer();
			StringBuffer rr = new StringBuffer();
			orderDetailList.stream()
					.filter(p -> p.getBusinessIds().contains(String.valueOf(((JSONObject) i).get("id")))).forEach(o -> {
				if (StringUtil.isNullOrEmpty(String.valueOf(rs))) {
					rs.append(o.getBusinessRefundState());
					r.append(o.getBusinessRefundReason());
					rr.append(refundService.getRefundable(o.getBusinessId(), o.getBusinessIds(),
							o.getBusinessRefundState(), o.getOrderCode()).getFlag());
				}
			});
			((JSONObject) i).put("businessRefundState", String.valueOf(rs));
			((JSONObject) i).put("businessRefundReason", String.valueOf(r));
			((JSONObject) i).put("refundable", Boolean.valueOf(rr.toString()));
		});
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 根据 订单号 业务序号和业务数据序号更改业务数据申请状态
	 *
	 * @param paymentOrderDetail
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "refundApplyOperation", method = RequestMethod.POST)
	public void refundApplyOperation(@RequestBody RestPaymentOrderDetail paymentOrderDetail, HttpServletRequest request,
									 HttpServletResponse response) throws IOException {

		RESTResponse result = refundController.refundApplyParameterVerification(paymentOrderDetail, 1);
		if (result != null) {
			ServletUtils.writeResponse(response, result);
			return;
		}

		//俱乐部用户
		User user = appHospitalService.loginUser();

		Member member = appHospitalService.loginMember();


		//俱乐部不需要查会员号,根据创建人查询
		PaymentOrderDetail detail = new PaymentOrderDetail();
		detail.setCreateBy(user);
		detail.setOrderCode(paymentOrderDetail.getOrderCode());
		detail.setBusinessId(paymentOrderDetail.getBusinessId());
		detail.setBusinessIds(paymentOrderDetail.getBusinessIds());

		List<PaymentOrderDetail> orderDetailList = paymentOrderDetailDao.findAllList(detail);
		if (orderDetailList.size() > 0) {
			PaymentOrderDetail orderDetail = orderDetailList.get(0);
			// 上线前改为最终上线日期,上线之后一天产生的订单可以申请退款
			Date onLineDate = new Date(2020 - 1900, 2 - 1, 18 + 1, 0, 0);
			// 验证业务状态 和是否为新订单（写死的日期）
			if (!orderDetail.getCreateDate().after(onLineDate)) {
				ServletUtils.writeResponse(response, new RESTResponse(-1, "此订单为旧订单，不允许系统退款！"));
				return;
			}
		}

//		// 赛事业务特殊处理，暂时关闭退费功能
//		if ("1027".equals(paymentOrderDetail.getBusinessId()) || "1030".equals(paymentOrderDetail.getBusinessId())
//				|| "1033".equals(paymentOrderDetail.getBusinessId()) || "1036".equals(paymentOrderDetail.getBusinessId())
//				|| "1039".equals(paymentOrderDetail.getBusinessId()) || "1042".equals(paymentOrderDetail.getBusinessId())
//				|| "1070".equals(paymentOrderDetail.getBusinessId()) || "1073".equals(paymentOrderDetail.getBusinessId())) {
//			ServletUtils.writeResponse(response, new RESTResponse(-1, "比赛退费功能关闭。"));
//			return;
//		}

		// 国外血统证书换发，需特殊处理
		if ("1004".equals(paymentOrderDetail.getBusinessId()) && !CollectionUtils.isEmpty(orderDetailList)) {
			PaymentOrderDetail newDetail = new PaymentOrderDetail();
			newDetail.setMemberCode(member.getMemberCode());
			newDetail.setOrderCode(paymentOrderDetail.getOrderCode());
			newDetail.setBusinessId(paymentOrderDetail.getBusinessId());
			newDetail.setBusinessOrderCode(orderDetailList.get(0).getBusinessOrderCode());
			orderDetailList = paymentOrderDetailDao.findAllList(newDetail);
		}

		// 如果使用了需要均摊的优惠券，就不能退款
		List<SysCoupon> coupons = sysCouponDao.getCouponXNList(paymentOrderDetail.getOrderCode());
		if (coupons.size() > 0) {
			ServletUtils.writeResponse(response, new RESTResponse(-1, "该订单如需退款，请致电客服：400-6607000申请退款。"));
			return;
		}

		if (orderDetailList.stream().filter(i -> !StringUtil.isNullOrEmpty(i.getBusinessRefundState())).count() > 0) {
			ServletUtils.writeResponse(response, new RESTResponse(-1, "该业务单已申请退款"));
			return;
		}
		for (PaymentOrderDetail pod : orderDetailList) {
			pod.setBusinessRefundState("1");
			pod.setBusinessRefundTime(new Timestamp(System.currentTimeMillis()));
			pod.setBusinessRefundReason(paymentOrderDetail.getBusinessRefundReason());
			paymentOrderDetailDao.update(pod);
		}
		ServletUtils.writeResponse(response, new RESTResponse());
	}
}
