package com.cku.partner.club.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBloodSaveDao;
import com.cku.oa.dog.dao.DogChipChangeDao;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChipChange;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.sampling.entity.Sampling;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sampling.service.SamplingService;
import com.cku.oa.sys.entity.Org;
import com.cku.restful.v1.dog.service.RestDogChipService;
import com.cku.restful.v1.finance.service.RestOrderService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 国外证书换发
 * @author chaixueteng
 *
 */
@Service
@Transactional(readOnly = true)
public class DogCertifiedChangeClubService {
	private static final String CHIP_FEE = "dog_chip_change@chipFee"; //芯片费
	private static final String CHIP_SERVICE_FEE = "dog_chip_change@embedChipFee"; //电子芯片埋置服务费
	private static final String DNA_ARCHIVE_FEE = "dog_dna_archive@New"; //纯种犬DNA样本检测服务费
	private static final String BLOODSAVE_FEE = "dog_blood_save@New"; //纯种犬DNA样本登记服务费
	@Autowired
	public DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	public PaymentChargingItemDao paymentChargingItemDao;
	@Autowired
	public DogChipChangeDao dogChipChangeDao;
	@Autowired
	public DogBloodSaveDao dogBloodSaveDao;
	@Autowired
	public DogDnaArchiveDao dogDnaArchiveDao;
	@Autowired
	public RestOrderService restOrderService;
	@Autowired
	public PaymentOrderDetailDao paymentOrderDetailDao;
	@Autowired
	public PaymentOrderDao paymentOrderDao;
	@Autowired
	public DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	public SamplingService samplingService;
	
	
	/**
	 * 国外证书换发构建订单
	 * @param id
	 */
	@Transactional(readOnly = false)
	public PaymentOrder toOrder(String id,String type,String chipCode,String way,String samplingCode) {
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(id);
		//订单校验 如果有订单就不会重新生成订单 如果没有则生成订单
		if("chip".equals(type)){//芯片的订单
			DogChipChange dogChipChange = dogChipChangeDao.getByOverseasPedigreeCertified(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
			if(dogChipChange!=null){
				String runningNumber = dogChipChange.getRunningNumber();
				PaymentOrder order = paymentOrderDao.getOrderByRunningNum(runningNumber);
				if(!way.equals(order.getPaymentWay())){
					order.setPaymentWay(way);
					paymentOrderDao.update(order);
				}
				return order;
			}
		}
		if("dna".equals(type)){//dna的订单
			DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByOverseasPedigreeCertified(dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
			if(dogDnaArchive!=null){
				String runningNumber = dogDnaArchive.getRunningNumber();
				PaymentOrder order = paymentOrderDao.getOrderByRunningNum(runningNumber);
				if(!way.equals(order.getPaymentWay())){
					order.setPaymentWay(way);
					paymentOrderDao.update(order);
				}
				return order;
			}
		}
		//设置订单基本字段
		PaymentOrder paymentOrder = buildPaymentOrder(dogPedigreeCertifiedChange.getPaymentMemberCode(),dogPedigreeCertifiedChange.getDogOwnerName(),way);
		List<PaymentOrderDetail> paymentOrderDetailList =new ArrayList<PaymentOrderDetail>();
		//芯片录入到国外证书里
		if("chip".equals(type)){//生成订单详情和芯片变更记录
			dogPedigreeCertifiedChange.setDogChip(chipCode);
			DogChipChange dogChipChange=buildDogChipChange(dogPedigreeCertifiedChange.getPaymentMemberCode(),chipCode,dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
			paymentOrderDetailList= buildChipPaymentOrderDetailList(dogChipChange,paymentOrder);
		}else if("dna".equals(type)){//生成订单详情和dna存档记录和血样留存记录
			DogDnaArchive buildDnaArchiveChange = buildDnaArchiveChange(dogPedigreeCertifiedChange.getPaymentMemberCode(),dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
			DogBloodSave buildBloodSaveChange = buildBloodSaveChange(dogPedigreeCertifiedChange.getPaymentMemberCode(),dogPedigreeCertifiedChange.getOverseasPedigreeCertified());
			paymentOrderDetailList = buildDnaPaymentOrderDetailList(buildDnaArchiveChange,buildBloodSaveChange,paymentOrder);
			// 绑定采样包
			if(StringUtils.isBlank(samplingCode)) {
				throw new ZAException(-1, "点位分析必须绑定采样包!");
			}
			Sampling sampling = samplingService.getByDogCode(dogPedigreeCertifiedChange.getOverseasPedigreeCertified(),SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED);
			if(sampling == null) {
				Org org = (Org) UserUtils.getSession().getAttribute("org");
				dogDnaArchiveService.bindSamplingFront(dogPedigreeCertifiedChange.getOverseasPedigreeCertified(),SamplingDogSourceTypeEnum.OVERSEAS_PEDIGREE_CERTIFIED,
						samplingCode, org.getMemberCode());
			}
		}
		//计算订单总额
		Double orderTotal = 0d;
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			orderTotal = orderTotal+Double.parseDouble(detail.getTotalPrice());
		}
		//保存订单
		restOrderService.saveOrder(paymentOrder, orderTotal, paymentOrder.getAddTime());
		//回写订单详情的OrderCode字段
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.setOrderCode(paymentOrder.getOrderCode());
		}
		//保存订单详情
		for(PaymentOrderDetail detail:paymentOrderDetailList){
			detail.preInsert();
			paymentOrderDetailDao.insert(detail);
		}
		//更新业务表流水号
		for (PaymentOrderDetail paymentOrderDetail : paymentOrderDetailList) {
			//更新业务表不为空且不为会员表的收费项
			if(StringUtils.isNotBlank(paymentOrderDetail.getBusinessTable())&&!"sys_member".equals(paymentOrderDetail.getBusinessTable())&&!"kennel".equals(paymentOrderDetail.getBusinessTable())){
				String businessIds = paymentOrderDetail.getBusinessIds();
				if(businessIds.contains(",")){
					String[] bids = businessIds.split(",");
					for(int j=0;j<bids.length;j++){
						paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), bids[j]);
					}
				}else{
					paymentOrderDao.updateBusinessRunningNo(paymentOrder.getOrderCode(), paymentOrderDetail.getBusinessTable(), businessIds);
				}
			}
		}
		return paymentOrder;
	}


	/**
	 * 构建芯片换发记录
	 * @param
	 * @return
	 */
	@Transactional(readOnly = false)
	public DogChipChange buildDogChipChange(String memberCode,String chipCode,String certi) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		DogChipChange dogChipChange = new DogChipChange();
		dogChipChange.preInsert();
		dogChipChange.setOverseasPedigreeCertified(certi);
		dogChipChange.setChipCodeNew(chipCode);
		dogChipChange.setPaymentMemberCode(memberCode);
		dogChipChange.setReviewState("0");
		dogChipChange.setReviewTime(new Date());
		dogChipChange.setPaymentState("1");
		dogChipChange.setProcessState("0");
		dogChipChange.setOrganizationUsername(loginName);
		dogChipChange.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		PaymentChargingItem chipFee = paymentChargingItemDao.getByShortName(CHIP_FEE);
		dogChipChange.setPrice(chipFee.getPrice());
		dogChipChangeDao.insert(dogChipChange);
		return dogChipChange;
	}

	/**
	 * 构建血样留存记录
	 * @param
	 * @return
	 */
	@Transactional(readOnly = false)
	public DogBloodSave buildBloodSaveChange(String memberCode,String certi) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		DogBloodSave dogBloodSave = new DogBloodSave();
		dogBloodSave.preInsert();
		dogBloodSave.setOverseasPedigreeCertified(certi);
		dogBloodSave.setShowAppraisalCode("");
		dogBloodSave.setBirthCode("");
		dogBloodSave.setPaymentMemberCode(memberCode);
	    PaymentChargingItem dogBloodSaveItem = paymentChargingItemDao.getByShortName(RestDogChipService.BLOOD_SAVE_FEE_OEC);
		dogBloodSave.setPrice(dogBloodSaveItem.getPrice());
		dogBloodSave.setPaymentState("1");
		dogBloodSave.setIsCanceled("0");
        dogBloodSave.setTypeYes("2");
		dogBloodSave.setOrgId(org.getId());
		dogBloodSave.setIsOEC("1");
		dogBloodSaveDao.insert(dogBloodSave);
		return dogBloodSave;
	}

	/**
	 * 构建Dna存档记录
	 * @param
	 * @return
	 */
	@Transactional(readOnly = false)
	public DogDnaArchive buildDnaArchiveChange(String memberCode,String certi) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		DogDnaArchive dogDnaArchive = new DogDnaArchive();
		dogDnaArchive.preInsert();
		dogDnaArchive.setOverseasPedigreeCertified(certi);
		dogDnaArchive.setBirthCode("");
		dogDnaArchive.setPaymentMemberCode(memberCode);
		List<PaymentChargingItem> dogDnaArchiveItems = dogDnaArchiveService.getDnaArchiveItem();
		Double dogDnaArchiveFee = dogDnaArchiveItems.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();
		dogDnaArchive.setPrice(dogDnaArchiveFee.toString());
		dogDnaArchive.setReviewState("0");
		dogDnaArchive.setPaymentState("1");
		dogDnaArchive.setProcessState("0");
		dogDnaArchive.setPrintState("0");
		dogDnaArchive.setIsCanceled("0");
		dogDnaArchive.setOrgId(org.getId());
        dogDnaArchive.setTypeYes("2");
		dogDnaArchive.setOperator(loginName+":"+DateUtils.formatDate(new Date(), "yyyy-M-d"));
		dogDnaArchive.setIsOEC("1");
		dogDnaArchiveDao.insert(dogDnaArchive);
		return dogDnaArchive;
	}

	/**
	 * 构建Dna订单详情
	 * @param
	 * @return
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> buildDnaPaymentOrderDetailList(DogDnaArchive dogDnaArchive,DogBloodSave dogBloodSave,PaymentOrder paymentOrder) {
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		
		List<PaymentChargingItem> dogDnaArchiveItems = dogDnaArchiveService.getDnaArchiveItem();
	    for(PaymentChargingItem dogDnaArchiveFee : dogDnaArchiveItems ) {
	    	PaymentOrderDetail detail = new PaymentOrderDetail();
			detail.setAddTime(paymentOrder.getAddTime());
			detail.setProccessState("0");
			detail.setTotalPrice(dogDnaArchiveFee.getPrice());
			detail.setNum("1");
			detail.setPrice(dogDnaArchiveFee.getPrice());
			detail.setChargingItemId(dogDnaArchiveFee.getId());
			detail.setBusinessIds(dogDnaArchive.getId());
			detail.setBusinessTable("dog_dna_archive");
			detail.setMemberCode(paymentOrder.getMemberCode());
			detail.setMemberName(paymentOrder.getMemberName());
			detail.setChargingItemName(dogDnaArchiveFee.getName());
			paymentOrderDetailList.add(detail);
	    }
	    
		PaymentChargingItem dogBloodSaveItem = paymentChargingItemDao.getByShortName(RestDogChipService.BLOOD_SAVE_FEE_OEC);
		PaymentOrderDetail detail2 = new PaymentOrderDetail();
		detail2.setAddTime(paymentOrder.getAddTime());
		detail2.setProccessState("0");
		detail2.setTotalPrice(dogBloodSaveItem.getPrice());
		detail2.setNum("1");
		detail2.setPrice(dogBloodSaveItem.getPrice());
		detail2.setBusinessIds(dogBloodSave.getId());
		detail2.setBusinessTable("dog_blood_save");
		detail2.setChargingItemId(dogBloodSaveItem.getId());
		detail2.setMemberCode(paymentOrder.getMemberCode());
		detail2.setMemberName(paymentOrder.getMemberName());
		detail2.setChargingItemName(dogBloodSaveItem.getName());
		paymentOrderDetailList.add(detail2);
		
		PaymentChargingItem dogChipNoseItem = paymentChargingItemDao.getByShortName(RestDogChipService.NOSE_LINE);
		PaymentOrderDetail detail3 = new PaymentOrderDetail();
		detail3.setAddTime(paymentOrder.getAddTime());
		detail3.setProccessState("0");
		detail3.setTotalPrice(dogChipNoseItem.getPrice());
		detail3.setNum("1");
		detail3.setPrice(dogChipNoseItem.getPrice());
		detail3.setBusinessIds(null);
		detail3.setBusinessTable(null);
		detail3.setChargingItemId(dogChipNoseItem.getId());
		detail3.setMemberCode(paymentOrder.getMemberCode());
		detail3.setMemberName(paymentOrder.getMemberName());
		detail3.setChargingItemName(dogChipNoseItem.getName());
		paymentOrderDetailList.add(detail3);
		return paymentOrderDetailList;
	}
	/**
	 * 构建芯片订单详情
	 * @param
	 * @return
	 */
	@Transactional(readOnly = false)
	public List<PaymentOrderDetail> buildChipPaymentOrderDetailList(DogChipChange dogChipChange,PaymentOrder paymentOrder) {
		PaymentChargingItem chipFee = paymentChargingItemDao.getByShortName(CHIP_FEE);
		PaymentChargingItem chipServiceFee = paymentChargingItemDao.getByShortName(CHIP_SERVICE_FEE);
		List<PaymentOrderDetail> paymentOrderDetailList = new ArrayList<PaymentOrderDetail>();
		//芯片订单
		PaymentOrderDetail detail1 = new PaymentOrderDetail();
		detail1.setAddTime(paymentOrder.getAddTime());
		detail1.setProccessState("0");
		detail1.setTotalPrice(chipFee.getPrice());
		detail1.setNum("1");
		detail1.setPrice(chipFee.getPrice());
		detail1.setBusinessIds(dogChipChange.getId());
		detail1.setBusinessTable("dog_chip_change");
		detail1.setChargingItemId(chipFee.getId());
		detail1.setMemberCode(paymentOrder.getMemberCode());
		detail1.setMemberName(paymentOrder.getMemberName());
		detail1.setChargingItemName(chipFee.getName());
		paymentOrderDetailList.add(detail1);

		PaymentOrderDetail detail2 = new PaymentOrderDetail();
		detail2.setAddTime(paymentOrder.getAddTime());
		detail2.setProccessState("0");
		detail2.setTotalPrice(chipServiceFee.getPrice());
		detail2.setNum("1");
		detail2.setPrice(chipServiceFee.getPrice());
		detail2.setChargingItemId(chipServiceFee.getId());
		detail2.setMemberCode(paymentOrder.getMemberCode());
		detail2.setMemberName(paymentOrder.getMemberName());
		detail2.setChargingItemName(chipServiceFee.getName());
		paymentOrderDetailList.add(detail2);
		return paymentOrderDetailList;
	}

	/**
	 * 构建订单基本信息
	 * @return
	 */
	@Transactional(readOnly = false)
	public PaymentOrder buildPaymentOrder(String memberCode,String name,String way) {
		PaymentOrder order = new PaymentOrder();
		order.setPaymentWay(way);
		order.setMemberCode(memberCode);
		order.setMemberName(name);
		order.setAddTime(new Date());
		return order;
	}

}
