package com.cku.oa.trainschool.web;

import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.oa.trainschool.entity.GroomerSchoolMail;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.GroomerSchoolMailService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 美容学校邮寄Controller
 *
 * @author 赖广龙
 * @version 2017-06-20
 */
@Controller
@RequestMapping(value = "${adminPath}/trainschool/groomerSchoolMail")
public class GroomerSchoolMailController extends BaseController {

    @Autowired
    private GroomerSchoolMailService groomerSchoolMailService;
    @Autowired
    private TrainingInstitutionDao trainingInstitutionDao;

    private final static String REPAGE = "redirect:"+Global.getAdminPath()+"/trainschool/groomerSchoolMail/?repage&schoolId=";

    private final static String AUTHORITY_PRDFIX = "trainschool:groomer:";

    @ModelAttribute
    public GroomerSchoolMail get(@RequestParam(required = false) String id) {
        GroomerSchoolMail entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = groomerSchoolMailService.get(id);
        }
        if (entity == null) {
            entity = new GroomerSchoolMail();
        }
        return entity;
    }

    @RequiresPermissions(AUTHORITY_PRDFIX+"view")
    @RequestMapping(value = {"list", ""})
    public String list(GroomerSchoolMail groomerSchoolMail, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<GroomerSchoolMail> page = groomerSchoolMailService.findPage(new Page<GroomerSchoolMail>(request, response), groomerSchoolMail);
        model.addAttribute("page", page);
        return "oa/trainschool/groomerSchoolMailList";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX+"view")
    @RequestMapping(value = "form")
    public String form(GroomerSchoolMail groomerSchoolMail, Model model) {
        model.addAttribute("groomerSchoolMail", groomerSchoolMail);
        TrainingInstitution trainingInstitution = trainingInstitutionDao.get(groomerSchoolMail.getSchoolId());
        model.addAttribute("trainingInstitution", trainingInstitution);
        return "oa/trainschool/groomerSchoolMailForm";
    }

    @RequiresPermissions(AUTHORITY_PRDFIX+"edit")
    @RequestMapping(value = "save")
    public String save(GroomerSchoolMail groomerSchoolMail, Model model, RedirectAttributes redirectAttributes) {
        if (!beanValidator(model, groomerSchoolMail)) {
            return form(groomerSchoolMail, model);
        }
        groomerSchoolMailService.save(groomerSchoolMail);
        addMessage(redirectAttributes, "保存美容学校邮寄成功");
        return REPAGE+groomerSchoolMail.getSchoolId();
    }

    @RequiresPermissions(AUTHORITY_PRDFIX+"edit")
    @RequestMapping(value = "delete")
    public String delete(GroomerSchoolMail groomerSchoolMail, RedirectAttributes redirectAttributes) {
        groomerSchoolMailService.delete(groomerSchoolMail);
        addMessage(redirectAttributes, "删除美容学校邮寄成功");
        return REPAGE+groomerSchoolMail.getSchoolId();
    }

}