package com.cku.oa.timedtask.service;

import java.util.Objects;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.cku.oa.sys.util.ZtSmsUtil;
import com.cku.restful.v1.sys.model.OCRAccountInfo;
import com.cku.restful.v1.sys.model.OCRResult;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.thinkgem.jeesite.common.utils.SendMailUtil;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.Dict;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import edu.emory.mathcs.backport.java.util.Arrays;

@Service
@Transactional(readOnly = true)
public class RemainOCRCountQueryTask extends JobActingService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private RestIDCardService idCardService;

	@Transactional(readOnly = false)
	int doJob() {
		return queryOCRRemainder();
	}

	@Override
	@Transactional(readOnly = false)
	public int executeOnce() {
		SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
		return queryOCRRemainder();
	}

	private final static String OCR_REMAINDER_CONFIG = "OCR_REMAINDER_CONFIG";
	
	private final static String CONFIG_EMAIL = "email";
	
	private final static String CONFIG_MOBILE = "mobile";
	
	@SuppressWarnings("unchecked")
	private int queryOCRRemainder() {
		
		Dict dEmail = DictUtils.getDict(CONFIG_EMAIL,OCR_REMAINDER_CONFIG, null);
		Dict dMobile = DictUtils.getDict(CONFIG_MOBILE,OCR_REMAINDER_CONFIG, null);
		
		if(Objects.isNull(dEmail) && Objects.isNull(dMobile)) {
			return 0;
		}
		OCRResult result = idCardService.queryOCRRemainder();
		String subject = "翔云OCR实名认证余数结果";
		String content = result.toString();
		// 日常查询发送邮件
		if(Objects.nonNull(dEmail) && StringUtils.isNotEmpty(dEmail.getDescription())) {
			String[] emailArr = dEmail.getDescription().split(",");
			Arrays.asList(emailArr).forEach(email->{
				SendMailUtil.sendCommonMail(email.toString(), subject, content);
			});
			
		}
		// 预警查询同时发送短信
		if (Objects.nonNull(result.getMessage()) && 0 == result.getMessage().getStatus()
				&& CollectionUtils.isNotEmpty(result.getAccountinfo())) {
			OCRAccountInfo accountInfo = result.getAccountinfo().stream()
					.filter(info -> "身份证号实名认证增强版".equals(info.getDesc())).findAny().orElse(null);
			if (StringUtils.isNotEmpty(accountInfo.getContent())) {
				try {
					Integer remainder = Integer.parseInt(accountInfo.getContent());
					if (remainder <= 1000) {
						// 短信发送查询结果
						if(Objects.nonNull(dMobile) && StringUtils.isNotEmpty(dMobile.getDescription())) {
							String[] mobileArr = dMobile.getDescription().split(",");
							Arrays.asList(mobileArr).forEach(mobile->{
								ZtSmsUtil.sendNote(content, mobile.toString());
							});
						}
					}
				} catch (Exception ex) {
					logger.error("格式化身份证号实名认证增强版剩余条数失败，原值：" + content, ex);
				}
			}
		}
		return result.getMessage().getStatus();
	}
}