package com.cku.oa.sys.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.sys.entity.Appraiser;
import com.cku.oa.sys.entity.AppraiserPrint;
import com.cku.oa.sys.service.AppraiserService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 鉴定师表Controller
 * @author zhangjunwu
 * @version 2019-10-16
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/appraiser")
public class AppraiserController extends BaseController {

	@Autowired
	private AppraiserService appraiserService;
	
	@ModelAttribute
	public Appraiser get(@RequestParam(required=false) String id) {
		Appraiser entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = appraiserService.get(id);
		}
		if (entity == null){
			entity = new Appraiser();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:appraiser:view")
	@RequestMapping(value = {"list", ""})
	public String list(Appraiser appraiser, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<Appraiser> page = appraiserService.findPage(new Page<Appraiser>(request, response), appraiser); 
		model.addAttribute("page", page);
		return "oa/sys/appraiserList";
	}

	@RequiresPermissions("sys:appraiser:view")
	@RequestMapping(value = "form")
	public String form(Appraiser appraiser, Model model) {
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(appraiser.getProvince()));
		model.addAttribute("appraiser", appraiser);
		return "oa/sys/appraiserForm";
	}
	
	@RequiresPermissions("sys:appraiser:view")
	@RequestMapping(value = "view")
	public String view(Appraiser appraiser, Model model) {
		model.addAttribute("province",UserUtils.getProvince());
		model.addAttribute("city",UserUtils.getCityByProvince(appraiser.getProvince()));
		model.addAttribute("appraiser", appraiser);
		return "oa/sys/appraiserView";
	}

	@RequiresPermissions("sys:appraiser:edit")
	@RequestMapping(value = "save")
	public String save(Appraiser appraiser, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, appraiser)){
			return form(appraiser, model);
		}
		appraiserService.save(appraiser);
		addMessage(redirectAttributes, "保存认证师成功");
		return "redirect:"+Global.getAdminPath()+"/sys/appraiser/?repage";
	}
	
	@RequiresPermissions("sys:appraiser:edit")
	@RequestMapping(value = "delete")
	public String delete(Appraiser appraiser, RedirectAttributes redirectAttributes) {
		appraiserService.delete(appraiser);
		addMessage(redirectAttributes, "删除认证师成功");
		return "redirect:"+Global.getAdminPath()+"/sys/appraiser/?repage";
	}
	
	@RequestMapping(value = "print")
	public String print(Appraiser appraiser, Model model) {
		appraiserService.updatePrintFlag(appraiser.getId(),"1");
		AppraiserPrint entity = appraiserService.print(appraiser.getId());
		model.addAttribute("appraiser", entity);
		return "oa/sys/appraiserCertificatePrint";
	}
	
	@RequestMapping(value = "resetPrint")
	public String resetPrint(Appraiser appraiser, RedirectAttributes redirectAttributes) {
		appraiserService.updatePrintFlag(appraiser.getId(), "0");
		addMessage(redirectAttributes, "重置打印成功");
		return "redirect:"+Global.getAdminPath()+"/sys/appraiser/?repage";
	}

}