package com.cku.oa.sys.util;

import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_BIND_MOBILE;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_BIND_RENEWALS;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_BIND_USER;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_CHANGE_MOBILE;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_DOG_SPORTING_MEMBER;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_REGISTER;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_RESET_PASSWORD;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_GOLD_CERTIFIED_APPLY_AUDIT;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cku.util.MD5Generator;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 短信发送功能模块
 *
 * fanhuibin 优化
 * 
 * @author yueyang
 */
public class ZtSmsUtil {
	private static Logger logger = LoggerFactory.getLogger(ZtSmsUtil.class);
	public static final String SMS_LEFT = "尊敬的会员，";
	private static final String SMS_RIGHT = "【宠爱王国】";
	private static final String SMS_UN_SUBSCRIBE = "拒收请回复R";

	private static final String sendUrl = "http://api.mix2.zthysms.com/v2/sendSms";
	private static final String usernameHY = "chongaihy";
	private static final String passwordHY = "136jr64H";
	private static final String usernameYX = "chongaiyx";
	private static final String passwordYX = "s12RE0tt";

	private static final int TYPE_HY = 1;
	private static final int TYPE_YX = 2;

	public static String getUrl(String param) {
		PrintWriter out = null;
		BufferedReader in = null;
		String result = "";
		try {
			URL realUrl = new URL(sendUrl);
			// 打开和URL之间的连接
			URLConnection conn = realUrl.openConnection();
			// 设置通用的请求属性
			conn.setRequestProperty("accept", "*/*");
			conn.setRequestProperty("connection", "Keep-Alive");
			conn.setRequestProperty("content-type", "application/json");
			conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			// 发送POST请求必须设置如下两行
			conn.setDoOutput(true);
			conn.setDoInput(true);
			// 设置相应请求时间
			conn.setConnectTimeout(30000);
			// 设置读取超时时间
			conn.setReadTimeout(30000);
			// 获取URLConnection对象对应的输出流
			out = new PrintWriter(conn.getOutputStream());
			// 发送请求参数
			out.print(param);
			// flush输出流的缓冲
			out.flush();
			// 定义BufferedReader输入流来读取URL的响应
			in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
			String line;
			while ((line = in.readLine()) != null) {
				result += line;
			}
		} catch (Exception e) {
			e.printStackTrace();
			// System.out.println(e);
			// return "发送 POST 请求出现异常！";
		}
		// 使用finally块来关闭输出流、输入流
		finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null) {
					in.close();
				}
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
		logger.info("send sms result:{}", result);
		return result;
	}

	/**
	 * @Description： 发送通知类短信
	 * 
	 * @author: yuanshuai
	 * @date: 2018/1/19 11:29
	 */
	public static String sendNote(String content, String mobile) {
		content = SMS_LEFT + content + SMS_RIGHT;
		String sendParam = buildSendParam(mobile, content, TYPE_HY);
		logger.info("sms sendParam {}", sendParam);
		return StringUtils.isBlank(sendParam) ? null : getUrl(sendParam);
	}

	/**
	 * @Description： 发送营销类短信
	 * 
	 * @author: yuanshuai
	 * @date: 2018/1/19 11:29
	 */
	public static String sendNoteYX(String content, String mobile) {
		content = content + SMS_UN_SUBSCRIBE + SMS_RIGHT;
		String sendParam = buildSendParam(mobile, content, TYPE_YX);
		logger.info("sms sendParam {}", sendParam);
		return StringUtils.isBlank(sendParam) ? null : getUrl(sendParam);
	}

	/**
	 *
	 * @Description：注册宠爱王国账号使用的发送验证码方法
	 * @author: zhuoHeng
	 * @version: 2017年5月22日 上午11:01:50
	 */
	public static String sendVerificationCode(String content, String mobile, String type) {
		if (TYPE_SMS_REGISTER.equals(type)) {
			content = SMS_LEFT + "您注册宠爱王国账号的会员业务在线申请的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (TYPE_SMS_BIND_USER.equals(type)) {
			content = SMS_LEFT + "您在线办理的宠爱王国账户绑定服务的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (TYPE_SMS_RESET_PASSWORD.equals(type)) {
			content = SMS_LEFT + "您在线办理的找回密码服务的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (type.startsWith(TYPE_SMS_CHANGE_MOBILE)) {
			content = SMS_LEFT + "您在线办理的手机号换绑服务的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (TYPE_SMS_BIND_MOBILE.equals(type)) {
			content = SMS_LEFT + "您在线办理的手机号绑定服务的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (TYPE_SMS_BIND_RENEWALS.equals(type)) {
			content = SMS_LEFT + "您在线办理的会员续费服务的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (TYPE_SMS_DOG_SPORTING_MEMBER.equals(type)) {
			content = SMS_LEFT + "您在线查询犬运动会员身份信息的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		} else if (TYPE_SMS_GOLD_CERTIFIED_APPLY_AUDIT.equals(type)) {
			content = SMS_LEFT + "您正在办理金质证书业务，验证码是" + content + "，用于审核金质证书办理。涉及个人权益，请勿向他人泄露。" + SMS_RIGHT;
		} 
		
		logger.info("sms content {}", content);
		String sendParam = buildSendParam(mobile, content, TYPE_HY);
		logger.info("ztsms param:{}", sendParam);
		return StringUtils.isBlank(sendParam) ? null : getUrl(sendParam);
	}

	public static String sendNoseVerificationCode(String content, String mobile, String type) {
		content = SMS_LEFT + "您注册宠爱王国账号的会员业务在线申请的短信验证码为" + content + ",请输入后继续操作" + SMS_RIGHT;
		String sendParam = buildNoseSendParam(mobile, content, TYPE_HY);
		logger.info("ztsms param:{}", sendParam);
		return StringUtils.isBlank(sendParam) ? null : getUrl(sendParam);
	}

	private static String buildNoseSendParam(String mobile, String content, int type) {
		logger.info("build send param mobile:{},content:{},type:{},devMode:{}", mobile, content, type,
				Global.getConfig("mode"));
		String param;
		if (mobile.length() != 11) {
			logger.debug("手机号码不正确发送失败");
			return "";
		}
		try {
			String tKey = String.valueOf(new Date().getTime()).substring(0, 10);
			String username = null;
			String password = null;
			switch (type) {
			case TYPE_HY:
				username = usernameHY;
				password = passwordHY;
				break;
			case TYPE_YX:
				username = usernameYX;
				password = passwordYX;
				break;
			}
			param = "{" + "\"content\":\"" + content + "\"," + "\"mobile\":\"" + mobile + "\"," + "\"tKey\":\"" + tKey
					+ "\"," + "\"username\":\"" + username + "\"," + "\"password\":\""
					+ MD5Generator.generate(MD5Generator.generate(password) + tKey) + "\"" + "}";

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return param;
	}

	/**
	 * @Description： 根据手机号和内容构建发送的url
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/13 17:01
	 */
	private static String buildSendParam(String mobile, String content, int type) {
		logger.info("build send param mobile:{},content:{},type:{},devMode:{}", mobile, content, type,
				Global.getConfig("mode"));
		String param;
		if (!ZtSmsUtil.validateSmsWhiteList(mobile)) {
			// 如果当前的项目运行模式是开发环境，短信不能发送
			logger.debug("短信发送失败，开发模式不能发送短信");
			return "";
		}
		if (mobile.length() != 11) {
			logger.debug("手机号码不正确发送失败");
			return "";
		}
		try {
			String tKey = String.valueOf(new Date().getTime()).substring(0, 10);
			String username = null;
			String password = null;
			switch (type) {
			case TYPE_HY:
				username = usernameHY;
				password = passwordHY;
				break;
			case TYPE_YX:
				username = usernameYX;
				password = passwordYX;
				break;
			}
			param = "{" + "\"content\":\"" + content + "\"," + "\"mobile\":\"" + mobile + "\"," + "\"tKey\":\"" + tKey
					+ "\"," + "\"username\":\"" + username + "\"," + "\"password\":\""
					+ MD5Generator.generate(MD5Generator.generate(password) + tKey) + "\"" + "}";

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
		return param;
	}

	public static boolean validateSmsWhiteList(String mobile) {
		if (Global.isProductMode()) {
			return Boolean.TRUE;
		} else if (Global.isDevMode() && (mobile.equals("18515039553")// 刘慧敏
				|| mobile.equals("18810669468")// 袁帅
				|| mobile.equals("18510488680")// 徐雪
				|| mobile.equals("15811560827")// 朱云飞
				|| mobile.equals("13911284656")// 甘甘
				|| mobile.equals("15652191645")// 张君武
				|| mobile.equals("15652388352")// 赵雪园
				|| mobile.equals("18210926268")// 吴林山
				|| mobile.equals("13811147975")// 测试机
		)) {
			// 如果当前的项目运行模式是开发环境，以上短信可以发送
			return Boolean.TRUE;
		}
		return Boolean.FALSE;
	}

}
