package com.cku.oa.sys.service.user;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.activity.dao.SysMemberActivityRecordDao;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.finance.dao.PaymentChargingItemDao;
import com.cku.oa.finance.dao.PaymentChargingItemGroupDao;
import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.dao.PaymentOrderDetailDao;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentChargingItemGroup;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.entity.SysCouponDef;
import com.cku.oa.sys.coupon.service.SysCouponDefService;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.utils.IdGen;

@Service
@Transactional(readOnly = true)
public class MemberActivity20201212Discount {

	@Autowired
	public MemberDao memberDao;

	@Autowired
	public KennelDao kennelDao;

	@Autowired
	private SysMemberActivityRecordDao sysMemberActivityRecordDao;

	@Autowired
	private PaymentOrderDetailDao paymentOrderDetailDao;

	@Autowired
	private PaymentOrderDao paymentOrderDao;

	@Autowired
	private PaymentChargingItemGroupDao paymentChargingItemGroupDao;

	@Autowired
	private PaymentChargingItemDao paymentChargingItemDao;

	@Autowired
	private SysCouponDefService sysCouponDefService;

	@Autowired
	private SysCouponService sysCouponService;

	@Autowired
	private PaymentCartService paymentCartService;

	private SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");

	private static final String SYS_MEMBER_DISCOUNT = "sys_member@discount";// 2020-12-10至2020-12-31
	// 双十二续费活动专用优惠

	// 2020双十二活动
	public static final String yearEndPromotion2020Start = "2020-12-12";
	public static final String yearEndPromotion2020End = "2020-12-31";

	// 支付后落实优惠
	@Transactional(readOnly = false)
	public void build20201212Discount(SysMemberActivityRecord record, String couponDefId, Member member) {
		// 在活动时间内才能计入优惠
		if (!LocalDate.now().isBefore(LocalDate.parse(yearEndPromotion2020Start))
				&& !LocalDate.now().isAfter(LocalDate.parse(yearEndPromotion2020End))
				&& isFirst20201212ActivityRecord(member.getMemberCode(), record.getOrderCode()) // 第一次参加
		) {
			// 1 核准赠送月份和优惠金额
			PaymentChargingItemGroup paymentChargingItemGroup = paymentChargingItemGroupDao
					.get(record.getActivityType());
			if (paymentChargingItemGroup != null && (StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion1())
					|| StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion2()))) {
				record.setGiveMonth(paymentChargingItemGroup.getExpansion2());
				record.setPreferentialAmount(paymentChargingItemGroup.getExpansion1());
			}
			// 2 赠送月份
			if (StringUtils.isNotBlank(record.getGiveMonth()) && Integer.valueOf(record.getGiveMonth()) > 0) {
				record.setPreferentialWay("1");// 优惠方式：1:赠送时间，2:返券，3:减免金额
				Calendar newMemberEndDate = Calendar.getInstance();
				newMemberEndDate.setTime(member.getMemberEndDate());
				newMemberEndDate.add(Calendar.MONTH, Integer.valueOf(record.getGiveMonth()));
				record.setNewMemberEndDate(newMemberEndDate.getTime());
				memberDao.updateEndDateById(member.getId(), dateformat.format(newMemberEndDate.getTime()));
				if (member.getKennel() != null && !"permanent".equals(member.getKennel().getType())
						&& member.getKennel().getEndTime() != null) {
					newMemberEndDate.setTime(member.getKennel().getEndTime());
					newMemberEndDate.add(Calendar.MONTH, Integer.valueOf(record.getGiveMonth()));
					record.setNewKennelEndDate(newMemberEndDate.getTime());
					kennelDao.updateKennelEndDateById(member.getKennel().getId(),
							dateformat.format(newMemberEndDate.getTime()));
				}
			}
			// 3 本会员优惠券
			if (StringUtils.isNotBlank(couponDefId) && ((StringUtils.isNotBlank(record.getPreferentialAmount())
					&& new BigDecimal(record.getPreferentialAmount()).compareTo(BigDecimal.ZERO) > 0)
					|| (StringUtils.isNotBlank(record.getGiveMonth()) && Integer.valueOf(record.getGiveMonth()) > 0))) {
				SysCouponDef sysCouponDef = sysCouponDefService.get(couponDefId);
				if (sysCouponDef != null) {
					boolean flag = true;
					if (sysCouponDef.getNum() != null) {// 是否还有优惠券
						String[] ids = { couponDefId };
						List<SysCoupon> sl = sysCouponService.getListByCouponDefId(ids);
						if (sl.size() >= sysCouponDef.getNum())
							flag = false;
					}
					if (flag) {
						Calendar calendar = Calendar.getInstance();
						if (sysCouponDef.getEffectiveDate() != null) {
							calendar.setTime(sysCouponDef.getEffectiveDate());// 设置日期起始时间
							calendar.add(Calendar.DAY_OF_MONTH, -1);
						}
						Date validDate = null;
						if (sysCouponDef.getValidDate() != null) {
							validDate = sysCouponDef.getValidDate();
						} else {
							calendar.add(Calendar.MONTH, sysCouponDef.getEffectivePeriod());
							validDate = calendar.getTime();
						}
						sysCouponService.saveCoupon(member.getMemberCode(), sysCouponDef.getCouponName(),
								sysCouponDef.getFacePrice(), validDate, sysCouponDef.getEffectiveDate(),
								sysCouponDef.getTarget(), "", sysCouponDef.getExplains(), 1,
								sysCouponDef.getCouponType(), sysCouponDef.getId());
						record.setPreferentialWay(StringUtils.isBlank(record.getPreferentialWay()) ? "2"
								: record.getPreferentialWay() + "2");// 优惠方式：1:赠送时间，2:返券，3:减免金额
						record.setCouponAmount(sysCouponDef.getFacePrice());
					}
				}
			}
			if (StringUtils.isNotBlank(record.getPreferentialAmount())
					&& new BigDecimal(record.getPreferentialAmount()).compareTo(BigDecimal.ZERO) > 0) {
				record.setPreferentialWay(
						StringUtils.isBlank(record.getPreferentialWay()) ? "3" : record.getPreferentialWay() + "3");// 优惠方式：1:赠送时间，2:返券，3:减免金额
			}
			// 4 推荐人优惠券
			// CKU所有有效会员（普卡除外），邀请铂金/紫金会员成功注册后，新会员享50元代金券、老会员享100元代金券（可用于办理会员繁殖类业务，有效期截至2020年3月31日）
			Date startDate = null;
			try {
				startDate = dateformat.parse(yearEndPromotion2020Start);
			} catch (ParseException e) {
				e.printStackTrace();
			}
			if (StringUtils.isNotBlank(member.getReferee())
					&& ("9992030".equals(record.getActivityType()) || "9991009102030".equals(record.getActivityType())
							|| "9991009122030".equals(record.getActivityType())
							|| "9992040".equals(record.getActivityType())
							|| "9991009102040".equals(record.getActivityType())
							|| "9991009122040".equals(record.getActivityType()))
					&& !member.getCreateDate().before(startDate)) {
				Member referee = memberDao.getByMemberCode(member.getReferee());
				if (referee != null && referee.getMemberEndDate() != null
						&& !referee.getMemberEndDate().before(new Date())) {
					Date validDate = null;
					try {
						validDate = dateformat.parse("2021-03-31");
					} catch (ParseException e) {
						e.printStackTrace();
					}
					sysCouponService.saveCoupon(member.getReferee(), "代金券", "100", validDate, new Date(), "memberdog",
							null, "限办理CKU会员业务、繁殖业务使用", 1, "1", null);
					sysCouponService.saveCoupon(member.getMemberCode(), "代金券", "50", validDate, new Date(), "memberdog",
							null, "限办理CKU会员业务、繁殖业务使用", 1, "1", null);
					record.setPreferentialWay(StringUtils.isBlank(record.getPreferentialWay()) ? "3"
							: record.getPreferentialWay().contains("3") ? record.getPreferentialWay()
									: record.getPreferentialWay() + "3");
					record.setReferee(member.getReferee());
				}
			}
			if (!"0".equals(record.getPreferentialWay()) && record.getPreferentialWay() != null)
				record.setPreferentialWay(record.getPreferentialWay().replace("0", ""));
		}

	}

	// 美容赠送月份
	@Transactional(readOnly = false)
	public void buildGroomer20201212Discount(PaymentOrder paymentOrder) {
		// 在活动时间内才能计入优惠
		if (!LocalDate.now().isBefore(LocalDate.parse(yearEndPromotion2020Start))
				&& !LocalDate.now().isAfter(LocalDate.parse(yearEndPromotion2020End))) {
			List<PaymentOrderDetail> mrList = paymentOrder.getOrderDetailList().stream().filter(
					detail -> "105".equals(detail.getChargingItemId()) || "106".equals(detail.getChargingItemId()))
					.collect(Collectors.toList());
			if (mrList != null && mrList.size() == 1) {
				String memberCode = paymentOrder.getMemberCode();
				// 是否为代缴会员
				String beneficiary = this.getBeneficiary(paymentOrder.getOrderCode());
				if (StringUtils.isNotBlank(beneficiary)) {
					memberCode = beneficiary;
				}
				if (isFirst20201212GroomerActivityRecord(memberCode)) {
					Member member = memberDao.findMemberAndKennelByMemberCode(memberCode);
					SysMemberActivityRecord queryRecord = new SysMemberActivityRecord();
					queryRecord.setMemeberCode(memberCode);
					queryRecord.setOrderCode(paymentOrder.getOrderCode());
					SysMemberActivityRecord record = sysMemberActivityRecordDao.getOneEntity(queryRecord);
					if(record!=null) {
						record = new SysMemberActivityRecord();
						record.setActivityType("8088811");
						record.setGroomerType(member.getGroomerType());
						record.setMemberEndDate(member.getMemberEndDate());
						record.setNewMemberEndDate(member.getMemberEndDate());
						record.setMemberType(member.getMemberType());
						record.setMemeberCode(member.getMemberCode());
						record.setMemeberName(member.getName());
						if (member.getKennel() != null) {
							record.setKennelCode(member.getKennel().getKennelCode());
							record.setKennelEndDate(member.getKennel().getEndTime());
							record.setNewKennelEndDate(member.getKennel().getEndTime());
							record.setKennelName(member.getKennel().getName());
							record.setKennelType(member.getKennel().getType());
						}
						record.setCreateDate(new Date());
						record.setGiveGift("0");
						record.setOrderCode(paymentOrder.getOrderCode());
						record.setParticipationTime(new Date());
						record.setRecordType("2");
					}
					// 美容赠送月份
					Calendar newMemberEndDate = Calendar.getInstance();
					newMemberEndDate.setTime(member.getGroomerEndDate());
					if ("105".equals(mrList.get(0).getChargingItemId())) {
						record.setGiveMonth("2");
						newMemberEndDate.add(Calendar.MONTH, Integer.valueOf(record.getGiveMonth()));
					} else if ("106".equals(mrList.get(0).getChargingItemId())) {
						record.setGiveMonth("2");
						newMemberEndDate.add(Calendar.MONTH, Integer.valueOf(record.getGiveMonth()));
					}
					record.setNewGroomerEndDate(newMemberEndDate.getTime());
					record.setMemberCardType(member.getMemberCardType());
					if(record.getId()==null) {
						record.setId(IdGen.uuid());
						record.setCreateBy(paymentOrder.getCreateBy());
						sysMemberActivityRecordDao.insert(record);
					}else {
						sysMemberActivityRecordDao.update(record);
					}
					memberDao.updateGroomerEndDateById(member.getId(),
							dateformat.format(record.getNewGroomerEndDate()));
				}
			}
		}
	}

	private String getBeneficiary(String orderCode) {
		String memberCode = null;
		List<PaymentOrderDetail> orderList = paymentOrderDetailDao.findByOrderCode(orderCode);
		List<PaymentOrderDetail> orderListF = orderList.stream().filter(a -> "sys_member".equals(a.getBusinessTable()))
				.collect(Collectors.toList());
		if (orderListF != null && orderListF.size() > 0) {
			if (StringUtils.isNotBlank(orderListF.get(0).getBusinessIds())) {
				Member member = memberDao.get(orderListF.get(0).getBusinessIds());
				if (member != null) {
					memberCode = member.getMemberCode();
				}
			}
		}
		return memberCode;
	}

	// 美容优惠只能参加一次
	public boolean isFirst20201212GroomerActivityRecord(String memberCode) {
		List<SysMemberActivityRecord> promotions = sysMemberActivityRecordDao.selectGroomerPromotion(memberCode,
				yearEndPromotion2020Start, yearEndPromotion2020End);
		return promotions == null || promotions.size() == 0;
	}

	// 注册、续费奖、升级奖励仅可享受一次，获得奖励后再次办理业务均为原价办理
	public boolean isFirst20201212ActivityRecord(String memberCode, String orderCode) {
		List<SysMemberActivityRecord> promotions = sysMemberActivityRecordDao.selectPromotion(memberCode, orderCode,
				yearEndPromotion2020Start, yearEndPromotion2020End);
		return promotions == null || promotions.size() == 0;
	}

	// 只针对血统证书新增会员
	public void buildDogChip20201212Discount(String businessOrderCode, StringBuilder cartIds,
			SysMemberActivityRecord record) {
		// 在活动时间内才能计入优惠
		if (!LocalDate.now().isBefore(LocalDate.parse(yearEndPromotion2020Start))
				&& !LocalDate.now().isAfter(LocalDate.parse(yearEndPromotion2020End))
				&& isFirst20201212ActivityRecord(record.getMemeberCode(), null) // 第一次参加
				&& StringUtils.isNotBlank(record.getMemeberCode())
				&& StringUtils.isNotBlank(record.getActivityType())) {
			PaymentChargingItemGroup paymentChargingItemGroup = paymentChargingItemGroupDao
					.get(record.getActivityType());
			// 如果配置了优惠，才进入双十二特殊判断
			if (paymentChargingItemGroup != null && (StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion1())
					|| StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion2()))) {
				PaymentChargingItem discount = paymentChargingItemDao.selectByShortName(SYS_MEMBER_DISCOUNT);
				// 金额优惠
				if (StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion1())) {
					// 20年双十二优惠收费项
					if (discount == null) {
						throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "20年双十二续费优惠项缺失！");
					}
					// 加购
					PaymentCart paymentCart = new PaymentCart();
					paymentCart.setChargingItemId(discount.getId());
					paymentCart.setChargingItemName(discount.getName());
					paymentCart.setNum("1");
					paymentCart.setPrice("-" + paymentChargingItemGroup.getExpansion1());
					paymentCart.setTotalPrice("-" + paymentChargingItemGroup.getExpansion1());
					paymentCart.setBusinessTable("sys_member");
					paymentCart.setBusinessIds(memberDao.getByMemberCode(record.getMemeberCode()).getId());
					paymentCart.setBusinessOrderCode(businessOrderCode);
					paymentCartService.addToCart(paymentCart, "1021");
					cartIds.append(",").append(paymentCart.getId());
				}
				// 记录
				record.setCouponAmount(discount.getPrice().replace("-", ""));
				record.setGiveMonth(paymentChargingItemGroup.getExpansion2());
			}
		}
	}

	// 只针对血统证书新增会员
	public void buildDogChip20201212Discount2(String orderId) {
		PaymentOrder order = paymentOrderDao.get(orderId);
		if (order != null) {
			List<PaymentOrderDetail> orderList = paymentOrderDetailDao.findByOrderCode(order.getOrderCode());
			List<PaymentOrderDetail> orderListF = orderList.stream()
					.filter(a -> "sys_member".equals(a.getBusinessTable())).collect(Collectors.toList());
			if (orderListF != null && orderListF.size() > 0
					&& StringUtils.isNotBlank(orderListF.get(0).getBusinessOrderCode())) {
				String[] strs = orderListF.get(0).getBusinessOrderCode().split("-");
				if (strs.length == 2) {
					SysMemberActivityRecord record = sysMemberActivityRecordDao.getOneByOrderCode(strs[1]);
					if (record != null) {
						record.setOrderCode(order.getOrderCode());
						sysMemberActivityRecordDao.update(record);
					}
				}
			}
		}
	}

	// 续费会员获得优惠收费项
	public PaymentChargingItem get20201212Discount(String groupId, String memberCode) {
		// 在活动时间内才能计入优惠
		if (!LocalDate.now().isBefore(LocalDate.parse(yearEndPromotion2020Start))
				&& !LocalDate.now().isAfter(LocalDate.parse(yearEndPromotion2020End))
				&& isFirst20201212ActivityRecord(memberCode, null)) {
			PaymentChargingItemGroup paymentChargingItemGroup = paymentChargingItemGroupDao.get(groupId);
			// 如果配置了优惠，才进入双十二特殊判断
			if (paymentChargingItemGroup != null && (StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion1())
					|| StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion2()))) {
				// 20年双十二优惠收费项
				PaymentChargingItem memberDiscount = paymentChargingItemDao.selectByShortName(SYS_MEMBER_DISCOUNT);
				if (memberDiscount == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "20年双十二续费优惠项缺失！");
				}
				if (StringUtils.isNoneBlank(paymentChargingItemGroup.getExpansion1())) {
					memberDiscount.setPrice("-" + paymentChargingItemGroup.getExpansion1());
					return memberDiscount;
				}
			}
		}
		return null;
	}

}
