/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.service;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.sys.dao.LoginServerDao;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 文件模块Service
 *
 * @author rain
 * @version 2015-12-18
 */
@Service
@Transactional(readOnly = false)
public class LoginServerService extends CrudService<LoginServerDao, LoginServer> {

	@Autowired
	private LoginServerDao loginServerDao;

	/**
	 * @Description : 根据当前登录端查询业务判断犬种
	 * @param member
	 * @return
	 */
	public String validDogType(Dog dog) {
		Member po = UserUtils.getLoginMember();
		LoginServer loginServer = loginServerDao.getByUserType(po.getUser().getUserType());
		if (loginServer != null) {
			if (loginServer.getDogType().equals(dog.getDogBreed()) && "1".equals(loginServer.getIsSupport())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号!");
			}
			if (!loginServer.getDogType().equals(dog.getDogBreed()) && "0".equals(loginServer.getIsSupport())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号!");
			}
			if (!((StringUtils.isBlank(loginServer.getMemberSite()) && StringUtils.isBlank(dog.getDogOwnerSite()))
					|| (loginServer.getMemberSite() == null ? "" : loginServer.getMemberSite())
							.equals(dog.getDogOwnerSite()))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号!");
			}
			return loginServer.getDogType();
		}
		return null;
	}

	/**
	 * @Description : 根据当前登录端查询可使用的犬种
	 * @param member
	 * @return
	 */
	public String findDogType() {
		User loginUser = UserUtils.getLoginUser();
		LoginServer loginServer = loginServerDao.getByUserType(loginUser.getUserType());
		if (loginServer != null) {
			if ("1".equals(loginServer.getIsSupport())) {
				return "!" + loginServer.getDogType();
			}
			return loginServer.getDogType();
		}
		return null;
	}

	/**
	 * @Description : 根据当前登录端及登记卡判断犬种类型
	 * @param member
	 * @return
	 */
	public String validBirthDogType(DogBirthCertificate dogBirthCertificate,Member member) {
		LoginServer loginServer = loginServerDao.getByUserType(member.getUser().getUserType());
		if (loginServer != null) {
			if (loginServer.getDogType().equals(dogBirthCertificate.getDogBreed())
					&& "1".equals(loginServer.getIsSupport())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的登记卡编号!");
			}
			if (!loginServer.getDogType().equals(dogBirthCertificate.getDogBreed())
					&& "0".equals(loginServer.getIsSupport())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的登记卡编号!");
			}
			if (!((StringUtils.isBlank(loginServer.getMemberSite())
					&& StringUtils.isBlank(dogBirthCertificate.getDogOwnerSite()))
					|| (loginServer.getMemberSite() == null ? "" : loginServer.getMemberSite())
					.equals(dogBirthCertificate.getDogOwnerSite()))) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的登记卡编号!");
			}
			return loginServer.getDogType();
		}
		return null;
	}

	/**
	 * @Description : 根据当前登录端及登记卡判断犬种类型
	 * @return
	 */
	public String validBirthDogType(DogBirthCertificate dogBirthCertificate) {
		Member member = UserUtils.getLoginMember();
		return validBirthDogType(dogBirthCertificate, member);
	}

	/**
	 * @Description : 根据当前登录端查询列表可显示的犬种
	 * @return
	 */
	public String dataScopeFilter() {
		StringBuilder sb = new StringBuilder();
		User loginUser;
		try {
			loginUser = UserUtils.getLoginUser();
		} catch (ZAException e) {
			loginUser = new User();
			loginUser.setUserType("2");
		}
		LoginServer loginServer = loginServerDao.getByUserType(loginUser.getUserType());
		if (loginServer == null) {
			return null;
		} else {
			String dogType = loginServer.getDogType();
			if ("1".equals(loginServer.getIsSupport())) {// 不支持的犬种
				if (dogType.contains(",")) {// 多种犬种
					sb.append(" NOT IN (");
					String[] split = dogType.split(",");
					for (int i = 0; i < split.length; i++) {
						sb.append("'" + split[i] + "',");
					}
					sb.deleteCharAt(sb.length() - 1);
					sb.append(")");
				} else {
					sb.append(" !='" + dogType + "'");
				}
			} else {// 支持的犬种
				if (dogType.contains(",")) {// 多种犬种
					sb.append(" IN (");
					String[] split = dogType.split(",");
					for (int i = 0; i < split.length; i++) {
						sb.append("'" + split[i] + "',");
					}
					sb.deleteCharAt(sb.length() - 1);
					sb.append(")");
				} else {
					sb.append(" ='" + dogType + "'");
				}
			}
			return sb.toString();
		}
	}

	/**
	 * @Description 根据userType 查询是否可绑定会员
	 * @author chaixueteng
	 * @param u
	 * @param m
	 */
	public void validUserBind(User u, Member m) {
		LoginServer loginServer = loginServerDao.getByUserType(u.getUserType());
		if (StringUtils.isBlank(loginServer.getMemberSite()) && "2".equals(u.getUserType())) {
			return;
		}
		if (!u.getUserType().equals(m.getMemberSite())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该账号类型不支持绑定非同类会员号!");
		}
		if ("0".equals(loginServer.getMemberSite())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该账号类型不支持绑定会员号!");
		}

	}

	/**
	 * @Description： 根据用户类型和url判断是否需要退出登录
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/11 14:44
	 */
	public String checkLogout(String userType, String url) {
		Boolean flag;
		String shotName = getShortNameByUserType(userType);
		if (url.contains("/" + shotName + "/")) {
			flag = false;
		} else {
			flag = true;
		}
		return flag.toString();
	}

	/**
	 * @Description： 根据用户类型获得简称，用户类型为空默认返回uc
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/11 14:31
	 */
	public String getShortNameByUserType(String userType) {
		if (StringUtils.isBlank(userType)) {
			// 为空默认返回uc
			return "uc";
		} else {
			LoginServer loginServer = dao.getByUserType(userType);
			return loginServer.getUserShortName();

		}

	}

	/**
	 * @Description： 根据url来源获得LoginServer
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/11 15:31
	 */
	public LoginServer getLoginServerByUrl(HttpServletRequest request) {
		// 获得shortName
		String shortName = getShortNameByUrl(request);
		return dao.getByShortName(shortName);
	}

	/**
	 * @Description： 根据url来源获得shortName
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/11 17:44
	 */
	public String getShortNameByUrl(HttpServletRequest request) {
		if (request == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
		}
		String url = request.getHeader("Referer");
		System.out.println("======Referer======url========" + url);
		// if (Global.isDevMode()) {
		// return "uc";
		// }
		// 过滤ckulife网站，默认为uc
		if (StringUtils.isBlank(url) || url.contains("www.ckulife.com") || url.contains("www.ckulife.cn")) {
			// if(StringUtils.isBlank(url) || url.contains("www.ckulife.com")||
			// url.contains("www.ckulife.cn")
			// || url.contains("viptest.chongaibao.com")){
			return "uc";
		}
		String regEx = "oa-web";
		String separator = "/";
		int index = url.indexOf(regEx) + regEx.length() + separator.length();
		if (index == -1) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
		}
		url = url.substring(index);
		index = url.indexOf(separator);
		return url.substring(0, index);
	}

	public String getShortNameByClub(HttpServletRequest request) {
		if (request == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
		}
		String url = request.getHeader("Referer");
		System.out.println("======Referer======url========" + url);
		// 兼容club
		String club = request.getHeader("club");
		if (StringUtils.isNotBlank(club)) {
			switch (club) {
			case "cku":
				return "uc";
			case "ckudc":
				return "dc";
			case "ckumc":
				return "mc";
			default:
				return "uc";
			}
		}
		//
		// if (Global.isDevMode()) {
		// return "uc";
		// }
		// 过滤ckulife网站，默认为uc
		if (StringUtils.isBlank(url) || url.contains("www.ckulife.com") || url.contains("www.ckulife.cn")) {
			// if(StringUtils.isBlank(url) || url.contains("www.ckulife.com")||
			// url.contains("www.ckulife.cn")
			// || url.contains("viptest.chongaibao.com")){
			return "uc";
		}
		String regEx = "oa-web";
		String separator = "/";
		int index = url.indexOf(regEx) + regEx.length() + separator.length();
		if (index == -1) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "获取参数错误，请重试");
		}
		url = url.substring(index);
		index = url.indexOf(separator);
		return url.substring(0, index);
	}

	public LoginServer getLoginServerByClub(HttpServletRequest request) {
		// 获得shortName
		String shortName = getShortNameByClub(request);
		return dao.getByShortName(shortName);
	}

	public LoginServer getLoginServerByDogBreed(String dogBreed) {
		String shortName = "uc";
		if ("15C".equals(dogBreed)) {
			shortName = "mc";
		}
		if ("292".equals(dogBreed)) {
			shortName = "dc";
		}
		return dao.getByShortName(shortName);
	}

	/**
	 * @Description： 根据登录类型获得可查询的会员站点类型(作用为单犬种俱乐部查询会员列表和犬舍列表)
	 * 
	 * @author: chaixueteng
	 * @date: 2017/12/11 17:44
	 */
	public String getMemberSiteByAlike() {
		StringBuilder sb = new StringBuilder();
		User loginUser = UserUtils.getLoginUser();
		LoginServer loginServer = loginServerDao.getByUserType(loginUser.getUserType());
		if (loginServer == null) {
			return null;
		} else {
			String isAlike = loginServer.getIsAlike();
			LoginServer loginServer2 = loginServerDao.getByIsAlikeOnMember(isAlike);
			if (loginServer2 == null) {
				return null;
			} else {
				sb.append(" ='" + loginServer2.getMemberSite() + "'");
				return sb.toString();
			}
		}
	}

	/**
	 * @Description： 根据登录类型获得犬种列表
	 * 
	 * @author: chaixueteng
	 * @date: 2017/12/13 17:44
	 */
	public String getByDogTypeList() {
		User loginUser = UserUtils.getLoginUser();
		LoginServer loginServer = loginServerDao.getByUserType(loginUser.getUserType());
		if (loginServer == null) {
			return null;
		} else {
			if ("1".equals(loginServer.getIsSupport())) {
				StringBuilder sb = new StringBuilder();
				if (loginServer.getDogType().contains(",")) {// 多种犬种
					String[] split = loginServer.getDogType().split(",");
					for (int i = 0; i < split.length; i++) {
						sb.append("!" + split[i] + ",");
					}
					sb.deleteCharAt(sb.length() - 1);
					return sb.toString();
				} else {
					sb.append("!" + loginServer.getDogType());
					return sb.toString();
				}
			} else {
				return loginServer.getDogType();
			}
		}
	}

	/**
	 * @Description : 根据当前登录端,犬种,站点查询是否可使用
	 * @author chaixueteng
	 * @return
	 */
	public void findDogType(String dogBreed, String memberSite) {
		User loginUser = UserUtils.getLoginUser();
		findDogType(dogBreed, loginUser.getUserType(), memberSite);
	}

	public void findDogType(String dogBreed, String userType, String memberSite) {
		LoginServer loginServer = loginServerDao.getByUserType(userType);
		if (loginServer != null) {
			String[] dogBreeds = loginServer.getDogType().split(",");
			for (String str : dogBreeds) {
				if (str.equals(dogBreed) && "1".equals(loginServer.getIsSupport())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种与当前会员所属协会不匹配!");
				}
				if (!str.equals(dogBreed) && "0".equals(loginServer.getIsSupport())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种与当前会员所属协会不匹配!");
				}
			}
			if (memberSite != null) {
				if (!loginServer.getMemberSite().equals(memberSite)) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种与当前会员所属协会不匹配!");
				}
			}
		}
	}

	/**
	 * @Description： 根据会员类型判断犬种
	 * 
	 * @author: yuanshuai
	 * @date: 2018/11/29 10:21
	 */
	public void findDogTypeByMemberSite(String dogBreed, String memberSite) {
		LoginServer loginServer = getLoginServerByMemberSite(memberSite);
		if (loginServer != null) {
			String[] dogBreeds = loginServer.getDogType().split(",");
			for (String str : dogBreeds) {
				if (str.equals(dogBreed) && "1".equals(loginServer.getIsSupport())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种与当前会员所属协会不匹配!");
				}
				if (!str.equals(dogBreed) && "0".equals(loginServer.getIsSupport())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种与当前会员所属协会不匹配!");
				}
			}
		}
	}

	/**
	 * @Description： 根据会员站点查询loginServer
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/19 15:49
	 */
	public LoginServer getLoginServerByMemberSite(String memberSite) {
		return loginServerDao.getByMemberSite(memberSite);
	}
}