/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.entity.TaskLog;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 计划任务执行日志DAO接口
 * 
 * @author zhuoHeng
 * @version 2017-03-31
 */
@MyBatisDao
public interface TaskLogDao extends CrudDao<TaskLog> {

	/**
	 * 
	 * @Description：校验当天执行次数
	 * @author: zhuoHeng
	 * @version: 2017年4月5日 下午3:38:37
	 */
	public TaskLog validateExecute(@Param("jobName") String jobName);

	public List<TaskLog> getLog();

}