/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.entity.OrgChip;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 芯片发放记录DAO接口
 * @author fanhuibin
 * @version 2016-09-06
 */
@MyBatisDao
public interface OrgChipDao extends CrudDao<OrgChip> {
	
	public List<OrgChip> getPutOutHistory(OrgChip chip);
	//查询芯片是否在俱乐部旗下
	public OrgChip getByOrgAndIdflag(@Param("orgId")String orgId,@Param("chipCode") String chipCode);
	//查询芯片
	public List<OrgChip> getByChipCode(@Param("chipCode")String chipCode);
	//各合作机构的芯片埋置情况
	public Map<String,String> getChipCountByOrg(@Param("orgId")String orgId);
	//各合作机构的采血器材使用情况
	public Map<String,String> getBloodCountByOrg(@Param("orgId")String orgId);
	//批量删除芯片
	public void deleteList(OrgChip orgChip);
	
	//查询芯片列表
    public List<OrgChip> getByChipCodes(@Param("chipCodes")List<String> chipCodes);
}