package com.cku.oa.sys.coupon.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sys.coupon.entity.SysCouponDef;
import com.cku.oa.sys.coupon.service.SysCouponDefService;

/**
 * 优惠券配置信息Controller
 * @author zjw
 * @version 2020-06-04
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/coupon/sysCouponDef")
public class SysCouponDefController extends BaseController {

	@Autowired
	private SysCouponDefService sysCouponDefService;
	
	@ModelAttribute
	public SysCouponDef get(@RequestParam(required=false) String id) {
		SysCouponDef entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = sysCouponDefService.get(id);
		}
		if (entity == null){
			entity = new SysCouponDef();
		}
		return entity;
	}
	
	@RequestMapping(value = {"list", ""})
	public String list(SysCouponDef sysCouponDef, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SysCouponDef> page = sysCouponDefService.findPage(new Page<SysCouponDef>(request, response), sysCouponDef); 
		model.addAttribute("page", page);
		return "oa/sys/coupon/sysCouponDefList";
	}

	@RequestMapping(value = "form")
	public String form(SysCouponDef sysCouponDef, Model model) {
		model.addAttribute("sysCouponDef", sysCouponDef);
		return "oa/sys/coupon/sysCouponDefForm";
	}

	@RequiresPermissions("sys:coupon:sysCouponDef:edit")
	@RequestMapping(value = "save")
	public String save(SysCouponDef sysCouponDef, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysCouponDef)){
			return form(sysCouponDef, model);
		}
		sysCouponDefService.save(sysCouponDef);
		addMessage(redirectAttributes, "保存保存配置成功成功");
		return "redirect:"+Global.getAdminPath()+"/sys/coupon/sysCouponDef/?repage";
	}
	
	@RequiresPermissions("sys:coupon:sysCouponDef:edit")
	@RequestMapping(value = "delete")
	public String delete(SysCouponDef sysCouponDef, RedirectAttributes redirectAttributes) {
		sysCouponDefService.delete(sysCouponDef);
		addMessage(redirectAttributes, "删除保存配置成功成功");
		return "redirect:"+Global.getAdminPath()+"/sys/coupon/sysCouponDef/?repage";
	}

}