package com.cku.oa.statistics.web;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import com.cku.oa.statistics.dao.MemberInfoDao;
import com.cku.oa.statistics.entity.MemberInfo;
import com.cku.oa.statistics.service.MemberInfoService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
/**
 * 会员信息统计
 * @author xuzhenxing
 *
 */
@Controller
@RequestMapping(value = "${adminPath}/statistics/member")
public class MemberInfoController extends BaseController {
	@Autowired
	private MemberInfoDao memberInfoDao;
	@Autowired
	private MemberInfoService memberInfoService;
	/**
	 * 会员区域分布统计
	 * @throws ParseException 
	 */
	@RequestMapping(value = "regionalDistribution")
	public String regionalDistribution(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			String province = request.getParameter("province");		
			//统计各个地区的会员数量
			List<Map> results = memberInfoDao.countByRegion(province);
			//往页面传值
			model.addAttribute("selectedProvince",province);
			model.addAttribute("province", UserUtils.getProvince());			
			model.addAttribute("results",results);			
			//下面的代码纯粹是为了演示如何使用分页功能，这个功能其实不需要分页的
			Page<User> page = new Page<User>(request, response);//从页面的参数中获取当前的页码等信息
			page.setCount(100); //总条数
			page.setPageNo(1);//当前的页数
			page.setPageSize(20); //每页的大小
			page.initialize();//初始化
			model.addAttribute("page", page);									
			return "oa/statistics/member/regionalDistribution";	
	}
	/**
	 * 会员消费统计(地区)
	 * @throws ParseException 
	 */
	
	@RequestMapping(value = "regionalConsumption")
	public String regionalConsumption(HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			String province = request.getParameter("province");	
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");
			
			if( startDate == null && endDate == null )
			{
				Calendar cal = Calendar.getInstance();
				int year = cal.get(Calendar.YEAR);
				int month = cal.get(Calendar.MONTH )+1;
				startDate = String.valueOf(year)+"-"+String.valueOf(month)+"-01";
				endDate = String.valueOf(year)+"-"+String.valueOf(month+1)+"-01";
			}
			
			//统计各个地区的会员数量
			List<Map> results = memberInfoDao.countByConsumption(province,startDate,endDate);
			//往页面传值
			model.addAttribute("selectedProvince",province);
			model.addAttribute("province", UserUtils.getProvince());			
			model.addAttribute("results",results);			
			model.addAttribute("startDate",startDate);
			model.addAttribute("endDate",endDate);
			//下面的代码纯粹是为了演示如何使用分页功能，这个功能其实不需要分页的
			Page<User> page = new Page<User>(request, response);//从页面的参数中获取当前的页码等信息
			page.setCount(results.size()); //总条数
			page.setPageNo(1);//当前的页数
			page.setPageSize(20); //每页的大小
			page.initialize();//初始化
			model.addAttribute("page", page);									
			return "oa/statistics/member/regionalConsumption";	
	}
	/**
	 * 会员消费统计
	 * @throws ParseException 
	 */
	
	@RequestMapping(value = "memberConsumption")
	public String memberConsumption(MemberInfo memberInfo,HttpServletRequest request,HttpServletResponse response,Model model) throws ParseException{
			Page<MemberInfo> page = memberInfoService.findPage(new Page<MemberInfo>(request, response), memberInfo);
			/*String memberCode = request.getParameter("memberCode");	
			String startDate = request.getParameter("startDate");
			String endDate = request.getParameter("endDate");*/
			 Map<String,String> countByMemberOnIn = memberInfoDao.countByMemberOnIn(memberInfo.getMemberCode(),memberInfo.getStartDate(),memberInfo.getEndDate());
			 model.addAttribute("balance", countByMemberOnIn.get("member_balance"));
			 model.addAttribute("outPrice", countByMemberOnIn.get("member_out_price"));
			 model.addAttribute("inPrice", countByMemberOnIn.get("member_in_price"));
			//往页面传值
			model.addAttribute("page", page);									
			return "oa/statistics/member/memberConsumption";	
	}
}
