package com.cku.oa.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.util.DateUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.show.entity.ShowReportScore;
import com.cku.oa.show.service.ShowReportScoreService;

import java.util.Arrays;
import java.util.List;

/**
 * 犬展秩序册Controller
 * @author lyy
 * @version 2018-01-22
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showReportScore")
public class ShowReportScoreController extends BaseController {

	@Autowired
	private ShowReportScoreService showReportScoreService;
	
	@ModelAttribute
	public ShowReportScore get(@RequestParam(required=false) String id) {
		ShowReportScore entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showReportScoreService.get(id);
		}
		if (entity == null){
			entity = new ShowReportScore();
		}
		return entity;
	}
	
	@RequiresPermissions("show:showReportScore:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowReportScore showReportScore, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowReportScore> page = showReportScoreService.findPage(new Page<ShowReportScore>(request, response), showReportScore); 
		model.addAttribute("page", page);
		return "oa/show/reportscore/showReportScoreList";
	}

	@RequiresPermissions("show:showReportScore:view")
	@RequestMapping(value = "form")
	public String form(ShowReportScore showReportScore, Model model) {
		model.addAttribute("showReportScore", showReportScore);
		model.addAttribute("judges",showReportScoreService.findJudgeById(showReportScore.getId()));
		return "oa/show/reportscore/showReportScoreForm";
	}

	@RequiresPermissions("show:showReportScore:edit")
	@RequestMapping(value = "save")
	public String save(ShowReportScore showReportScore, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, showReportScore)){
			return form(showReportScore, model);
		}
		showReportScoreService.save(showReportScore);
		addMessage(redirectAttributes, "保存犬展秩序册成功");
		return "redirect:"+Global.getAdminPath()+"/show/showReportScore/?repage";
	}
	@RequiresPermissions("show:showReportScore:edit")
	@RequestMapping(value = "editForm")
	public String editForm(ShowReportScore showReportScore, Model model) {
		model.addAttribute("showReportScore", showReportScore);
		model.addAttribute("judges",showReportScoreService.findJudgeById(showReportScore.getId()));
		return "oa/show/reportscore/showReportScoreEditForm";
	}
	@RequiresPermissions("show:showReportScore:edit")
	@RequestMapping(value = "delete")
	public String delete(ShowReportScore showReportScore, RedirectAttributes redirectAttributes) {
		showReportScoreService.delete(showReportScore);
		addMessage(redirectAttributes, "删除犬展秩序册成功");
		return "redirect:"+Global.getAdminPath()+"/show/showReportScore/?repage";
	}
	@RequiresPermissions("show:showReportScore:edit")
	@RequestMapping(value = "import", method= RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			//犬展信息导入
			showReportScoreService.importShowReportScore(file);
			addMessage(redirectAttributes, "导入犬展秩序册成功！");
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入犬展秩序册失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/show/showReportScore/?repage";
	}

	/**
	 * 下载导入犬展信息模板
	 * @param response
	 * @param redirectAttributes
	 * @return
	 */
	@RequiresPermissions("show:showReportScore:view")
	@RequestMapping(value = "import/template")
	public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
		try {
			String fileName = "犬展秩序册导入模板.xlsx";
			List<ShowReportScore> list = Lists.newArrayList();
			ShowReportScore showReportScore = new ShowReportScore();
			showReportScore.setShowCode("201803-徐州-01,201803-徐州-02,201803-徐州-03,201803-徐州-04,201803-徐州-05,201803-徐州-06");
			showReportScore.setOrderNumber("001");
			showReportScore.setDogOwnerZh("秦钰芳");
			showReportScore.setDogOwnerHandler("秦钰芳(张雷)");
			showReportScore.setDogOwnerCode("16461");
			showReportScore.setDogTypeZh("古代英国牧羊犬");
			showReportScore.setDogTypeEn("Old English Sheepdog");
			showReportScore.setDogName("Xuan Mu  Chun");
			showReportScore.setDogSex("母");
			showReportScore.setDogYearGroup("幼小母犬组");
			showReportScore.setPedigreeCertifiedCode("CKU-16370342/17");
			showReportScore.setFciCode("16");
			showReportScore.setShowCircle("4");
			list.add(showReportScore);
			new ExportExcel("", ShowReportScore.class, 2).setDataList(list).write(response, fileName).dispose();
			return null;
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入模板下载失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"//show/showReportScore/?repage";
	}
}