/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import java.util.Date;

/**
 * 赛事成绩Entity
 *
 * @author lgl
 * @version 2016-07-13
 */
public class ShowResults extends DataEntity<ShowResults> {

	private static final long serialVersionUID = 1L;
	private String dogId; // 犬只信息表主键
	@NotBlank
	@ExcelField(title = "犬展编号", align = 2, sort = 6)
	private String showCode; // 赛事编号
	private String year; // 官网成绩排名所属年份（默认去赛事编号年份，当赛事跨年，可以手动修改年份为下一年）
	@ExcelField(title = "裁判", align = 2, sort = 54)
	private String referee; // 裁判
	@ExcelField(title = "CKU血统证书号", align = 2, sort = 44)
	private String pedigreeCertified; // 血统证书号
	@ExcelField(title = "外国血统证书号", align = 2, sort = 45)
	private String otherCertified; // 其他证书号
	@ExcelField(title = "赛圈", align = 2, sort = 55)
	private String raceLap; // 赛圈
	@ExcelField(title = "犬种组", align = 2, sort = 38)
	private String dogBreedGroup; // 犬种组
	@ExcelField(title = "年龄组别", align = 2, sort = 43)
	private String ageGroup; // 年龄组别
	@ExcelField(title = "性别", align = 2, sort = 40)
	private String dogGender; // 犬性别
	@ExcelField(title = "FCI代码", align = 2, sort = 37)
	private String fciCode; // FCI码
	@ExcelField(title = "犬主人", align = 2, sort = 31)
	private String dogOwnerNameCn; // 犬主中文名
	@ExcelField(title = "姓名拼音", align = 2, sort = 33)
	private String dogOwnerNameEn; // 犬主英文名
	@ExcelField(title = "会员号", align = 2, sort = 34)
	private String dogOwnerMemberCode; // 犬主会员号
	@ExcelField(title = "本场积分", align = 2, sort = 30)
	private String showResult; // 本场积分
	@ExcelField(title = "秩序号", align = 2, sort = 7)
	private String orderCode; // 秩序号
	@ExcelField(title = "评价", align = 2, sort = 9)
	private String appraisal; // 评价
	@ExcelField(title = "CC", align = 2, sort = 10)
	private String resultCc; // cc项成绩
	@ExcelField(title = "CC备注", align = 2, sort = 8)
	private String remarksCc; // CC备注
	@ExcelField(title = "CACIB", align = 2, sort = 12)
	private String resultCacib; // cacib项成绩
	@ExcelField(title = "CACIB备注", align = 2, sort = 13)
	private String remarksCacib; // CACIB备注
	@ExcelField(title = "BOB", align = 2, sort = 19)
	private String resultBob; // bob项成绩
	@ExcelField(title = "BIS", align = 2, sort = 21)
	private String resultBis; // BIS项成绩
	@ExcelField(title = "BIG", align = 2, sort = 20)
	private String resultBig; // BIG项成绩
	@ExcelField(title = "BOW", align = 2, sort = 15)
	private String resultBow; // BOW项成绩
	@ExcelField(title = "WB", align = 2, sort = 14)
	private String resultWb; // WB项成绩
	@ExcelField(title = "修改说明", align = 2, sort = 56)
	private String remarks; // 备注信息
	private String resultJcc; // 成绩JCC
	private String resultRcc; // 成绩RCC
	@ExcelField(title = "BOJ", align = 2, sort = 16)
	private String resultBoj; // BOJ项成绩
	@ExcelField(title = "JBIG", align = 2, sort = 17)
	private String resultJbig;// JBIG项成绩
	@ExcelField(title = "JBIS", align = 2, sort = 18 )
	private String resultJbis;// JBIS项成绩

	private String resultBos; // BOS项成绩,存储于BOB字段中
	private String resultRjcc; // Rjcc项成绩,
	private String breedCnName; // 犬种类中文名称
	@ExcelField(title = "APACCC", align = 2, sort = 60)
	private String resultApaccc;//World Winner 亚太CC成绩
	@ExcelField(title = "BBE-BIS", align = 2, sort = 22)
	private String resultBbeBis;//繁殖人成绩
	@ExcelField(title = "BBE-BIG", align = 2, sort = 23)
	private String resultBbeBig;//繁殖人成绩
	@ExcelField(title = "BBE-WINNER", align = 2, sort = 24)
	private String resultBbeWinner;//繁殖人成绩
	@ExcelField(title = "BBE-BISS", align = 2, sort = 25)
	private String resultBbeBiss;//繁殖人成绩
	@ExcelField(title = "OHC-BIS", align = 2, sort = 29)
	private String resultOhcBis;//犬主人成绩
	@ExcelField(title = "OHC-BIG", align = 2, sort = 27)
	private String resultOhcBig;//犬主人成绩
	@ExcelField(title = "OHC-BISS", align = 2, sort = 26)
	private String resultOhcBiss;//犬主人成绩
	@ExcelField(title = "OHC-BOH", align = 2, sort = 28)
	private String resultOhcBoh;//犬主人成绩
	private String ohcScore;//成绩
	private String bbeScore;//
	private String resultBov;//

	private String resultGcc;
	private String breedEnName;//
	private String dogName;//
	private String kennlCnName;//
	private String kennlEnName;//
	private String score;//
	private String resultOhc;//
	private String scoreType;//
	
	private String[] resultCcs;
	
	private String qusResult;
	private String qusCode;
	
	@ExcelField(title = "本场单犬种积分", align = 2, sort = 61)
	private String showBreedResult; // 本场积分
	
	private String showGroupResult; // 本场组别榜积分
	
	public String getShowGroupResult() {
		return showGroupResult;
	}

	public void setShowGroupResult(String showGroupResult) {
		this.showGroupResult = showGroupResult;
	}

	public String getShowBreedResult() {
		return showBreedResult;
	}

	public void setShowBreedResult(String showBreedResult) {
		this.showBreedResult = showBreedResult;
	}

	public String getScoreType() {
		return scoreType;
	}

	public void setScoreType(String scoreType) {
		this.scoreType = scoreType;
	}

	public String getResultOhc() {
		return resultOhc;
	}

	public void setResultOhc(String resultOhc) {
		this.resultOhc = resultOhc;
	}

	public String getResultBov() {
		return resultBov;
	}

	public void setResultBov(String resultBov) {
		this.resultBov = resultBov;
	}

	public String getScore() {
		return score;
	}

	public void setScore(String score) {
		this.score = score;
	}

	public String getKennlCnName() {
		return kennlCnName;
	}

	public void setKennlCnName(String kennlCnName) {
		this.kennlCnName = kennlCnName;
	}

	public String getKennlEnName() {
		return kennlEnName;
	}

	public void setKennlEnName(String kennlEnName) {
		this.kennlEnName = kennlEnName;
	}

	public String getBreedEnName() {
		return breedEnName;
	}

	public void setBreedEnName(String breedEnName) {
		this.breedEnName = breedEnName;
	}

	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	public String getOhcScore() {
		return ohcScore;
	}

	public void setOhcScore(String ohcScore) {
		this.ohcScore = ohcScore;
	}

	public String getBbeScore() {
		return bbeScore;
	}

	public void setBbeScore(String bbeScore) {
		this.bbeScore = bbeScore;
	}

	public ShowResults() {
		super();
	}

	public ShowResults(String id) {
		super(id);
	}

	// @Length(min=0, max=64, message="犬只信息表主键长度必须介于 0 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	// @Length(min=0, max=64, message="赛事编号长度必须介于 0 和 64 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	// @Length(min=0, max=50, message="裁判长度必须介于 0 和 50 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	// @Length(min=0, max=64, message="血统证书号长度必须介于 0 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	// @Length(min=0, max=64, message="其他证书号长度必须介于 0 和 64 之间")
	public String getOtherCertified() {
		return otherCertified;
	}

	public void setOtherCertified(String otherCertified) {
		this.otherCertified = otherCertified;
	}

	// @Length(min=1, max=10, message="赛圈长度必须介于 1 和 10 之间")
	public String getRaceLap() {
		return raceLap;
	}

	public void setRaceLap(String raceLap) {
		this.raceLap = raceLap;
	}

	// @Length(min=0, max=10, message="犬种组长度必须介于 0 和 10 之间")
	public String getDogBreedGroup() {
		return dogBreedGroup;
	}

	public void setDogBreedGroup(String dogBreedGroup) {
		this.dogBreedGroup = dogBreedGroup;
	}

	// @Length(min=0, max=2, message="年龄组别长度必须介于 0 和 2 之间")
	public String getAgeGroup() {
		return ageGroup;
	}

	public void setAgeGroup(String ageGroup) {
		this.ageGroup = ageGroup;
	}

	// @Length(min=0, max=1, message="犬性别长度必须介于 0 和 1 之间")
	public String getDogGender() {
		return dogGender;
	}

	public void setDogGender(String dogGender) {
		this.dogGender = dogGender;
	}

	// @Length(min=0, max=6, message="FCI码长度必须介于 0 和 6 之间")
	public String getFciCode() {
		return fciCode;
	}

	public void setFciCode(String fciCode) {
		this.fciCode = fciCode;
	}

	// @Length(min=0, max=50, message="犬主中文名长度必须介于 0 和 50 之间")
	public String getDogOwnerNameCn() {
		return dogOwnerNameCn;
	}

	public void setDogOwnerNameCn(String dogOwnerNameCn) {
		this.dogOwnerNameCn = dogOwnerNameCn;
	}

	// @Length(min=0, max=50, message="犬主英文名长度必须介于 0 和 50 之间")
	public String getDogOwnerNameEn() {
		return dogOwnerNameEn;
	}

	public void setDogOwnerNameEn(String dogOwnerNameEn) {
		this.dogOwnerNameEn = dogOwnerNameEn;
	}

	// @Length(min=0, max=64, message="犬主会员号长度必须介于 0 和 64 之间")
	public String getDogOwnerMemberCode() {
		return dogOwnerMemberCode;
	}

	public void setDogOwnerMemberCode(String dogOwnerMemberCode) {
		this.dogOwnerMemberCode = dogOwnerMemberCode;
	}

	// @Length(min=0, max=11, message="本场积分长度必须介于 0 和 11 之间")
	public String getShowResult() {
		return showResult;
	}

	public void setShowResult(String showResult) {
		this.showResult = showResult;
	}

	// @Length(min=0, max=5, message="秩序号长度必须介于 0 和 5 之间")
	public String getOrderCode() {
		return orderCode;
	}

	public void setOrderCode(String orderCode) {
		this.orderCode = orderCode;
	}

	public String getAppraisal() {
		return appraisal;
	}

	public void setAppraisal(String appraisal) {
		this.appraisal = appraisal;
	}

	// @Length(min=0, max=1, message="cc项成绩长度必须介于 0 和 1 之间")
	public String getResultCc() {
		return resultCc;
	}

	public void setResultCc(String resultCc) {
		this.resultCc = resultCc;
	}

	// @Length(min=0, max=100, message="CC备注长度必须介于 0 和 100 之间")
	public String getRemarksCc() {
		return remarksCc;
	}

	public void setRemarksCc(String remarksCc) {
		this.remarksCc = remarksCc;
	}

	// @Length(min=0, max=1, message="cacib项成绩长度必须介于 0 和 1 之间")
	public String getResultCacib() {
		return resultCacib;
	}

	public void setResultCacib(String resultCacib) {
		this.resultCacib = resultCacib;
	}

	// @Length(min=0, max=100, message="CACIB备注长度必须介于 0 和 100 之间")
	public String getRemarksCacib() {
		return remarksCacib;
	}

	public void setRemarksCacib(String remarksCacib) {
		this.remarksCacib = remarksCacib;
	}

	// @Length(min=0, max=1, message="bob项成绩长度必须介于 0 和 1 之间")
	public String getResultBob() {
		return resultBob;
	}

	public void setResultBob(String resultBob) {
		this.resultBob = resultBob;
	}

	// @Length(min=0, max=20, message="BIS项成绩长度必须介于 0 和 20 之间")
	public String getResultBis() {
		return resultBis;
	}

	public void setResultBis(String resultBis) {
		this.resultBis = resultBis;
	}

	// @Length(min=0, max=20, message="BIG项成绩长度必须介于 0 和 20 之间")
	public String getResultBig() {
		return resultBig;
	}

	public void setResultBig(String resultBig) {
		this.resultBig = resultBig;
	}

	// @Length(min=0, max=20, message="BOW项成绩长度必须介于 0 和 20 之间")
	public String getResultBow() {
		return resultBow;
	}

	public void setResultBow(String resultBow) {
		this.resultBow = resultBow;
	}

	// @Length(min=0, max=20, message="WB项成绩长度必须介于 0 和 20 之间")
	public String getResultWb() {
		return resultWb;
	}

	public void setResultWb(String resultWb) {
		this.resultWb = resultWb;
	}

	@Length(min=0, max=1024, message="remarks长度必须介于 0 和 1024 之间")
	public String getRemarks() {
		return remarks;
	}

	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}

	@ExcelField(title = "c1", align = 2, sort = 1)
	private String c1;
	@ExcelField(title = "c2", align = 2, sort = 2)
	private String c2;
	@ExcelField(title = "c3", align = 2, sort = 3)
	private String c3;
	@ExcelField(title = "c4", align = 2, sort = 4)
	private String c4;
	@ExcelField(title = "c5", align = 2, sort = 5)
	private String c5;
	@ExcelField(title = "other cc", align = 2, sort = 11)
	private String otherCC;
	@ExcelField(title = "c32", align = 2, sort = 32)
	private String c32;
	@ExcelField(title = "c36", align = 2, sort = 36)
	private String c36;
	@ExcelField(title = "c35", align = 2, sort = 35)
	private String c35;
	@ExcelField(title = "c39", align = 2, sort = 39)
	private String c39;
	@ExcelField(title = "c41", align = 2, sort = 41)
	private String c41;
	@ExcelField(title = "c42", align = 2, sort = 42)
	private String c42;
	@ExcelField(title = "c46", align = 2, sort = 46)
	private String c46;
	@ExcelField(title = "c47", align = 2, sort = 47)
	private String c47;
	@ExcelField(title = "c48", align = 2, sort = 48)
	private String c48;
	@ExcelField(title = "c49", align = 2, sort = 49)
	private String c49;
	@ExcelField(title = "c50", align = 2, sort = 50)
	private String c50;
	@ExcelField(title = "c51", align = 2, sort = 51)
	private String c51;
	@ExcelField(title = "c52", align = 2, sort = 52)
	private String c52;
	@ExcelField(title = "c53", align = 2, sort = 53)
	private String c53;
	@ExcelField(title = "c57", align = 2, sort = 57)
	private String c57;


	public String getResultBbeBis() {
		return resultBbeBis;
	}

	public void setResultBbeBis(String resultBbeBis) {
		this.resultBbeBis = resultBbeBis;
	}

	public String getResultBbeBig() {
		return resultBbeBig;
	}

	public void setResultBbeBig(String resultBbeBig) {
		this.resultBbeBig = resultBbeBig;
	}

	public String getResultBbeWinner() {
		return resultBbeWinner;
	}

	public void setResultBbeWinner(String resultBbeWinner) {
		this.resultBbeWinner = resultBbeWinner;
	}

	public String getResultBbeBiss() {
		return resultBbeBiss;
	}

	public void setResultBbeBiss(String resultBbeBiss) {
		this.resultBbeBiss = resultBbeBiss;
	}

	public String getResultOhcBis() {
		return resultOhcBis;
	}

	public void setResultOhcBis(String resultOhcBis) {
		this.resultOhcBis = resultOhcBis;
	}

	public String getResultOhcBig() {
		return resultOhcBig;
	}

	public void setResultOhcBig(String resultOhcBig) {
		this.resultOhcBig = resultOhcBig;
	}

	public String getResultOhcBiss() {
		return resultOhcBiss;
	}

	public void setResultOhcBiss(String resultOhcBiss) {
		this.resultOhcBiss = resultOhcBiss;
	}

	public String getResultOhcBoh() {
		return resultOhcBoh;
	}

	public void setResultOhcBoh(String resultOhcBoh) {
		this.resultOhcBoh = resultOhcBoh;
	}

	public String getC32() {
		return c32;
	}

	public void setC32(String c32) {
		this.c32 = c32;
	}

	public String getC35() {
		return c35;
	}

	public void setC35(String c35) {
		this.c35 = c35;
	}

	public String getC51() {
		return c51;
	}

	public void setC51(String c51) {
		this.c51 = c51;
	}

	public String getC39() {
		return c39;
	}

	public void setC39(String c39) {
		this.c39 = c39;
	}

	public String getC49() {
		return c49;
	}

	public void setC49(String c49) {
		this.c49 = c49;
	}

	public String getC50() {
		return c50;
	}

	public void setC50(String c50) {
		this.c50 = c50;
	}

	public String getC53() {
		return c53;
	}

	public void setC53(String c53) {
		this.c53 = c53;
	}

	public String getC57() {
		return c57;
	}

	public void setC57(String c57) {
		this.c57 = c57;
	}

	public String getC1() {
		return c1;
	}

	public void setC1(String c1) {
		this.c1 = c1;
	}

	public String getC2() {
		return c2;
	}

	public void setC2(String c2) {
		this.c2 = c2;
	}

	public String getC3() {
		return c3;
	}

	public void setC3(String c3) {
		this.c3 = c3;
	}

	public String getC4() {
		return c4;
	}

	public void setC4(String c4) {
		this.c4 = c4;
	}

	public String getC5() {
		return c5;
	}

	public void setC5(String c5) {
		this.c5 = c5;
	}

	public String getOtherCC() {
		return otherCC;
	}

	public void setOtherCC(String otherCC) {
		this.otherCC = otherCC;
	}

	public String getC36() {
		return c36;
	}

	public void setC36(String c36) {
		this.c36 = c36;
	}

	public String getC46() {
		return c46;
	}

	public void setC46(String c46) {
		this.c46 = c46;
	}

	public String getC47() {
		return c47;
	}

	public void setC47(String c47) {
		this.c47 = c47;
	}

	public String getC52() {
		return c52;
	}

	public void setC52(String c52) {
		this.c52 = c52;
	}

	public String getC48() {
		return c48;
	}

	public void setC48(String c48) {
		this.c48 = c48;
	}

	public String getC41() {
		return c41;
	}

	public void setC41(String c41) {
		this.c41 = c41;
	}

	public String getC42() {
		return c42;
	}

	public void setC42(String c42) {
		this.c42 = c42;
	}

	public String getResultJcc() {
		return resultJcc;
	}

	public String getResultRcc() {
		return resultRcc;
	}

	public void setResultJcc(String resultJcc) {
		this.resultJcc = resultJcc;
	}

	public void setResultRcc(String resultRcc) {
		this.resultRcc = resultRcc;
	}

	// CKU官网查询所需
	private Date startTime; // 开始时间
	private Date endTime; // 结束时间
	private String showName; // 赛事名称

	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	public String getResultBoj() {
		return resultBoj;
	}

	public void setResultBoj(String resultBoj) {
		this.resultBoj = resultBoj;
	}

	public String getResultJbig() {
		return resultJbig;
	}

	public void setResultJbig(String resultJbig) {
		this.resultJbig = resultJbig;
	}

	public String getResultJbis() {
		return resultJbis;
	}

	public void setResultJbis(String resultJbis) {
		this.resultJbis = resultJbis;
	}

	public String getResultBos() {
		return resultBos;
	}

	public void setResultBos(String resultBos) {
		this.resultBos = resultBos;
	}

	public String getResultRjcc() {
		return resultRjcc;
	}

	public void setResultRjcc(String resultRjcc) {
		this.resultRjcc = resultRjcc;
	}

	public String getBreedCnName() {
		return breedCnName;
	}

	public void setBreedCnName(String breedCnName) {
		this.breedCnName = breedCnName;
	}

	public String getResultApaccc() {
		return resultApaccc;
	}

	public void setResultApaccc(String resultApaccc) {
		this.resultApaccc = resultApaccc;
	}

	public String[] getResultCcs() {
		return resultCcs;
	}

	public void setResultCcs(String[] resultCcs) {
		this.resultCcs = resultCcs;
	}

	public String getResultGcc() {
		return resultGcc;
	}

	public void setResultGcc(String resultGcc) {
		this.resultGcc = resultGcc;
	}

	public String getQusResult() {
		return qusResult;
	}

	public void setQusResult(String qusResult) {
		this.qusResult = qusResult;
	}

	public String getQusCode() {
		return qusCode;
	}

	public void setQusCode(String qusCode) {
		this.qusCode = qusCode;
	}
	
	
	
	
}