/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.show.entity.ShowScoreRanking;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 赛事成绩排名表DAO接口
 * @author xx
 * @version 2021-07-20
 */
@MyBatisDao
public interface ShowScoreRankingDao extends CrudDao<ShowScoreRanking> {
	
	
	public int truncate();
	
	public int delLogical(@Param("year") String year,@Param("month") String month,@Param("scoreType") String scoreType);
	
	public ShowScoreRanking getOne(ShowScoreRanking entity);
	
	int saveTrendByYearAndMonth(@Param("year") String year,@Param("month") String month,@Param("scoreType") String scoreType);
	
	int delPhysicalByYearAndMonth(@Param("year") String year,@Param("month") String month,@Param("version") String version,@Param("scoreType") String scoreType);
	
	List<ShowScoreRanking> findErrorGenerationList(@Param("year") String year);
	
	int updateForDel(ShowScoreRanking entity);
	
	String findMaxMonth(@Param("year") String year,@Param("scoreType") String scoreType);
	
	List<String> getMonths(@Param("year") String year,@Param("scoreType") String scoreType);
	
}