package com.cku.oa.shop.service;

import java.math.BigDecimal;
import java.util.Date;

import com.cku.core.ZAException;
import com.cku.oa.finance.dao.PaymentRecordDao;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.shop.dao.ShopMemberDao;
import com.cku.oa.shop.dao.ShopPayRecordDao;
import com.cku.oa.shop.dao.ShopUserMoneyDao;
import com.cku.oa.shop.entity.ShopMember;
import com.cku.oa.shop.entity.ShopPayRecord;
import com.cku.oa.shop.entity.ShopUserMoney;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Org;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by user on 2016/8/15.
 */
@Service
@Transactional(readOnly = true)
public class ShopMemberService extends CrudService<ShopMemberDao, ShopMember> {
//    //俱乐部会员充值收费项目标示
//    public static  final String ORGMEMBERCHARGINGITEMID = "1000";
//    //俱乐部会员退款收费项目标示
//    public static  final String ORGMEMBERRECHARGINGITEMID = "1001";
    @Autowired
    private ShopPayRecordDao shopPayRecordDao;
    @Autowired
    private ShopUserMoneyService shopUserMoneyService;
    @Autowired
    private PaymentRecordDao paymentRecordDao;
    @Autowired
    private OrgDao orgDao;
    @Autowired
    private ShopUserMoneyDao shopUserMoneyDao;

    @Transactional(readOnly = true)
    public Page<ShopMember> list(Page<ShopMember> page, ShopMember shopMember) {
        shopMember.setPage(page);
        page.setList(dao.list(shopMember));
        return page;
    }

    @Transactional(readOnly = true)
    public ShopMember getShopMemberByCode(String memberCode) {
        return dao.getShopMemberByCode(memberCode);
    }

    /**
     * 俱乐部充值
     * @param shopMember
     */
    @Transactional(readOnly = false)
    public void recharge(ShopMember shopMember)throws ZAException{
        //添加俱乐部充值信息表
        String runningNumber = SysCodeUtil.getPayRunningNumber();
        ShopPayRecord shopPayRecord = new ShopPayRecord();
		shopPayRecord.setMemberCode(shopMember.getMemberCode());
		shopPayRecord.setShopOrderCode(runningNumber);
		shopPayRecord.setPaymentMoney(shopMember.getPaymentAmount());
		shopPayRecord.setPaymentType("ckuoa.payin");
		shopPayRecord.setPaymentWay(shopMember.getPaymentWay());
		shopPayRecord.setPaymentTime(new Date());
        shopPayRecord.setPaymentRemarks(shopMember.getPaymentRemarks());
        shopPayRecord.setOutTradeNo(shopMember.getOutTradeNo());
		shopPayRecord.preInsert();
		shopPayRecordDao.insert(shopPayRecord);
        //修改俱乐部钱数
        if("0".equals(shopMember.getPaymentWay())){
            shopUserMoneyService.memberRecharge(shopMember.getMemberCode(),shopMember.getPaymentAmount(),shopMember.getPaymentTime(),"rebate");
        }else{
            shopUserMoneyService.memberRecharge(shopMember.getMemberCode(),shopMember.getPaymentAmount(),shopMember.getPaymentTime(),null);
        }

//        //生成流水表
//        PaymentRecord paymentRecord = new PaymentRecord();
//        paymentRecord.setOutTradeNo(shopMember.getOutTradeNo());
//        paymentRecord.setMemberCode(shopMember.getMemberCode());
//        paymentRecord.setPrice(shopMember.getPaymentAmount());
//        paymentRecord.setPaymentRemarks(shopMember.getPaymentRemarks());
//        paymentRecord.setPaymentWay(shopMember.getPaymentWay());
//        paymentRecord.setPaymentTime(shopPayRecord.getPaymentTime());
//        paymentRecord.setChargingItemId(ORGMEMBERCHARGINGITEMID);
//        paymentRecord.setChargingItemNum(1);
//        paymentRecord.setPaymentAmount(shopMember.getPaymentAmount());
//        paymentRecord.setPaymentState("2");
//        paymentRecord.setRunningNumber(runningNumber);
//        paymentRecord.preInsert();
//        paymentRecordDao.insert(paymentRecord);
    }
    /**
     * 俱乐部提现（退款）
     * @param shopMember
     */
    @Transactional(readOnly = false)
    public void charge(ShopMember shopMember) throws ZAException{
        //添加俱乐部提现（退款）
        String runningNumber = SysCodeUtil.getPayRunningNumber();
        ShopPayRecord shopPayRecord = new ShopPayRecord();
        shopPayRecord.setMemberCode(shopMember.getMemberCode());
        shopPayRecord.setShopOrderCode(runningNumber);
        shopPayRecord.setPaymentMoney("-"+shopMember.getPaymentAmount());
        if("money".equals(shopMember.getChargeType())){
            shopPayRecord.setPaymentType("ckuoa.refund");
            shopPayRecord.setPaymentWay("25");
        }else{
            shopPayRecord.setPaymentType("cku.order");
            shopPayRecord.setPaymentWay("27");
        }
        shopPayRecord.setPaymentTime(new Date());
        shopPayRecord.setPaymentRemarks(shopMember.getPaymentRemarks());
        shopPayRecord.preInsert();
        shopPayRecordDao.insert(shopPayRecord);
        //修改俱乐部钱数
        if("money".equals(shopMember.getChargeType())){
            shopUserMoneyService.memberCharge(shopMember.getMemberCode(),shopMember.getPaymentAmount(),"");
        }else{
            shopUserMoneyService.memberRecharge(shopMember.getMemberCode(),shopMember.getPaymentAmount(),new Date(),"");
        }
//        //生成流水表
//        PaymentRecord paymentRecord = new PaymentRecord();
//        paymentRecord.setMemberCode(shopMember.getMemberCode());
//        paymentRecord.setPrice("-"+shopMember.getPaymentAmount());
//        paymentRecord.setPaymentRemarks(shopMember.getPaymentRemarks());
//        if("money".equals(shopMember.getChargeType())){
//            paymentRecord.setPaymentWay("25");
//        }else{
//            paymentRecord.setPaymentWay("27");
//        }
//        paymentRecord.setPaymentTime(shopMember.getPaymentTime());
//        //退费
//        paymentRecord.setChargingItemId(ORGMEMBERRECHARGINGITEMID);
//        paymentRecord.setChargingItemNum(1);
//        paymentRecord.setPaymentAmount("-"+shopMember.getPaymentAmount());
//        paymentRecord.setPaymentState("2");
//        paymentRecord.setPaymentTime(shopPayRecord.getPaymentTime());
//        paymentRecord.setRunningNumber(runningNumber);
//        paymentRecord.preInsert();
//        paymentRecordDao.insert(paymentRecord);
    }
    public Org searchShopUser(String memberCode){
        Org result = orgDao.getOrgByMemberCode(memberCode);
        if(result!=null){
            ShopUserMoney shopUserMoney = shopUserMoneyDao.getByMemberCode(memberCode);
            if(shopUserMoney!=null){
                result.setShopMoney(shopUserMoney.getUserMoney());
            }else{
                result.setShopMoney("0");
            }
        }
        return result;
    }
}
