package com.cku.oa.shop.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.cku.core.ZAException;
import com.cku.oa.shop.dao.ShopGoodsClassDao;
import com.cku.oa.shop.entity.ShopGoodsClass;
import com.cku.util.ArrayUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.dao.ShopGoodsDao;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;

/**
 * 商品管理Service
 * @author lyy
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class ShopGoodsService extends CrudService<ShopGoodsDao, ShopGoods> {
	@Autowired
	private ShopGoodsClassDao shopGoodsClassDao;
	public ShopGoods get(String id) {
		ShopGoods result = super.get(id);
		return result;
	}

	public List<ShopGoods> findList(ShopGoods shopGoods) {
		return super.findList(shopGoods);
	}

	public Page<ShopGoods> findPage(Page<ShopGoods> page, ShopGoods shopGoods) {
		return super.findPage(page, shopGoods);
	}

	@Transactional(readOnly = false)
	public void save(ShopGoods shopGoods) {
		if (shopGoods.getIsNewRecord()){
			shopGoods.setAddTime(new Date());
			shopGoods.setCommentNum("0");
			shopGoods.setSaleNum("0");
			if(shopGoods.getClassId()!=null && "".equals(shopGoods.getClassId())){
				ShopGoodsClass shopGoodsClass = shopGoodsClassDao.get(new ShopGoodsClass(shopGoods.getClassId()));
				shopGoods.setCode(shopGoodsClass.getShortName()+System.currentTimeMillis());
			}
			if("0".equals(shopGoods.getIsInterval())){
				shopGoods.setInterval1Num("0");
				shopGoods.setInterval1Price("0");
				shopGoods.setInterval2Num("0");
				shopGoods.setInterval2Price("0");
				shopGoods.setInterval3Price("0");
			}else{
				if("0".equals(shopGoods.getInterval1Num()) || "0".equals(shopGoods.getInterval2Num())){
					throw new ZAException(-1,"区间1数量/区间2数量不能为0！");
				}else{
					if(Integer.parseInt(shopGoods.getInterval1Num())>Integer.parseInt(shopGoods.getInterval2Num())){
						throw new ZAException(-1,"区间1数量不能大于区间2数量！");
					}
				};
			}
			shopGoods.preInsert();
			dao.insert(shopGoods);
		}else{
			if("0".equals(shopGoods.getIsInterval())){
				shopGoods.setInterval1Num("0");
				shopGoods.setInterval1Price("0");
				shopGoods.setInterval2Num("0");
				shopGoods.setInterval2Price("0");
				shopGoods.setInterval3Price("0");
			}else{
				if("0".equals(shopGoods.getInterval1Num()) || "0".equals(shopGoods.getInterval2Num())){
					throw new ZAException(-1,"区间1数量/区间2数量不能为0！");
				}else{
					if(Integer.parseInt(shopGoods.getInterval1Num())>Integer.parseInt(shopGoods.getInterval2Num())){
						throw new ZAException(-1,"区间1数量不能大于区间2数量！");
					}
				};
			}
			shopGoods.preUpdate();
			dao.update(shopGoods);
		}
	}

	@Transactional(readOnly = false)
	public ShopGoods delImg(String id,String imgId) {
		ShopGoods shopGoods = super.get(id);
		String image = shopGoods.getImage();
		List<String> imageList = shopGoods.getImageList();
		String addImage = "";
		for(String imageId : imageList){
			if(!imageId.equals(imgId)){
				addImage = addImage+imageId+",";
			}
		}
		if(addImage.length()>0){
			addImage = addImage.substring(0,addImage.length()-1);
		}
		dao.delImg(shopGoods.getId(),addImage);
		shopGoods = super.get(id);
		return shopGoods;
	}
	@Transactional(readOnly = false)
	public void delete(ShopGoods shopGoods) {
		super.delete(shopGoods);
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importGoods(MultipartFile file) throws Exception {
		try {
			ImportExcel ei = new ImportExcel(file,0,0);
			List<ShopGoods> list = ei.getDataList(ShopGoods.class);
			for(ShopGoods sg :list){
				sg.setBuyGifts(DictUtils.getDictValue(sg.getBuyGifts(),"goods_buygifts","0"));
				sg.setIsFreight(DictUtils.getDictValue(sg.getIsFreight(),"yes_no","0"));
				sg.setIsShelves(DictUtils.getDictValue(sg.getIsShelves(),"yes_no","0"));
				sg.setIsRebate(DictUtils.getDictValue(sg.getIsRebate(),"yes_no","0"));
				sg.setClassId(shopGoodsClassDao.getIdByName(sg.getClassName()));
				save(sg);
			}
		} catch (Exception e) {
			throw new Exception(e);
		}

	}
	@Transactional(readOnly = false)
	public void export(ShopGoods shopGoods,HttpServletResponse response) throws IOException {
		List<ShopGoods> goodsList=dao.findList(shopGoods);
		for(ShopGoods sg :goodsList){
			sg.setBuyGifts(DictUtils.getDictLabel(sg.getBuyGifts(),"goods_buygifts","无"));
			sg.setIsShelves(DictUtils.getDictLabel(sg.getIsShelves(),"yes_no","否"));
			sg.setIsFreight(DictUtils.getDictLabel(sg.getIsFreight(),"yes_no","否"));
			sg.setIsRebate(DictUtils.getDictLabel(sg.getIsRebate(),"yes_no","否"));
			sg.setWeight(sg.getWeight());
		};
		new ExportExcel("", ShopGoods.class,2).setDataList(goodsList).write(response, "商城商品.xlsx").dispose();
	}
}