package com.cku.oa.sfexpress.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;

public class SfExpressStateVo {

	private String id;
	private String orderNo; // 客户订单号客户订单号
	private String waybillNo; // 顺丰运单号顺丰运单号
	private String orderStateDesc; // 订单状态
	private String orderStateCode; // 订单状态描述
	private String empcode; // 收件员工工号
	private String empphone; // 收件员工手机号
	private String netcode; // 网店
	private Date lasttime; // 最晚上门时间
	private Date booktime; // 客户预约时间
	private String carriercode; // 承运商代码(SF)承运商代码(SF)
	
	@JSONField(format = "yyyy-MM-dd HH:mm:ss")
	private Date createTime; // 创建时间

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Length(min = 0, max = 64, message = "客户订单号客户订单号长度必须介于 0 和 64 之间")
	public String getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}

	@Length(min = 0, max = 64, message = "顺丰运单号顺丰运单号长度必须介于 0 和 64 之间")
	public String getWaybillNo() {
		return waybillNo;
	}

	public void setWaybillNo(String waybillNo) {
		this.waybillNo = waybillNo;
	}

	@Length(min = 0, max = 20, message = "订单状态长度必须介于 0 和 20 之间")
	public String getOrderStateCode() {
		return orderStateCode;
	}

	public void setOrderStateCode(String orderStateCode) {
		this.orderStateCode = orderStateCode;
	}

	@Length(min = 0, max = 200, message = "订单状态描述长度必须介于 0 和 200 之间")
	public String getOrderStateDesc() {
		return orderStateDesc;
	}

	public void setOrderStateDesc(String orderStateDesc) {
		this.orderStateDesc = orderStateDesc;
	}

	@Length(min = 0, max = 100, message = "收件员工工号长度必须介于 0 和 100 之间")
	public String getEmpcode() {
		return empcode;
	}

	public void setEmpcode(String empcode) {
		this.empcode = empcode;
	}

	@Length(min = 0, max = 100, message = "收件员工手机号长度必须介于 0 和 100 之间")
	public String getEmpphone() {
		return empphone;
	}

	public void setEmpphone(String empphone) {
		this.empphone = empphone;
	}

	@Length(min = 0, max = 20, message = "网店长度必须介于 0 和 20 之间")
	public String getNetcode() {
		return netcode;
	}

	public void setNetcode(String netcode) {
		this.netcode = netcode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getLasttime() {
		return lasttime;
	}

	public void setLasttime(Date lasttime) {
		this.lasttime = lasttime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getBooktime() {
		return booktime;
	}

	public void setBooktime(Date booktime) {
		this.booktime = booktime;
	}

	@Length(min = 0, max = 10, message = "承运商代码(SF)承运商代码(SF)长度必须介于 0 和 10 之间")
	public String getCarriercode() {
		return carriercode;
	}

	public void setCarriercode(String carriercode) {
		this.carriercode = carriercode;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

}
