package com.cku.oa.org.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 俱乐部采样包发放Entity
 *
 * @author yuanshuai
 * @version 2023-05-28
 */
public class OrgSampling extends DataEntity<OrgSampling> {

    private static final long serialVersionUID = 1L;
    // 俱乐部id
    private String orgId;
    // 地址
    private String address;
    // 邮寄日期
    private Date postDate;
    // 批次号
    private String batchNum;
    // 采样包编号
    private String samplingCode;


    public OrgSampling() {
        super();
    }

    public OrgSampling(String id) {
        super(id);
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getPostDate() {
        return postDate;
    }

    public void setPostDate(Date postDate) {
        this.postDate = postDate;
    }

    @Length(min = 1, max = 32, message = "批次号长度必须介于 1 和 32 之间")
    public String getBatchNum() {
        return batchNum;
    }

    public void setBatchNum(String batchNum) {
        this.batchNum = batchNum;
    }

    @Length(min = 1, max = 32, message = "采样包编号长度必须介于 1 和 32 之间")
    public String getSamplingCode() {
        return samplingCode;
    }

    public void setSamplingCode(String samplingCode) {
        this.samplingCode = samplingCode;
    }

    @Length(min = 1, max = 16, message = "俱乐部id长度必须介于 1 和 16 之间")
    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

}