package com.cku.oa.order.service;

import com.cku.oa.order.vo.ChargingItemVo;
import com.cku.oa.order.vo.OrderBusinessVo;
import com.cku.oa.order.vo.OrderSkuVo;
import com.cku.restful.v2.order.vo.request.OrderApplyRequest;

import java.util.List;

/**
 * 商品服务基类
 *
 * @author yuanshuai
 * @date 2023/6/25 11:10
 */
public abstract class BaseSkuBusinessService<T extends OrderBusinessVo> implements ISkuBusinessService<T> {

    /**
     * 根据业务和商品更新收费项信息
     *
     * @param orderRequest 下单相关参数
     * @param businessList 业务具体参数
     * @param itemList     收费项List
     * @author yuanshuai
     * @date 2023/6/19 14:01
     */
    @Override
    public void processChargingItemPrice(OrderApplyRequest orderRequest, List<T> businessList, List<ChargingItemVo> itemList) {
    }

    /**
     * 根据业务和商品更新收费项业务表信息
     *
     * @param orderRequest 下单相关参数
     * @param skuVo        sku参数
     * @param itemList     收费项List
     * @author yuanshuai
     * @date 2023/6/19 14:01
     */
    @Override
    public void findChargingItemBusinessTableId(OrderApplyRequest orderRequest, OrderSkuVo skuVo, List<ChargingItemVo> itemList) {
    }

}
