package com.cku.oa.handler.web;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.handler.entity.HandlerScoreRanking;
import com.cku.oa.handler.service.HandlerScoreRankingService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

import net.sf.json.JSONObject;

/**
 * 牵犬师积分榜Controller
 * 
 * @author xx
 * @version 2022-06-06
 */
@Controller
@RequestMapping(value = "${adminPath}/handler/handlerScoreRanking")
public class HandlerScoreRankingController extends BaseController {

	@Autowired
	private HandlerScoreRankingService handlerScoreRankingService;

	@ModelAttribute
	public HandlerScoreRanking get(@RequestParam(required = false) String id) {
		HandlerScoreRanking entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = handlerScoreRankingService.get(id);
		}
		if (entity == null) {
			entity = new HandlerScoreRanking();
		}
		return entity;
	}

	@RequiresPermissions("handler:handlerScoreRanking:view")
	@RequestMapping(value = { "list", "" })
	public String list(HandlerScoreRanking handlerScoreRanking, HttpServletRequest request,
			HttpServletResponse response, Model model) {
		Page<HandlerScoreRanking> page = handlerScoreRankingService
				.findGroupedList(new Page<HandlerScoreRanking>(request, response), handlerScoreRanking);
		model.addAttribute("page", page);
		List<Integer> yearList = new ArrayList<>();
		for (int i = 2022; i <= LocalDate.now().getYear(); i++) {
			yearList.add(i);
		}
		model.addAttribute("yearList", yearList);
		List<Integer> monthList = new ArrayList<>();
		for (int i = 1; i <= 12; i++) {
			monthList.add(i);
		}
		model.addAttribute("monthList", monthList);
		return "oa/handler/handlerScoreRankingList";
	}

	@RequiresPermissions("handler:handlerScoreRanking:edit")
	@RequestMapping(value = "uploadForm")
	public String uploadForm(HandlerScoreRanking handlerScoreRanking, Model model) {
		model.addAttribute("handlerScoreRanking", handlerScoreRanking);
		List<Integer> yearList = new ArrayList<>();
		for (int i = 2022; i <= LocalDate.now().getYear(); i++) {
			yearList.add(i);
		}
		model.addAttribute("yearList", yearList);
		List<Integer> monthList = new ArrayList<>();
		for (int i = 1; i <= 12; i++) {
			monthList.add(i);
		}
		model.addAttribute("monthList", monthList);
		model.addAttribute("handlerScoreRanking", handlerScoreRanking);
		return "oa/handler/handlerScoreRankingUpload";
	}

	@RequiresPermissions("handler:handlerScoreRanking:edit")
	@RequestMapping(value = "upload")
	@ResponseBody
	public void upload(HandlerScoreRanking handlerScoreRanking, Model model, RedirectAttributes redirectAttributes,
			HttpServletResponse response) throws Exception {
		JSONObject result = new JSONObject();
		try {
			handlerScoreRankingService.upload(handlerScoreRanking);
			result.put("rc", 0);
		} catch (Exception e) {
			result.put("rc", 1);
			result.put("msg", e.getMessage());

		}
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(result.toString());

	}

	@RequiresPermissions("handler:handlerScoreRanking:edit")
	@RequestMapping(value = "uploadCheck")
	@ResponseBody
	public void uploadCheck(HandlerScoreRanking handlerScoreRanking, Model model, RedirectAttributes redirectAttributes,
			HttpServletResponse response) throws Exception {
		JSONObject result = new JSONObject();
		List<HandlerScoreRanking> list = handlerScoreRankingService.findList(handlerScoreRanking);
		if (list.size() == 0) {
			result.put("rc", 0);
		} else {
			result.put("rc", 1);
			String a = "Y".equals(handlerScoreRanking.getTableType())?"年": "Q".equals(handlerScoreRanking.getTableType())?"季":"月";
			result.put("msg", "本"+ a +"已有数据，是否覆盖？");

		}
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(result.toString());

	}

	@RequiresPermissions("handler:handlerScoreRanking:edit")
	@RequestMapping(value = "export")
	public String export(HandlerScoreRanking handlerScoreRanking, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		try {
			handlerScoreRankingService.export(handlerScoreRanking, response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出信息失败！失败信息：" + e.getMessage());
		}
		return null;
	}

	@RequiresPermissions("handler:handlerScoreRanking:edit")
	@RequestMapping(value = "delete")
	public String delete(HandlerScoreRanking handlerScoreRanking, RedirectAttributes redirectAttributes) {
		handlerScoreRankingService.delete(handlerScoreRanking);
		addMessage(redirectAttributes, "删除牵犬师积分榜成功");
		return "redirect:" + Global.getAdminPath() + "/handler/handlerScoreRanking/?repage";
	}

}