package com.cku.oa.handler.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;

/**
 * 牵犬师积分Entity
 * 
 * @author zxy
 * @version 2023-06-06
 */
public class RefereeRanking extends DataEntity<RefereeRanking> {
	
	private static final long serialVersionUID = 1L;
	@ExcelField(title="会员号", align=2, sort=1)
	private String memberCode; // 会员号
	@ExcelField(title="会员名", align=2, sort=2)
	private String memberName; // 会员名
	@ExcelField(title="批次号", align=2, sort=3)
	private String serialNum; // 批次号
	@ExcelField(title="积分", align=2, sort=4)
	private String rankingScore; // 积分
	@ExcelField(title="年份", align=2, sort=5)
	private String year; // 年份
	@ExcelField(title="类型", align=2, sort=6)
	private String type; // 类型 1:年度 2:季度 3:月
	@ExcelField(title="季度", align=2, sort=7)
	private String quarter; // 季度
	@ExcelField(title="月度", align=2, sort=8)
	private String month; // 月
	@ExcelField(title="半年度", align=2, sort=9)
	private String half; // 半年度


	public RefereeRanking() {
		super();
	}

	public RefereeRanking(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "会员号长度必须介于 0 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "会员名长度必须介于 0 和 64 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	@Length(min = 0, max = 64, message = "批次号长度必须介于 0 和 64 之间")
	public String getSerialNum() {
		return serialNum;
	}

	public void setSerialNum(String serialNum) {
		this.serialNum = serialNum;
	}

	@Length(min = 0, max = 8, message = "积分长度必须介于 0 和 8 之间")
	public String getRankingScore() {
		return rankingScore;
	}

	public void setRankingScore(String rankingScore) {
		this.rankingScore = rankingScore;
	}

	@Length(min = 0, max = 64, message = "年份长度必须介于 0 和 64 之间")
	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	@Length(min = 0, max = 64, message = "类型 1:年度 2:季度 3:月长度必须介于 0 和 64 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Length(min = 0, max = 64, message = "季度长度必须介于 0 和 64 之间")
	public String getQuarter() {
		return quarter;
	}

	public void setQuarter(String quarter) {
		this.quarter = quarter;
	}

	@Length(min = 0, max = 64, message = "月长度必须介于 0 和 64 之间")
	public String getMonth() {
		return month;
	}

	public void setMonth(String month) {
		this.month = month;
	}

	public String getHalf() {
		return half;
	}

	public void setHalf(String half) {
		this.half = half;
	}
	
	
}
