/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.handler.dao;

import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 资格证书DAO接口
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@MyBatisDao
public interface HandlerQualificationCertificateDao extends CrudDao<HandlerQualificationCertificate> {
	// 获取会员的最新级别
	List<HandlerQualificationCertificate> getLevel(String memberCode);

	// 生成资格证书号
	// 导出的数据
	void createCode(HandlerQualificationCertificate handlerQualificationCertificate);

	List<HandlerQualificationCertificate> getCertificateList(
			HandlerQualificationCertificate handlerQualificationCertificate);

	/**
	 * 保存资格证书
	 * 
	 * @Author chaixueteng
	 * @2016年8月24日下午3:07:15
	 */
	void saveCertificate(HandlerQualificationCertificate hqc);

	// 重置打印
	void resetPrint(HandlerQualificationCertificate handlerQualificationCertificate);

	// 打印
	HandlerQualificationCertificate print(String id);

	// 资格证书申请数
	int getHandlerQualificationCount();

	// 根据报名id获取资格证书信息
	HandlerQualificationCertificate getRegister(@Param("registerId") String registerId);

	// CKU官网 查询牵犬师资格证书
	List<HandlerQualificationCertificate> getByKey(String key);

	List<String> getABC(@Param("memberCode") String memberCode);

	List<HandlerQualificationCertificate> getByMemberCode(@Param("memberCode") String memberCode);

	List<HandlerQualificationCertificate> getPersonnel(HandlerQualificationCertificate handlerQualificationCertificate);
	
	List<HandlerQualificationCertificate> getBySchoolId(@Param("schoolName") String schoolName,@Param("endDate") String endDate);

	// 获取伴侣犬资格认证活动的会员的最新级别
	List<HandlerQualificationCertificate> getPartnerDogLevel(String memberCode);

	// CKU官网 查询训练师资格证书
	List<HandlerQualificationCertificate> getHandlerTrainerByKey(String key);

	List<HandlerQualificationCertificate> findTrainerListByCertificate(HandlerQualificationCertificate handlerQualificationCertificate);

	List<HandlerQualificationCertificate> eqCertificatepay(@Param("memberCode") String memberCode, @Param("levelEn") String levelEn, @Param("certificateType") String certificateType);

	List<HandlerQualificationCertificate> selectTrainerCertificateListByApp(HandlerQualificationCertificate handlerQualificationCertificate);

	List<HandlerQualificationCertificate> eqCertificateLevel(@Param("memberCode") String memberCode, @Param("levelEn") String levelEn, @Param("certificateType") String certificateType);
}