package com.cku.oa.groomer.web;

import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerCourseApplication;
import com.cku.oa.groomer.service.GroomerCourseApplicationService;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.cku.oa.groomer.service.GroomerDiplomaService;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.trainschool.dao.SchoolsTeacherDao;
import com.cku.oa.trainschool.dao.TrainingInstitutionDao;
import com.cku.schools.mrschool.service.OSSUtils;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 美容课程表Controller
 * @author cxt
 * @version 2017-06-19
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerCourse")
public class GroomerCourseController extends BaseController {

	@Autowired
	private GroomerCourseService groomerCourseService;
	@Autowired
	private TrainingInstitutionDao trainingInstitutionDao;
	@Autowired
	private GroomerDiplomaService groomerDiplomaService;
	@Autowired
	private SchoolsTeacherDao schoolsTeacherDao;
	@Autowired
	private GroomerCourseApplicationService groomerCourseApplicationService;
	@Autowired
	private MemberDao memberDao;

	@ModelAttribute
	public GroomerCourse get(@RequestParam(required=false) String id) {
		GroomerCourse entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = groomerCourseService.get(id);
		}
		if (entity == null){
			entity = new GroomerCourse();
		}
		return entity;
	}

	@RequiresPermissions("groomer:groomerCourse:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerCourse groomerCourse, HttpServletRequest request, HttpServletResponse response, Model model) {
		groomerCourse.setExcludeState("1");
		groomerCourse.setExcludeType("3");
		Page<GroomerCourse> page = groomerCourseService.findPage(new Page<GroomerCourse>(request, response), groomerCourse);
		//update by zhangjunwu  将过滤条件加入SQL，解决页面展示数据及分页bug
//        List<GroomerCourse> list = page.getList().stream().filter(a ->
//                !"1".equals(a.getStates()) && !"3".equals(a.getType())
//        ).collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(page.getList())) {
        	List<GroomerCourse> result = page.getList().stream().map(data->{
                data.setSchoolId(trainingInstitutionDao.get(data.getSchoolId()).getSchoolNameCn());
                if(StringUtils.isNotBlank(data.getVideo())){
                    data.setVideoUrl(OSSUtils.getVodUrl(data.getVideo()));
                }
                return data;
            }).collect(Collectors.toList());
        	page.setList(result);
        }
		model.addAttribute("page", page);
		return "oa/groomer/groomerCourseList";
	}
	@RequestMapping(value = "viewApply")
	public String viewApply(GroomerCourseApplication groomerCourseApplication, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerCourseApplication> page = groomerCourseApplicationService.findPage(new Page<GroomerCourseApplication>(request, response), groomerCourseApplication);
		model.addAttribute("page", page);
		model.addAttribute("groomerCourseApplication", groomerCourseApplication);
		if(StringUtils.isBlank(groomerCourseApplication.getCourseId())){
			return "oa/groomer/courseApplyList";
		}else{
			return "oa/groomer/courseApplyOneList";
		}
	}

	@RequestMapping("export")
	public void export(GroomerCourse groomerCourse,HttpServletResponse response, RedirectAttributes redirectAttributes){
		try {
			groomerCourseService.export(groomerCourse,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出信息失败！失败信息："+e.getMessage());
		}
	}
	@RequestMapping("exportApply")
	public String exportApply(GroomerCourseApplication groomerCourseApplication, HttpServletResponse response, RedirectAttributes redirectAttributes){
		try {
			groomerCourseApplicationService.exportApply(groomerCourseApplication,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出赛事信息失败！失败信息："+e.getMessage());
		}
		return null;
	}
	@RequestMapping(value = "groomerCourseApplicationDetail")
	public String groomerCourseApplicationDetail(String id, Model model) {
		GroomerCourseApplication groomerCourseApplication = groomerCourseApplicationService.get(id);
		GroomerCourse groomerCourse = groomerCourseService.get(groomerCourseApplication.getCourseId());
		model.addAttribute("groomerCourseApplication", groomerCourseApplication);
		model.addAttribute("groomerCourse", groomerCourse);
		return "oa/groomer/groomerCourseApplicationDetail";
	}


	@RequiresPermissions("groomer:groomerCourse:view")
	@RequestMapping(value = "form")
	public String form(GroomerCourse groomerCourse, Model model) {
		model.addAttribute("groomerCourse", groomerCourse);
		return "oa/groomer/groomerCourseForm";
	}
	@RequiresPermissions("groomer:groomerCourse:review")
	@RequestMapping(value = "review")
	public String review(GroomerCourse groomerCourse, Model model) {
		groomerCourseService.review(groomerCourse,model);
		model.addAttribute("groomerCourse", groomerCourse);
		return "oa/groomer/groomerCourseDetail";
	}
	@RequiresPermissions("groomer:groomerCourse:review")
	@RequestMapping(value = "offStates")
	public String offStates(GroomerCourse groomerCourse, Model model, RedirectAttributes redirectAttributes) {
		groomerCourseService.offStates(groomerCourse);
		model.addAttribute("groomerCourse", groomerCourse);
		addMessage(redirectAttributes, "美容课程下架成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerCourse/?repage";
	}
	@RequiresPermissions("groomer:groomerCourse:review")
	@RequestMapping(value = "saveReview")
	public String saveReview(GroomerCourse groomerCourse, Model model, RedirectAttributes redirectAttributes) {
		groomerCourseService.saveReview(groomerCourse);
		addMessage(redirectAttributes, "保存美容课程成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerCourse/?repage";
	}
	@RequiresPermissions("groomer:groomerCourse:edit")
	@RequestMapping(value = "save")
	public String save(GroomerCourse groomerCourse, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, groomerCourse)){
			return form(groomerCourse, model);
		}
		groomerCourseService.save(groomerCourse);
		addMessage(redirectAttributes, "保存美容课程成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerCourse/?repage";
	}

	@RequiresPermissions("groomer:groomerCourse:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerCourse groomerCourse, RedirectAttributes redirectAttributes) {
		groomerCourseService.delete(groomerCourse);
		addMessage(redirectAttributes, "删除美容课程成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerCourse/?repage";
	}

}