/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.vo;

import com.cku.oa.groomer.entity.FciGroomerQualificationCertificate;
import com.cku.oa.groomer.entity.GroomerRegister;
import com.cku.oa.groomer.entity.GroomerShow;
import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import com.thinkgem.jeesite.modules.sys.entity.User;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 美容师资格证书Entity
 * 
 * @author cxt
 * @version 2016-07-22
 */
public class FciGroomerQualificationCertificateVO extends DataEntity<FciGroomerQualificationCertificateVO> implements Serializable {

	private static final long serialVersionUID = 1L;
	@ExcelField(title = "id", align = 2, sort = 1)
	private String id;
	@ExcelField(title = "会员号", align = 2, sort = 7)
	private String memberCode; // 会员号
	private String registerId; // 报名序号
	@ExcelField(title = "姓名", align = 2, sort = 2)
	private String name; // 姓名
	private String namePinyin; // 姓名拼音
	@ExcelField(title = "性别", align = 2, sort = 3)
	private String gender; // 性别
	private String mobile;
	private String schoolNameCn; // 培训学校
	private String teacher; // 培训教师
	@ExcelField(title = "取证日期", align = 2, sort = 4)
	private Date takeCertificateDate; // 取证日期
	@ExcelField(title = "级别", align = 2, sort = 5)
	private String levelCn; // 级别中文
	private String levelEn; // 级别英文
	@ExcelField(title = "证书号", align = 2, sort = 6)
	private String fciCertificateCode; // 证书编号
	private Date issueDate; // 签发日期
	private String reviewer; // 审核人
	private String corsage; // 胸花
	private Date corsageTime; // 申领胸花时间
	private String receiveState; // 申领证书状态(已废除)
	private String printState; // 打印状态
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核原因
	private String runningNumber; // 流水号
	private String paymentState; // 支付状态
	private Date paymentTime; // 支付时间
	private Date proccessTime; // 处理时间
	private String proccessState; // 处理状态
	private GroomerRegister groomerRegister; // 报名表 一对一关联
	private GroomerShow groomerShow;
	private Member member; // 会员表
	private String certificateType;// 证书类型 资格证书、 高级 、宠物
	private String taskDate;
	private String issDate;
	private List<String> level;
	private String avatarBase64;
	private String showCategory;
	private String isFree;// 0 免费 1收费
	private String certificateState; // 申领状态
	// 查询条件
	private User registerCreateBy; // 报名操作人
	private List<String> levelCnList;
	// 是否可缴费判断条件
	private String schoolType;
	private String paper; // 0:纸质版 1:电子版

	private String referee;
	private String endFlag;

	/**
	 * 美容资格证书类型
	 * @See QualificationCertificateTypeEnum
	 * @return
	 */
	private Integer qualificationCertificateType;

	/**
	 * 证书来源
	 */
	private String certificateSource;

	/**
	 * FCI资格证书
	 * @return
	 */
	private FciGroomerQualificationCertificate fciGroomerQualificationCertificate;

	/**
	 * FCI证书申领失效时间
	 */
	private Date fciShowEndTime;

	private String fciPaymentState; // fci支付状态

	/**
	 * 审查员签名照
	 */
	private String refereeSignaturePicBase64;

	@ExcelField(title = "比赛犬种", align = 2, sort = 8)
	private String showDogBreed; // 比赛犬种

	public String getShowDogBreed() {
		return showDogBreed;
	}

	public void setShowDogBreed(String showDogBreed) {
		this.showDogBreed = showDogBreed;
	}

	public String getRefereeSignaturePicBase64() {
		return refereeSignaturePicBase64;
	}

	public void setRefereeSignaturePicBase64(String refereeSignaturePicBase64) {
		this.refereeSignaturePicBase64 = refereeSignaturePicBase64;
	}

	public String getFciPrintState() {
		return fciPrintState;
	}

	public void setFciPrintState(String fciPrintState) {
		this.fciPrintState = fciPrintState;
	}

	private String fciPrintState; // 打印状态

	public String getFciPaymentState() {
		return fciPaymentState;
	}

	public void setFciPaymentState(String fciPaymentState) {
		this.fciPaymentState = fciPaymentState;
	}

	public Date getFciShowEndTime() {
		return fciShowEndTime;
	}

	public void setFciShowEndTime(Date fciShowEndTime) {
		this.fciShowEndTime = fciShowEndTime;
	}

	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	public String getSchoolType() {
		return schoolType;
	}

	public void setSchoolType(String schoolType) {
		this.schoolType = schoolType;
	}

	public List<String> getLevelCnList() {
		return levelCnList;
	}

	public void setLevelCnList(List<String> levelCnList) {
		this.levelCnList = levelCnList;
	}

	public User getRegisterCreateBy() {
		return registerCreateBy;
	}

	public void setRegisterCreateBy(User registerCreateBy) {
		this.registerCreateBy = registerCreateBy;
	}

	public String getAvatarBase64() {
		return avatarBase64;
	}

	public void setAvatarBase64(String avatarBase64) {
		this.avatarBase64 = avatarBase64;
	}

	public String getTaskDate() {
		return taskDate;
	}

	public void setTaskDate(String taskDate) {
		this.taskDate = taskDate;
	}

	public String getIssDate() {
		return issDate;
	}

	public void setIssDate(String issDate) {
		this.issDate = issDate;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public FciGroomerQualificationCertificateVO() {
		super();
	}

	public FciGroomerQualificationCertificateVO(String id) {
		super(id);
	}

	public String getId() {
		return super.id;
	}

	public void setId(String id) {
		super.id = id;
	}

	@Length(min = 1, max = 100, message = "会员号长度必须介于 1 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 0, max = 64, message = "姓名长度必须介于 0 和 64 之间")
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getRegisterId() {
		return registerId;
	}

	public void setRegisterId(String registerId) {
		this.registerId = registerId;
	}

	@Length(min = 0, max = 64, message = "姓名拼音长度必须介于 0 和 64 之间")
	public String getNamePinyin() {
		return namePinyin;
	}

	public void setNamePinyin(String namePinyin) {
		this.namePinyin = namePinyin;
	}

	@Length(min = 0, max = 20, message = "性别长度必须介于 0 和 20 之间")
	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getMobile() {
		return mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	@Length(min = 0, max = 100, message = "培训学校长度必须介于 0 和 100 之间")
	public String getSchoolNameCn() {
		return schoolNameCn;
	}

	public void setSchoolNameCn(String schoolNameCn) {
		this.schoolNameCn = schoolNameCn;
	}

	@Length(min = 0, max = 64, message = "培训教师长度必须介于 0 和 64 之间")
	public String getTeacher() {
		return teacher;
	}

	public void setTeacher(String teacher) {
		this.teacher = teacher;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getTakeCertificateDate() {
		return takeCertificateDate;
	}

	public void setTakeCertificateDate(Date takeCertificateDate) {
		this.takeCertificateDate = takeCertificateDate;
	}

	@Length(min = 0, max = 64, message = "级别中文长度必须介于 0 和 64 之间")
	public String getLevelCn() {
		return levelCn;
	}

	public void setLevelCn(String levelCn) {
		this.levelCn = levelCn;
	}

	@Length(min = 0, max = 64, message = "级别英文长度必须介于 0 和 64 之间")
	public String getLevelEn() {
		return levelEn;
	}

	public void setLevelEn(String levelEn) {
		this.levelEn = levelEn;
	}

	@Length(min = 0, max = 64, message = "证书编号长度必须介于 0 和 64 之间")
	public String getFciCertificateCode() {
		return fciCertificateCode;
	}

	public void setFciCertificateCode(String fciCertificateCode) {
		this.fciCertificateCode = fciCertificateCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}

	@Length(min = 0, max = 64, message = "审核人长度必须介于 0 和 64 之间")
	public String getReviewer() {
		return reviewer;
	}

	public void setReviewer(String reviewer) {
		this.reviewer = reviewer;
	}

	@Length(min = 0, max = 64, message = "胸花长度必须介于 0 和 64 之间")
	public String getCorsage() {
		return corsage;
	}

	public void setCorsage(String corsage) {
		this.corsage = corsage;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCorsageTime() {
		return corsageTime;
	}

	public void setCorsageTime(Date corsageTime) {
		this.corsageTime = corsageTime;
	}

	@Length(min = 0, max = 20, message = "申领证书状态长度必须介于 0 和 20 之间")
	public String getReceiveState() {
		return receiveState;
	}

	public void setReceiveState(String receiveState) {
		this.receiveState = receiveState;
	}

	@Length(min = 0, max = 20, message = "打印状态长度必须介于 0 和 20 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}

	@Length(min = 0, max = 64, message = "审核状态长度必须介于 0 和 64 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 0, max = 64, message = "审核原因长度必须介于 0 和 64 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 0, max = 64, message = "流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProccessTime() {
		return proccessTime;
	}

	public void setProccessTime(Date proccessTime) {
		this.proccessTime = proccessTime;
	}

	@Length(min = 0, max = 64, message = "处理状态长度必须介于 0 和 64 之间")
	public String getProccessState() {
		return proccessState;
	}

	public void setProccessState(String proccessState) {
		this.proccessState = proccessState;
	}

	public GroomerRegister getGroomerRegister() {
		return groomerRegister;
	}

	public void setGroomerRegister(GroomerRegister groomerRegister) {
		this.groomerRegister = groomerRegister;
	}

	public GroomerShow getGroomerShow() {
		return groomerShow;
	}

	public void setGroomerShow(GroomerShow groomerShow) {
		this.groomerShow = groomerShow;
	}

	public List<String> getLevel() {
		return level;
	}

	public void setLevel(List<String> level) {
		this.level = level;
	}

	public String getShowCategory() {
		return showCategory;
	}

	public void setShowCategory(String showCategory) {
		this.showCategory = showCategory;
	}

	public String getCertificateType() {
		return certificateType;
	}

	public void setCertificateType(String certificateType) {
		this.certificateType = certificateType;
	}

	public String getIsFree() {
		return isFree;
	}

	public void setIsFree(String isFree) {
		this.isFree = isFree;
	}

	public String getCertificateState() {
		return certificateState;
	}

	public void setCertificateState(String certificateState) {
		this.certificateState = certificateState;
	}

	public String getPaper() {
		return paper;
	}

	public void setPaper(String paper) {
		this.paper = paper;
	}

	public String getEndFlag() {
		return endFlag;
	}

	public void setEndFlag(String endFlag) {
		this.endFlag = endFlag;
	}

	public Integer getQualificationCertificateType() {
		return qualificationCertificateType;
	}

	public void setQualificationCertificateType(Integer qualificationCertificateType) {
		this.qualificationCertificateType = qualificationCertificateType;
	}

	public FciGroomerQualificationCertificate getFciGroomerQualificationCertificate() {
		return fciGroomerQualificationCertificate;
	}

	public void setFciGroomerQualificationCertificate(FciGroomerQualificationCertificate fciGroomerQualificationCertificate) {
		this.fciGroomerQualificationCertificate = fciGroomerQualificationCertificate;
	}

	public String getCertificateSource() {
		return certificateSource;
	}

	public void setCertificateSource(String certificateSource) {
		this.certificateSource = certificateSource;
	}
}