package com.cku.oa.groomer.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.groomer.dao.GroomerPackageDao;
import com.cku.oa.groomer.entity.GroomerPackage;
import com.cku.oa.groomer.vo.GroomerPackageVO;
import com.cku.thirdparty.oss.OssApiClient;
import com.cku.thirdparty.oss.OssUploadResult;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;

/**
 * 美容套餐Service
 * 
 * @author xx
 * @version 2020-05-26
 */
@Service
@Transactional(readOnly = true)
public class GroomerPackageService extends CrudService<GroomerPackageDao, GroomerPackage> {

	@Autowired
	private OssApiClient ossApiClient;
	
	public GroomerPackage get(String id) {
		return super.get(id);
	}

	public List<GroomerPackage> findList(GroomerPackage groomerPackage) {
		return super.findList(groomerPackage);
	}

	public Page<GroomerPackage> findPage(Page<GroomerPackage> page, GroomerPackage groomerPackage) {
		return super.findPage(page, groomerPackage);
	}

	@Transactional(readOnly = false)
	public void save(GroomerPackage groomerPackage) {
		super.save(groomerPackage);
	}

	@Transactional(readOnly = false)
	public void delete(GroomerPackage groomerPackage) {
		super.delete(groomerPackage);
	}

	@Transactional(readOnly = false)
	public Integer getMaxApplyCode() {
		return dao.getMaxApplyCode();
	}

	@Transactional(readOnly = false)
	public void toReImage(GroomerPackage groomerPackage) throws Exception {
		// 上传服务器
		OssUploadResult result = ossApiClient.upload(groomerPackage.getAvatarFile(),"groomerPackage");
		GroomerPackage vo = dao.get(groomerPackage.getId());
		vo.setId(groomerPackage.getId());
		vo.setAvatar(result.getUploadUrl());
		dao.update(vo);

	}

	public void export(GroomerPackage groomerPackage, HttpServletResponse response) throws IOException {

		List<GroomerPackage> grList = dao.findAllList(groomerPackage);
		for (GroomerPackage gr : grList) {
			gr.setGender("male".equals(gr.getGender()) ? "男" : "女");
			gr.setPaymentState("2".equals(gr.getPaymentState()) ? "已缴费" : "未缴费");
			gr.setGrade(null);
		}
		new ExportExcel("", GroomerPackage.class, 1).setDataList(grList).write(response, "美容组合套餐报名信息表.xlsx").dispose();
	}

	public void exportGrade(GroomerPackage groomerPackage, HttpServletResponse response) throws Exception {

		List<GroomerPackage> grList = dao.findAllList(groomerPackage);
		List<GroomerPackageVO> grList2 = new ArrayList<>();
		for (GroomerPackage gr : grList) {
			GroomerPackageVO vo = new GroomerPackageVO();
			BeanUtils.copyProperties(vo, gr);
			vo.setGender("male".equals(gr.getGender()) ? "男" : "女");
			vo.setPaymentState("2".equals(gr.getPaymentState()) ? "已缴费" : "未缴费");
			vo.setGrade("0".equals(gr.getGrade()) ? "待审核" : ("1".equals(gr.getGrade()) ? "未通过" : "已通过"));
			grList2.add(vo);
		}

		new ExportExcel("", GroomerPackageVO.class, 1).setDataList(grList2).write(response, "美容组合套餐报名成绩表.xlsx")
				.dispose();
	}

}