package com.cku.oa.groomer.enums;

import com.cku.oa.sys.entity.user.IEnum;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 美容证书级别枚举
 * @author hjx
 */
public enum DogCategorysEnum implements IEnum<String> {

	KANE_TERRIER( "凯恩梗犬", "4", 1, "小型犬", "拔毛犬组"),

	BORDER_TERRIER("边境梗犬", "10", 1, "小型犬", "拔毛犬组"),

	DANDY_DINGMENG_TERRIER("丹迪丁萌梗犬", "168", 1, "小型犬", "拔毛犬组"),

	JACK_RUSSELL_TERRIER("杰克罗素梗犬", "345", 1, "小型犬", "拔毛犬组"),

	MINIATURE_SCHNAUZER("迷你雪纳瑞犬", "183", 1, "小型犬", "拔毛犬组"),

	NORWICH_TERRIER("诺维奇梗犬", "72", 1, "小型犬", "拔毛犬组"),

	NORFOLK_TERRIER("诺福克梗犬", "272", 1, "小型犬", "拔毛犬组"),

	XILIN_HAN_TERRIER("西林汉梗犬", "74", 1, "小型犬", "拔毛犬组"),

	SCOTLAND_TERRIER("苏格兰梗犬", "73", 1, "小型犬", "拔毛犬组"),

	WEST_HIGHLAND_WHITE_TERRIER("西高地白梗犬", "85", 1, "小型犬", "拔毛犬组"),

	IRISH_TERRIER("爱尔兰梗犬", "139", 1, "中型犬", "拔毛犬组"),

	LAKESIDE_TERRIER("湖畔梗犬", "70", 1, "中型犬", "拔毛犬组"),

	STANDARD_SCHNAUZER("标准雪纳瑞犬", "182", 1, "中型犬", "拔毛犬组"),

	WELSH_TERRIER("威尔士梗犬", "78", 1, "中型犬", "拔毛犬组"),

	HARD_HAIRED_FOX_TERRIER("刚毛猎狐挭犬", "169", 1, "中型犬", "拔毛犬组"),

	UNIVERSAL_TERRIER("万能梗犬", "7", 1, "大型犬", "拔毛犬组"),

	GIANT_SCHNAUZER("巨型雪纳瑞犬", "181", 1, "大型犬", "拔毛犬组"),

	AMERICAN_COCKER_DOG("美国可卡犬", "167", 2, "大型犬", "猎犬和蹲猎犬组"),

	COCKER_SPANIEL("英国可卡犬", "5", 2, "大型犬", "猎犬和蹲猎犬组"),

	ENGLISH_SPRINGER_SPANIEL("英国史宾格犬", "125", 2, "大型犬", "猎犬和蹲猎犬组"),

	RED_SETTER("爱尔兰蹲猎犬", "120", 2, "大型犬", "猎犬和蹲猎犬组"),

	ENGLISH_SETTER("英国蹲猎犬", "2", 2, "大型犬", "猎犬和蹲猎犬组"),

	GORDON_SETTER("戈登蹲猎犬", "6", 2, "大型犬", "猎犬和蹲猎犬组"),

	STANDARD_POODLE("标准贵宾犬", null, 3, "大型犬", "贵宾犬组"),

	MEDIUM_POODLE("中型贵宾犬", null, 3, "中型犬", "贵宾犬组"),

	MINI_POODLE("迷你贵宾犬", null, 3, "小型犬", "贵宾犬组"),

	TOY_POODLE("玩具贵宾犬", null, 3, "小型犬", "贵宾犬组"),

	BICHON_FRISE("比熊犬", "215", 4, null, "纯种剪毛犬组"),

	BELLINGTON_TERRIER("贝灵顿梗犬", "9", 4, null, "纯种剪毛犬组"),

	KELLY_BLUE_TERRIER("凯利蓝梗犬", "3", 4, null, "纯种剪毛犬组"),

	RUSSIAN_BLACK_TERRIER("俄罗斯黑梗犬", "327", 4, null, "纯种剪毛犬组"),

	FLANDERS_BULLDOG("弗兰德斯牧牛犬", "191", 4, null, "纯种剪毛犬组"),

	IRISH_SOFT_HAIRED_WHEAT_TERRIER("爱尔兰软毛麦色梗犬", "40", 4, null, "纯种剪毛犬组"),

	OTHER("其他犬种", null, 5, null, "其他犬种组"),

	;

	private String dogCategoryName;

	private String code;

	private Integer category;

	private String somatoType;

	private String categoryName;

	public String getDogCategoryName() {
		return dogCategoryName;
	}

	public void setDogCategoryName(String dogCategoryName) {
		this.dogCategoryName = dogCategoryName;
	}


	DogCategorysEnum(String dogCategoryName, String code, Integer category, String somatoType, String categoryName) {
		this.dogCategoryName = dogCategoryName;
		this.code = code;
		this.category = category;
		this.somatoType = somatoType;
		this.categoryName = categoryName;
	}

	public static DogCategorysEnum getCode(String level) {
		for (DogCategorysEnum value : DogCategorysEnum.values()) {
			if (Objects.equals(value.getDogCategoryName(), level)) {
				return value;
			}
		}
		return null;
	}

	public static List<DogCategorysEnum> getByCategory(Integer category) {
		List<DogCategorysEnum> dogCategorysEnums = new ArrayList<>();
		for (DogCategorysEnum value : DogCategorysEnum.values()) {
			if (Objects.equals(value.getCategory(), category)) {
				dogCategorysEnums.add(value);
			}
		}
		return dogCategorysEnums;
	}

	public static List<String> getByCategoryName() {
		List<String> dogCategorys = new ArrayList<>();
		for (DogCategorysEnum value : DogCategorysEnum.values()) {
			dogCategorys.add(value.getDogCategoryName());
		}
		return dogCategorys;
	}

	public static DogCategorysEnum getByDogCategoryName(String dogCategoryName) {

		for (DogCategorysEnum value : DogCategorysEnum.values()) {
			if (value.getDogCategoryName().contains(dogCategoryName)) {
				return value;
			}
		}
		return DogCategorysEnum.OTHER;

	}

	@Override
	public String code() {
		return this.code;
	}

	@Override
	public String message() {
		return this.dogCategoryName;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public Integer getCategory() {
		return category;
	}

	public void setCategory(Integer category) {
		this.category = category;
	}

	public String getSomatoType() {
		return somatoType;
	}

	public void setSomatoType(String somatoType) {
		this.somatoType = somatoType;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}
}
