package com.cku.oa.groomer.entity;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

@ApiModel
@Data
public class Curriculum extends DataEntity<Curriculum> {
    private static final long serialVersionUID = 1L;
    @Length(min=1, max=64, message="序号不能为空")
    private String curriculumIndex;
    @Length(min=1, max=64, message="课程名称不能为空")
    private String curriculumName;
    @Length(min=1, max=64, message="类型不能为空")
    private String curriculumType;
    private String recommend;//推荐
    @Length(min=1, max=255, message="banner图素材不能为空")
    private String curriculumPicture;
    @Length(min=1, max=64, message="跳转课程不能为空")
    private String curriculumJump;
    @Length(min=1, max=64, message="banner图连接不能为空")
    private String curriculumHref;
    //课程
    private GroomerCourse groomerCourse;
}
