/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.dao;

import com.cku.oa.groomer.entity.GroomerDiploma;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 美容师结业证书DAO接口
 * @author cxt
 * @version 2016-07-15
 */
@MyBatisDao
public interface GroomerDiplomaDao extends CrudDao<GroomerDiploma> {
	//审核通过
	void review(GroomerDiploma groomerDiploma);
	void createCode(GroomerDiploma groomerDiploma);
	//获取培训信息
	GroomerDiploma getTrain(String memberCode);
	//导出结业证书数据
	List<GroomerDiploma> getCertificateList(GroomerDiploma groomerDiploma);
	//获取结业证书等级
	String getLevel(String memberCode);
	//更改打印状态
	void resetPrint(GroomerDiploma groomerDiploma);
	//已缴费 未审核
	int getAuditCount(GroomerDiploma groomerDiploma);
	GroomerDiploma getByMemberCode(@Param("memberCode")String memberCode);
	List<GroomerDiploma> findByMemberCode(@Param("memberCode")String memberCode);
	//CKU官网美容结业证书查询
	List<GroomerDiploma> getByKey(@Param("key")String key);
	// 学校端 查询课程下是否有结业记录
	GroomerDiploma haveDiploma(@Param("groomerCourseId")String groomerCourseId);

	GroomerDiploma getByMemberCodeAndCourseId(@Param("memberCode")String memberCode, @Param("groomerCourseId")String groomerCourseId);
}